;;;; -*- Mode: lisp -*-
;;;;
;;;; Copyright (c) 2007 Raymond Toy
;;;;
;;;; Permission is hereby granted, free of charge, to any person
;;;; obtaining a copy of this software and associated documentation
;;;; files (the "Software"), to deal in the Software without
;;;; restriction, including without limitation the rights to use,
;;;; copy, modify, merge, publish, distribute, sublicense, and/or sell
;;;; copies of the Software, and to permit persons to whom the
;;;; Software is furnished to do so, subject to the following
;;;; conditions:
;;;;
;;;; The above copyright notice and this permission notice shall be
;;;; included in all copies or substantial portions of the Software.
;;;;
;;;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;;;; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
;;;; OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
;;;; NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
;;;; HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
;;;; WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;;;; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;;;; OTHER DEALINGS IN THE SOFTWARE.

(in-package #:qdi)

(defconstant +qd-zero+
  (make-qd-d 0d0))

(defconstant +qd-one+
  (make-qd-d 1d0))

(defconstant +qd-2pi+
  (%make-qd-d (scale-float (float 7074237752028440 1.0d0) -50)
            (scale-float (float 4967757600021511 1.0d0) -104)
            (scale-float (float -8753721960665020 1.0d0) -160)
            (scale-float (float 5857755168774013 1.0d0) -214)))

;; 3.1415926535897932384626433832795028841971693993751058209749445923078L0
(defconstant +qd-pi+
  (%make-qd-d (scale-float (float 7074237752028440 1.0d0) -51)
            (scale-float (float 4967757600021511 1.0d0) -105)
            (scale-float (float -8753721960665020 1.0d0) -161)
            (scale-float (float 5857755168774013 1.0d0) -215)))

(defconstant +qd-pi/2+
  (%make-qd-d (scale-float (float 7074237752028440 1.0d0) -52)
            (scale-float (float 4967757600021511 1.0d0) -106)
            (scale-float (float -8753721960665020 1.0d0) -162)
            (scale-float (float 5857755168774013 1.0d0) -216)))

(defconstant +qd-pi/4+
  (%make-qd-d (scale-float (float 7074237752028440 1.0d0) -53)
            (scale-float (float 4967757600021511 1.0d0) -107)
            (scale-float (float -8753721960665020 1.0d0) -163)
            (scale-float (float 5857755168774013 1.0d0) -217)))

(defconstant +qd-3pi/4+
  (%make-qd-d (scale-float (float 5305678314021330 1.0d0) -51)
            (scale-float (float 7451636400032266 1.0d0) -106)
            (scale-float (float 5724553519491610 1.0d0) -160)
            (scale-float (float -6810541066450736 1.0d0) -214)))

(defconstant +qd-pi/1024+
  (%make-qd-d (scale-float (float 7074237752028440 1.0d0) -61)
            (scale-float (float 4967757600021511 1.0d0) -115)
            (scale-float (float -8753721960665020 1.0d0) -171)
            (scale-float (float 5857755168774013 1.0d0) -225)))

(defconstant +qd-e+
  (%make-qd-d (scale-float (float 6121026514868073 1.0d0) -51)
            (scale-float (float 5864240480059706 1.0d0) -105)
            (scale-float (float -6219324074349538 1.0d0) -161)
            (scale-float (float 7980724272743020 1.0d0) -215)))

;; 0.6931471805599453094172321214581765680755001343602552541206800094934L0
(defconstant +qd-log2+
  #+nil
  (make-qd-d 6.931471805599452862d-01
	     2.319046813846299558d-17
	     5.707708438416212066d-34
	     -3.582432210601811423d-50)
  (%make-qd-d (scale-float (float 6243314768165359 1.0d0) -53)
            (scale-float (float 7525737178955839 1.0d0) -108)
            (scale-float (float 6673460182522164 1.0d0) -163)
            (scale-float (float -7545482916914656 1.0d0) -217)))

;; The rest of log(2) such that (+ +qd-log2+ +qd-log2-extra+) is
;; log(2) to twice the precision of a quad-double.
(defconstant +qd-log2-extra+
  #+nil
  (make-qd-d (scale-float (float 4141960528156623 1d0) (- -53 212))
	     (scale-float (float 3973120087747366 1d0) (- -106 212))
	     (scale-float (float 752798645508048 1d0) (- -159 212))
	     (scale-float (float 7618435247650241 1d0) (- -212 212)))
  (%make-qd-d (scale-float (float 8283921056313247 1.0d0) -266)
            (scale-float (float -8487672633970079 1.0d0) -322)
            (scale-float (float 6075158146775579 1.0d0) -376)
            (scale-float (float 4764384374407424 1.0d0) -432)))

(defconstant +qd-log10+
  (%make-qd-d (scale-float (float 5184960683398422 1.0d0) -51)
            (scale-float (float -8805633374462953 1.0d0) -105)
            (scale-float (float -7296007962371596 1.0d0) -159)
            (scale-float (float -5296362421624049 1.0d0) -213)))

(defconstant +qd-eps+
  (scale-float 1d0 -209))

(defconstant +qd-sin-table+
  (make-array 256
	      :initial-contents
	      (list
	       (%make-qd-d (scale-float (float 7074226654454970 1.0d0) -61)
			   (scale-float (float 5271335698347442 1.0d0) -115)
			   (scale-float (float 7913822574154586 1.0d0) -170)
			   (scale-float (float -4804352564403217 1.0d0) -224))
	       (%make-qd-d (scale-float (float 7074193361797233 1.0d0) -60)
			   (scale-float (float 7522205695703707 1.0d0) -116)
			   (scale-float (float 7787047147324868 1.0d0) -175)
			   (scale-float (float -6728650631839117 1.0d0) -232))
	       (%make-qd-d (scale-float (float 5305603405682435 1.0d0) -59)
			   (scale-float (float -5041342953893321 1.0d0) -115)
			   (scale-float (float 8335474310793984 1.0d0) -170)
			   (scale-float (float 6743025479788607 1.0d0) -225))
	       (%make-qd-d (scale-float (float 7074060192106372 1.0d0) -59)
			   (scale-float (float 7185921569156509 1.0d0) -113)
			   (scale-float (float -6016799991653399 1.0d0) -170)
			   (scale-float (float -5577663458559350 1.0d0) -224))
	       (%make-qd-d (scale-float (float 8842450394781643 1.0d0) -59)
			   (scale-float (float -8771095658131507 1.0d0) -113)
			   (scale-float (float 8705573170983202 1.0d0) -167)
			   (scale-float (float -4692271881407162 1.0d0) -221))
	       (%make-qd-d (scale-float (float 5305378684473085 1.0d0) -58)
			   (scale-float (float 7704904742673764 1.0d0) -113)
			   (scale-float (float 7308626221243388 1.0d0) -167)
			   (scale-float (float 4905810005485122 1.0d0) -223))
	       (%make-qd-d (scale-float (float 6189482235310630 1.0d0) -58)
			   (scale-float (float -4715432182777116 1.0d0) -113)
			   (scale-float (float -8243063834437948 1.0d0) -168)
			   (scale-float (float 8566398131092182 1.0d0) -222))
	       (%make-qd-d (scale-float (float 7073527528384126 1.0d0) -58)
			   (scale-float (float -7632135562854704 1.0d0) -116)
			   (scale-float (float 7289253486557291 1.0d0) -170)
			   (scale-float (float -7590289326531904 1.0d0) -224))
	       (%make-qd-d (scale-float (float 7957506242722589 1.0d0) -58)
			   (scale-float (float -8272553670927212 1.0d0) -112)
			   (scale-float (float -6591995918745221 1.0d0) -166)
			   (scale-float (float -4636857096009409 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8841410057981697 1.0d0) -58)
			   (scale-float (float -5627969559234246 1.0d0) -118)
			   (scale-float (float -5998146560009404 1.0d0) -171)
			   (scale-float (float -8771421402740511 1.0d0) -225))
	       (%make-qd-d (scale-float (float 4862615327261055 1.0d0) -57)
			   (scale-float (float -5217239170857332 1.0d0) -111)
			   (scale-float (float -6336246586437174 1.0d0) -165)
			   (scale-float (float 5522987872330073 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5304479856743885 1.0d0) -57)
			   (scale-float (float 6340842145528512 1.0d0) -113)
			   (scale-float (float -7566831660699656 1.0d0) -167)
			   (scale-float (float -7114412056121165 1.0d0) -221))
	       (%make-qd-d (scale-float (float 5746294458442105 1.0d0) -57)
			   (scale-float (float 4845186982751657 1.0d0) -113)
			   (scale-float (float 6382779118838290 1.0d0) -167)
			   (scale-float (float 8090523197847278 1.0d0) -221))
	       (%make-qd-d (scale-float (float 6188054973828419 1.0d0) -57)
			   (scale-float (float 7360584602593505 1.0d0) -111)
			   (scale-float (float 7946504576809704 1.0d0) -165)
			   (scale-float (float 5731224328660037 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6629757244884614 1.0d0) -57)
			   (scale-float (float -5806448969106076 1.0d0) -112)
			   (scale-float (float 7037190739826080 1.0d0) -166)
			   (scale-float (float 5552037724818900 1.0d0) -223))
	       (%make-qd-d (scale-float (float 7071397114140692 1.0d0) -57)
			   (scale-float (float -7057477599664784 1.0d0) -113)
			   (scale-float (float -8290828586102809 1.0d0) -167)
			   (scale-float (float -6697971486035361 1.0d0) -222))
	       (%make-qd-d (scale-float (float 7512970424714007 1.0d0) -57)
			   (scale-float (float -6294023145184360 1.0d0) -111)
			   (scale-float (float -6395720725273163 1.0d0) -165)
			   (scale-float (float -7071774105018818 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7954473020348387 1.0d0) -57)
			   (scale-float (float -6926679705961747 1.0d0) -112)
			   (scale-float (float -6427721451859560 1.0d0) -167)
			   (scale-float (float 8028310015339695 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8395900745453257 1.0d0) -57)
			   (scale-float (float 4839201044457661 1.0d0) -114)
			   (scale-float (float 5799570435052711 1.0d0) -171)
			   (scale-float (float -5529353034270453 1.0d0) -226))
	       (%make-qd-d (scale-float (float 8837249445142752 1.0d0) -57)
			   (scale-float (float -5314952832401406 1.0d0) -113)
			   (scale-float (float -7992910057771694 1.0d0) -167)
			   (scale-float (float 8886165424019995 1.0d0) -221))
	       (%make-qd-d (scale-float (float 4639257482637412 1.0d0) -56)
			   (scale-float (float -5494228531443205 1.0d0) -110)
			   (scale-float (float 6222043711193090 1.0d0) -167)
			   (scale-float (float 4966112393074763 1.0d0) -221))
	       (%make-qd-d (scale-float (float 4859846576245171 1.0d0) -56)
			   (scale-float (float -8985502920124077 1.0d0) -110)
			   (scale-float (float 7440463379940699 1.0d0) -165)
			   (scale-float (float -6641325637598524 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5080389927126093 1.0d0) -56)
			   (scale-float (float -8898661047761268 1.0d0) -110)
			   (scale-float (float -4667727006484474 1.0d0) -164)
			   (scale-float (float 8478536563323652 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5300885459442166 1.0d0) -56)
			   (scale-float (float -7213383224879916 1.0d0) -111)
			   (scale-float (float -8534269322822802 1.0d0) -166)
			   (scale-float (float -6601733372219099 1.0d0) -221))
	       (%make-qd-d (scale-float (float 5521331097805465 1.0d0) -56)
			   (scale-float (float 4829604598179156 1.0d0) -114)
			   (scale-float (float -7893599535446481 1.0d0) -172)
			   (scale-float (float -5384211130874634 1.0d0) -226))
	       (%make-qd-d (scale-float (float 5741724767297686 1.0d0) -56)
			   (scale-float (float -5824155811343436 1.0d0) -110)
			   (scale-float (float 6673985610265747 1.0d0) -164)
			   (scale-float (float 4800782739249759 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5962064393489674 1.0d0) -56)
			   (scale-float (float 7651360099479755 1.0d0) -112)
			   (scale-float (float 6974817744235260 1.0d0) -167)
			   (scale-float (float 7824970858345265 1.0d0) -224))
	       (%make-qd-d (scale-float (float 6182347902460953 1.0d0) -56)
			   (scale-float (float -8796242544913562 1.0d0) -111)
			   (scale-float (float -7546272905440146 1.0d0) -165)
			   (scale-float (float 6512061516709508 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6402573220819241 1.0d0) -56)
			   (scale-float (float -4868008820827392 1.0d0) -110)
			   (scale-float (float 8779206749884591 1.0d0) -164)
			   (scale-float (float -8648470131210884 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6622738275719969 1.0d0) -56)
			   (scale-float (float 6182934508221337 1.0d0) -110)
			   (scale-float (float 7353282250945404 1.0d0) -165)
			   (scale-float (float -8166192353391047 1.0d0) -220))
	       (%make-qd-d (scale-float (float 6842840994885793 1.0d0) -56)
			   (scale-float (float -8552477024466766 1.0d0) -110)
			   (scale-float (float -4997427595980002 1.0d0) -164)
			   (scale-float (float 5821398332046138 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7062879306626092 1.0d0) -56)
			   (scale-float (float -8487236864497288 1.0d0) -112)
			   (scale-float (float -4942162982072151 1.0d0) -168)
			   (scale-float (float -4811145377091453 1.0d0) -223))
	       (%make-qd-d (scale-float (float 7282851139856476 1.0d0) -56)
			   (scale-float (float 8609951212389606 1.0d0) -111)
			   (scale-float (float -5614142183842944 1.0d0) -165)
			   (scale-float (float 6068416796043208 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7502754424118275 1.0d0) -56)
			   (scale-float (float 8536169017599928 1.0d0) -110)
			   (scale-float (float 7981550951145323 1.0d0) -165)
			   (scale-float (float -8340622458345952 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7722587089598028 1.0d0) -56)
			   (scale-float (float 8362719068102409 1.0d0) -110)
			   (scale-float (float -7853008551658302 1.0d0) -166)
			   (scale-float (float -6852498985157079 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7942347067146965 1.0d0) -56)
			   (scale-float (float -5897359216343841 1.0d0) -113)
			   (scale-float (float 7767443765766550 1.0d0) -169)
			   (scale-float (float 8203371449514667 1.0d0) -225))
	       (%make-qd-d (scale-float (float 8162032288300481 1.0d0) -56)
			   (scale-float (float 7035687121204020 1.0d0) -111)
			   (scale-float (float 5733124558862890 1.0d0) -168)
			   (scale-float (float 6681272325774503 1.0d0) -223))
	       (%make-qd-d (scale-float (float 8381640685297609 1.0d0) -56)
			   (scale-float (float 5345425417737710 1.0d0) -112)
			   (scale-float (float -8790124191829010 1.0d0) -166)
			   (scale-float (float 7297964455931531 1.0d0) -225))
	       (%make-qd-d (scale-float (float 8601170191100479 1.0d0) -56)
			   (scale-float (float -5127404751534987 1.0d0) -110)
			   (scale-float (float 8258618371098839 1.0d0) -164)
			   (scale-float (float 6354475203379338 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8820618739413774 1.0d0) -56)
			   (scale-float (float 7361249450583405 1.0d0) -111)
			   (scale-float (float 8489175872343797 1.0d0) -165)
			   (scale-float (float -4838736209868180 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4519992132352091 1.0d0) -55)
			   (scale-float (float 6319901705801489 1.0d0) -110)
			   (scale-float (float 5600764727998866 1.0d0) -166)
			   (scale-float (float -5650573825026412 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4629632351109917 1.0d0) -55)
			   (scale-float (float 4958462282897610 1.0d0) -110)
			   (scale-float (float -8711719640720475 1.0d0) -165)
			   (scale-float (float -8191834096705166 1.0d0) -221))
	       (%make-qd-d (scale-float (float 4739228994004870 1.0d0) -55)
			   (scale-float (float -6495525500297301 1.0d0) -110)
			   (scale-float (float -6071898187587615 1.0d0) -165)
			   (scale-float (float -7897922259441451 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4848781029471607 1.0d0) -55)
			   (scale-float (float -5949746474335482 1.0d0) -109)
			   (scale-float (float 7443833788929433 1.0d0) -165)
			   (scale-float (float 6779921506403360 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4958287426364647 1.0d0) -55)
			   (scale-float (float 8600164307618932 1.0d0) -110)
			   (scale-float (float -5552907197025195 1.0d0) -164)
			   (scale-float (float -6315628760329704 1.0d0) -222))
	       (%make-qd-d (scale-float (float 5067747153968079 1.0d0) -55)
			   (scale-float (float -5139980116898898 1.0d0) -109)
			   (scale-float (float 7128908501078503 1.0d0) -163)
			   (scale-float (float 5174334784143035 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5177159182005257 1.0d0) -55)
			   (scale-float (float 7446222959753664 1.0d0) -109)
			   (scale-float (float -4853116546479197 1.0d0) -166)
			   (scale-float (float -7114171320789543 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5286522480648506 1.0d0) -55)
			   (scale-float (float 4837853990883808 1.0d0) -110)
			   (scale-float (float 8734494569006220 1.0d0) -164)
			   (scale-float (float -6888573428631769 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5395836020528807 1.0d0) -55)
			   (scale-float (float 5245006079192873 1.0d0) -109)
			   (scale-float (float 6070092190452118 1.0d0) -165)
			   (scale-float (float 8372804672547503 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5505098772745492 1.0d0) -55)
			   (scale-float (float -4953034127800088 1.0d0) -109)
			   (scale-float (float 6748009167290918 1.0d0) -163)
			   (scale-float (float -7947104079128991 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5614309708875923 1.0d0) -55)
			   (scale-float (float 7879649848150358 1.0d0) -111)
			   (scale-float (float -5133702133285397 1.0d0) -165)
			   (scale-float (float 6633380945160774 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5723467800985178 1.0d0) -55)
			   (scale-float (float -5213481504208817 1.0d0) -110)
			   (scale-float (float -8683946243665639 1.0d0) -166)
			   (scale-float (float -4813600752545885 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5832572021635720 1.0d0) -55)
			   (scale-float (float 7691426989666512 1.0d0) -109)
			   (scale-float (float -5897567218587937 1.0d0) -163)
			   (scale-float (float 6426162084210735 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5941621343897074 1.0d0) -55)
			   (scale-float (float -7311303147276965 1.0d0) -113)
			   (scale-float (float 6212875260931578 1.0d0) -167)
			   (scale-float (float 5841094814764128 1.0d0) -222))
	       (%make-qd-d (scale-float (float 6050614741355486 1.0d0) -55)
			   (scale-float (float 7046535347736856 1.0d0) -110)
			   (scale-float (float -7778307984467600 1.0d0) -164)
			   (scale-float (float -7808429293088315 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6159551188123590 1.0d0) -55)
			   (scale-float (float 5965947804179142 1.0d0) -109)
			   (scale-float (float -7914176807889465 1.0d0) -163)
			   (scale-float (float -8743204545259556 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6268429658850061 1.0d0) -55)
			   (scale-float (float 7548560474328400 1.0d0) -110)
			   (scale-float (float -7834123143654772 1.0d0) -165)
			   (scale-float (float -5643244224302487 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6377249128729266 1.0d0) -55)
			   (scale-float (float 8739842904414420 1.0d0) -110)
			   (scale-float (float 6557520883328920 1.0d0) -164)
			   (scale-float (float 6198578405040918 1.0d0) -220))
	       (%make-qd-d (scale-float (float 6486008573510911 1.0d0) -55)
			   (scale-float (float 5172944262567044 1.0d0) -109)
			   (scale-float (float -8273960648700810 1.0d0) -163)
			   (scale-float (float 8265967084369073 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6594706969509681 1.0d0) -55)
			   (scale-float (float 5020296747686703 1.0d0) -109)
			   (scale-float (float -5238462653363294 1.0d0) -163)
			   (scale-float (float 4718474594983838 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6703343293614876 1.0d0) -55)
			   (scale-float (float -8155081811450095 1.0d0) -109)
			   (scale-float (float 8880533418464333 1.0d0) -163)
			   (scale-float (float -6482467806029927 1.0d0) -220))
	       (%make-qd-d (scale-float (float 6811916523300038 1.0d0) -55)
			   (scale-float (float -4946244022635960 1.0d0) -109)
			   (scale-float (float -5237121426122221 1.0d0) -163)
			   (scale-float (float 8718098324302620 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6920425636632580 1.0d0) -55)
			   (scale-float (float 5626936751711242 1.0d0) -110)
			   (scale-float (float -5472825984215756 1.0d0) -164)
			   (scale-float (float 6651512109810514 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7028869612283403 1.0d0) -55)
			   (scale-float (float -5186506842934658 1.0d0) -109)
			   (scale-float (float 7231073992256617 1.0d0) -163)
			   (scale-float (float -7548842128799985 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7137247429536506 1.0d0) -55)
			   (scale-float (float -4785846924082858 1.0d0) -111)
			   (scale-float (float 6612549575000546 1.0d0) -165)
			   (scale-float (float 8882300801909735 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7245558068298598 1.0d0) -55)
			   (scale-float (float 7145919755147006 1.0d0) -109)
			   (scale-float (float -4574333719136121 1.0d0) -163)
			   (scale-float (float 8116579236098782 1.0d0) -221))
	       (%make-qd-d (scale-float (float 7353800509108698 1.0d0) -55)
			   (scale-float (float 7910632724668908 1.0d0) -110)
			   (scale-float (float -6611929274882350 1.0d0) -164)
			   (scale-float (float 7768004576091902 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7461973733147729 1.0d0) -55)
			   (scale-float (float -6888466114708653 1.0d0) -109)
			   (scale-float (float 5251305190626995 1.0d0) -164)
			   (scale-float (float 5680012606429775 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7570076722248107 1.0d0) -55)
			   (scale-float (float 7503873979299470 1.0d0) -109)
			   (scale-float (float 7056820389775269 1.0d0) -163)
			   (scale-float (float 7020098326040376 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7678108458903330 1.0d0) -55)
			   (scale-float (float 7809132580424664 1.0d0) -109)
			   (scale-float (float -7983937846917205 1.0d0) -164)
			   (scale-float (float -5238765332718576 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7786067926277549 1.0d0) -55)
			   (scale-float (float -6562541456970122 1.0d0) -109)
			   (scale-float (float 8510563175036132 1.0d0) -163)
			   (scale-float (float -6181313461401740 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7893954108215139 1.0d0) -55)
			   (scale-float (float -7583622115760437 1.0d0) -114)
			   (scale-float (float -8739826341766039 1.0d0) -168)
			   (scale-float (float 8569299442299246 1.0d0) -224))
	       (%make-qd-d (scale-float (float 8001765989250269 1.0d0) -55)
			   (scale-float (float -7875990267513186 1.0d0) -111)
			   (scale-float (float 6234618013881755 1.0d0) -166)
			   (scale-float (float 6777347195615505 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8109502554616454 1.0d0) -55)
			   (scale-float (float 5128307098824184 1.0d0) -110)
			   (scale-float (float 4543608696005937 1.0d0) -167)
			   (scale-float (float 7638129994812919 1.0d0) -223))
	       (%make-qd-d (scale-float (float 8217162790256110 1.0d0) -55)
			   (scale-float (float 5345588865997323 1.0d0) -109)
			   (scale-float (float 8159479612637540 1.0d0) -163)
			   (scale-float (float -5402348902098945 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8324745682830097 1.0d0) -55)
			   (scale-float (float 6574607749416877 1.0d0) -109)
			   (scale-float (float -8109490796402671 1.0d0) -163)
			   (scale-float (float -6082280992156331 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8432250219727258 1.0d0) -55)
			   (scale-float (float -4538223398252166 1.0d0) -109)
			   (scale-float (float -6702216400949692 1.0d0) -163)
			   (scale-float (float 8946082027051995 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8539675389073947 1.0d0) -55)
			   (scale-float (float 5746889479488039 1.0d0) -109)
			   (scale-float (float 6355067832497967 1.0d0) -165)
			   (scale-float (float 8745994171732987 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8647020179743560 1.0d0) -55)
			   (scale-float (float -7877855974853474 1.0d0) -109)
			   (scale-float (float -6184796128853677 1.0d0) -164)
			   (scale-float (float -6716307004457317 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8754283581366043 1.0d0) -55)
			   (scale-float (float -5680003804930756 1.0d0) -109)
			   (scale-float (float -7684372211678467 1.0d0) -163)
			   (scale-float (float -8705668463298701 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8861464584337410 1.0d0) -55)
			   (scale-float (float -7223162559193390 1.0d0) -109)
			   (scale-float (float 5121803047874294 1.0d0) -163)
			   (scale-float (float 5147411879671042 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8968562179829241 1.0d0) -55)
			   (scale-float (float -5308048479279035 1.0d0) -109)
			   (scale-float (float 6508578347136807 1.0d0) -163)
			   (scale-float (float 8020683771279042 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4537787679899090 1.0d0) -54)
			   (scale-float (float -5708747378047162 1.0d0) -108)
			   (scale-float (float -6407036826384189 1.0d0) -162)
			   (scale-float (float 5919543467564908 1.0d0) -216))
	       (%make-qd-d (scale-float (float 4591251558497710 1.0d0) -54)
			   (scale-float (float -5650174284497868 1.0d0) -115)
			   (scale-float (float -8990517484150757 1.0d0) -170)
			   (scale-float (float -8107597715031434 1.0d0) -224))
	       (%make-qd-d (scale-float (float 4644672222488094 1.0d0) -54)
			   (scale-float (float 5997115408045016 1.0d0) -108)
			   (scale-float (float 7763885974670757 1.0d0) -164)
			   (scale-float (float -4679894517345222 1.0d0) -219))
	       (%make-qd-d (scale-float (float 4698049169054608 1.0d0) -54)
			   (scale-float (float 5545557499125773 1.0d0) -110)
			   (scale-float (float 5311178975123782 1.0d0) -166)
			   (scale-float (float 5295664491197940 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4751381895793102 1.0d0) -54)
			   (scale-float (float -6113263535019274 1.0d0) -108)
			   (scale-float (float 8020796425904764 1.0d0) -162)
			   (scale-float (float -8716004022289625 1.0d0) -216))
	       (%make-qd-d (scale-float (float 4804669900715639 1.0d0) -54)
			   (scale-float (float 6795815263120026 1.0d0) -108)
			   (scale-float (float -6608013933362003 1.0d0) -162)
			   (scale-float (float 8405700252907754 1.0d0) -218))
	       (%make-qd-d (scale-float (float 4857912682255224 1.0d0) -54)
			   (scale-float (float 5116248407710562 1.0d0) -108)
			   (scale-float (float -8148882072162222 1.0d0) -163)
			   (scale-float (float -8520890580178720 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4911109739270519 1.0d0) -54)
			   (scale-float (float 5107738102425278 1.0d0) -109)
			   (scale-float (float 6190162227247694 1.0d0) -166)
			   (scale-float (float -4657820058623469 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4964260571050563 1.0d0) -54)
			   (scale-float (float 6269805211133874 1.0d0) -108)
			   (scale-float (float 8144711382265961 1.0d0) -162)
			   (scale-float (float 5736256866199006 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5017364677319486 1.0d0) -54)
			   (scale-float (float -6510019840528798 1.0d0) -109)
			   (scale-float (float 8487479632464686 1.0d0) -163)
			   (scale-float (float -8482708199224338 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5070421558241214 1.0d0) -54)
			   (scale-float (float -7997629714663984 1.0d0) -109)
			   (scale-float (float -4940945917580418 1.0d0) -165)
			   (scale-float (float 6330315470378748 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5123430714424177 1.0d0) -54)
			   (scale-float (float 7207319694891503 1.0d0) -108)
			   (scale-float (float -5367984184293639 1.0d0) -162)
			   (scale-float (float -5496551307550694 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5176391646926010 1.0d0) -54)
			   (scale-float (float 5017419446091570 1.0d0) -108)
			   (scale-float (float -7396832087454611 1.0d0) -163)
			   (scale-float (float -4840687577999527 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5229303857258246 1.0d0) -54)
			   (scale-float (float -6142480273924397 1.0d0) -108)
			   (scale-float (float 6736325962420316 1.0d0) -162)
			   (scale-float (float 7870899103225375 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5282166847391008 1.0d0) -54)
			   (scale-float (float 7264487630099164 1.0d0) -108)
			   (scale-float (float 7987097472370426 1.0d0) -162)
			   (scale-float (float -8941292693731426 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5334980119757703 1.0d0) -54)
			   (scale-float (float -6562004117740143 1.0d0) -108)
			   (scale-float (float -7412943256346969 1.0d0) -166)
			   (scale-float (float -4884902683994743 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5387743177259695 1.0d0) -54)
			   (scale-float (float 8671749280336977 1.0d0) -112)
			   (scale-float (float 8052630932330237 1.0d0) -166)
			   (scale-float (float 5382726735559265 1.0d0) -223))
	       (%make-qd-d (scale-float (float 5440455523270994 1.0d0) -54)
			   (scale-float (float -5571226216357986 1.0d0) -108)
			   (scale-float (float 5456938947172397 1.0d0) -164)
			   (scale-float (float 6994870598847095 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5493116661642923 1.0d0) -54)
			   (scale-float (float -7460368030645572 1.0d0) -108)
			   (scale-float (float -6827621715323733 1.0d0) -165)
			   (scale-float (float 6362629589576016 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5545726096708791 1.0d0) -54)
			   (scale-float (float 8786044050481812 1.0d0) -108)
			   (scale-float (float 7347762739505304 1.0d0) -162)
			   (scale-float (float 7680616584349999 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5598283333288561 1.0d0) -54)
			   (scale-float (float 6778243811814134 1.0d0) -108)
			   (scale-float (float -7045745243982448 1.0d0) -164)
			   (scale-float (float 4676451795272765 1.0d0) -221))
	       (%make-qd-d (scale-float (float 5650787876693505 1.0d0) -54)
			   (scale-float (float 4725135298405656 1.0d0) -108)
			   (scale-float (float 8550179043058735 1.0d0) -164)
			   (scale-float (float 4909349307819338 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5703239232730864 1.0d0) -54)
			   (scale-float (float 6956150123475237 1.0d0) -108)
			   (scale-float (float 7212901813329486 1.0d0) -162)
			   (scale-float (float 7153556903673412 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5755636907708500 1.0d0) -54)
			   (scale-float (float -4537276437495587 1.0d0) -108)
			   (scale-float (float 4777941193532901 1.0d0) -162)
			   (scale-float (float -8179721144625040 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5807980408439539 1.0d0) -54)
			   (scale-float (float -5259672094517845 1.0d0) -110)
			   (scale-float (float 8754582529967018 1.0d0) -164)
			   (scale-float (float 7408654934690508 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5860269242247018 1.0d0) -54)
			   (scale-float (float 5138507873462360 1.0d0) -109)
			   (scale-float (float -6320854003064805 1.0d0) -166)
			   (scale-float (float 7758282409924483 1.0d0) -221))
	       (%make-qd-d (scale-float (float 5912502916968520 1.0d0) -54)
			   (scale-float (float -8662419418939044 1.0d0) -108)
			   (scale-float (float 4614185824928788 1.0d0) -162)
			   (scale-float (float 8601963191388429 1.0d0) -221))
	       (%make-qd-d (scale-float (float 5964680940960804 1.0d0) -54)
			   (scale-float (float -8914351205645270 1.0d0) -108)
			   (scale-float (float -7834377139759957 1.0d0) -162)
			   (scale-float (float 6901300084898985 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6016802823104436 1.0d0) -54)
			   (scale-float (float 7333790512522496 1.0d0) -108)
			   (scale-float (float 4563571436080821 1.0d0) -162)
			   (scale-float (float 8605109854377494 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6068868072808413 1.0d0) -54)
			   (scale-float (float -8723253959652896 1.0d0) -114)
			   (scale-float (float -8733624133784357 1.0d0) -171)
			   (scale-float (float -6253293004427605 1.0d0) -225))
	       (%make-qd-d (scale-float (float 6120876200014774 1.0d0) -54)
			   (scale-float (float 8571012628450813 1.0d0) -110)
			   (scale-float (float 5881087260125824 1.0d0) -165)
			   (scale-float (float 8616758768675350 1.0d0) -221))
	       (%make-qd-d (scale-float (float 6172826715203219 1.0d0) -54)
			   (scale-float (float 6250720108433989 1.0d0) -108)
			   (scale-float (float -5422415971662036 1.0d0) -162)
			   (scale-float (float 8997881851302993 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6224719129395714 1.0d0) -54)
			   (scale-float (float 8843501730272727 1.0d0) -108)
			   (scale-float (float 8200563275489647 1.0d0) -163)
			   (scale-float (float -5971751274707875 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6276552954161094 1.0d0) -54)
			   (scale-float (float 4799554187051297 1.0d0) -110)
			   (scale-float (float 8308846534529580 1.0d0) -164)
			   (scale-float (float 8241934792467017 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6328327701619659 1.0d0) -54)
			   (scale-float (float -7357066700707823 1.0d0) -108)
			   (scale-float (float -7947864157743905 1.0d0) -165)
			   (scale-float (float 7675632966777644 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6380042884447767 1.0d0) -54)
			   (scale-float (float -5501161709946803 1.0d0) -108)
			   (scale-float (float 7466713522323834 1.0d0) -162)
			   (scale-float (float -7098845764308001 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6431698015882422 1.0d0) -54)
			   (scale-float (float -5007263247392991 1.0d0) -113)
			   (scale-float (float -7795754867074493 1.0d0) -167)
			   (scale-float (float -4821191128464752 1.0d0) -222))
	       (%make-qd-d (scale-float (float 6483292609725855 1.0d0) -54)
			   (scale-float (float -5712074047376477 1.0d0) -108)
			   (scale-float (float 7819107111345661 1.0d0) -162)
			   (scale-float (float 8368937774054671 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6534826180350098 1.0d0) -54)
			   (scale-float (float -5949616244538138 1.0d0) -109)
			   (scale-float (float -8689252050077247 1.0d0) -163)
			   (scale-float (float -8509057300264997 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6586298242701558 1.0d0) -54)
			   (scale-float (float 5263009052367660 1.0d0) -108)
			   (scale-float (float 6598370143038445 1.0d0) -162)
			   (scale-float (float -7564085607225777 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6637708312305582 1.0d0) -54)
			   (scale-float (float 6791291154341829 1.0d0) -109)
			   (scale-float (float 7690532825767619 1.0d0) -168)
			   (scale-float (float 7037800597631649 1.0d0) -222))
	       (%make-qd-d (scale-float (float 6689055905271015 1.0d0) -54)
			   (scale-float (float 7217134714480857 1.0d0) -114)
			   (scale-float (float -8997551068716333 1.0d0) -173)
			   (scale-float (float -6072128060810686 1.0d0) -227))
	       (%make-qd-d (scale-float (float 6740340538294756 1.0d0) -54)
			   (scale-float (float 5199702616094614 1.0d0) -109)
			   (scale-float (float 6246995808738228 1.0d0) -163)
			   (scale-float (float 8721019383942846 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6791561728666308 1.0d0) -54)
			   (scale-float (float -7075880958543542 1.0d0) -111)
			   (scale-float (float 5953253779194679 1.0d0) -166)
			   (scale-float (float 5597468420642533 1.0d0) -222))
	       (%make-qd-d (scale-float (float 6842718994272319 1.0d0) -54)
			   (scale-float (float 6435287673892967 1.0d0) -109)
			   (scale-float (float 5701190408884571 1.0d0) -163)
			   (scale-float (float 5908054947863245 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6893811853601123 1.0d0) -54)
			   (scale-float (float -6523324437210640 1.0d0) -109)
			   (scale-float (float -4818352562283701 1.0d0) -164)
			   (scale-float (float -5357330931060650 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6944839825747268 1.0d0) -54)
			   (scale-float (float 4925434022374747 1.0d0) -108)
			   (scale-float (float 8300294859713104 1.0d0) -162)
			   (scale-float (float 6208703759312379 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6995802430416048 1.0d0) -54)
			   (scale-float (float -6525270186811934 1.0d0) -109)
			   (scale-float (float 8879265420406843 1.0d0) -163)
			   (scale-float (float -6733241213708231 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7046699187928017 1.0d0) -54)
			   (scale-float (float 5840616084808535 1.0d0) -108)
			   (scale-float (float -6204648763678812 1.0d0) -162)
			   (scale-float (float -5748171176195803 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7097529619223511 1.0d0) -54)
			   (scale-float (float 6337798132651441 1.0d0) -109)
			   (scale-float (float -4965270455978562 1.0d0) -164)
			   (scale-float (float -4678379495118649 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7148293245867151 1.0d0) -54)
			   (scale-float (float 6667254347281325 1.0d0) -108)
			   (scale-float (float 7172706150755633 1.0d0) -163)
			   (scale-float (float 4521599313713307 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7198989590052351 1.0d0) -54)
			   (scale-float (float -4889033451117653 1.0d0) -108)
			   (scale-float (float -5825736040848376 1.0d0) -162)
			   (scale-float (float -6058018356871033 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7249618174605810 1.0d0) -54)
			   (scale-float (float 7076204518174404 1.0d0) -109)
			   (scale-float (float 8651917601296873 1.0d0) -163)
			   (scale-float (float 4790821447612866 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7300178522992010 1.0d0) -54)
			   (scale-float (float 6432697761913771 1.0d0) -109)
			   (scale-float (float -5885542131804050 1.0d0) -164)
			   (scale-float (float 5002309445714852 1.0d0) -225))
	       (%make-qd-d (scale-float (float 7350670159317696 1.0d0) -54)
			   (scale-float (float -4543650155952635 1.0d0) -109)
			   (scale-float (float -6598133798027798 1.0d0) -165)
			   (scale-float (float 8182638753990352 1.0d0) -225))
	       (%make-qd-d (scale-float (float 7401092608336357 1.0d0) -54)
			   (scale-float (float -7859785885819633 1.0d0) -108)
			   (scale-float (float -6675498128747218 1.0d0) -162)
			   (scale-float (float -8844902686085099 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7451445395452699 1.0d0) -54)
			   (scale-float (float -6746081919340579 1.0d0) -109)
			   (scale-float (float -5369758667471624 1.0d0) -165)
			   (scale-float (float -6834701290217458 1.0d0) -221))
	       (%make-qd-d (scale-float (float 7501728046727114 1.0d0) -54)
			   (scale-float (float -8267298509278455 1.0d0) -108)
			   (scale-float (float -8063438575398244 1.0d0) -164)
			   (scale-float (float 6048179215733349 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7551940088880137 1.0d0) -54)
			   (scale-float (float -5482087221447130 1.0d0) -110)
			   (scale-float (float -8430648353819219 1.0d0) -164)
			   (scale-float (float 8658592177651744 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7602081049296905 1.0d0) -54)
			   (scale-float (float 5652239210598920 1.0d0) -110)
			   (scale-float (float 7420759427593921 1.0d0) -164)
			   (scale-float (float -5717719400948822 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7652150456031602 1.0d0) -54)
			   (scale-float (float 8912029836648224 1.0d0) -108)
			   (scale-float (float -5442965062816235 1.0d0) -163)
			   (scale-float (float 5557269064076599 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7702147837811904 1.0d0) -54)
			   (scale-float (float 6108211414778243 1.0d0) -109)
			   (scale-float (float -8159473578389260 1.0d0) -165)
			   (scale-float (float -7432349312262155 1.0d0) -221))
	       (%make-qd-d (scale-float (float 7752072724043411 1.0d0) -54)
			   (scale-float (float 7223681421721881 1.0d0) -108)
			   (scale-float (float 5025963318844636 1.0d0) -162)
			   (scale-float (float -6196764359275049 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7801924644814081 1.0d0) -54)
			   (scale-float (float 7284976384109012 1.0d0) -109)
			   (scale-float (float 4978342074042849 1.0d0) -166)
			   (scale-float (float -8927853027064514 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7851703130898649 1.0d0) -54)
			   (scale-float (float 5267103399173910 1.0d0) -108)
			   (scale-float (float -6021054605042187 1.0d0) -166)
			   (scale-float (float 6370660996304786 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7901407713763047 1.0d0) -54)
			   (scale-float (float -6777023449092614 1.0d0) -108)
			   (scale-float (float -6668929501654487 1.0d0) -165)
			   (scale-float (float 8608953101571494 1.0d0) -223))
	       (%make-qd-d (scale-float (float 7951037925568809 1.0d0) -54)
			   (scale-float (float 7256489245666525 1.0d0) -108)
			   (scale-float (float 5548921664669512 1.0d0) -165)
			   (scale-float (float -6417647354800337 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8000593299177483 1.0d0) -54)
			   (scale-float (float -7859474098720372 1.0d0) -108)
			   (scale-float (float 5192476996492227 1.0d0) -164)
			   (scale-float (float 7762192920165123 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8050073368155017 1.0d0) -54)
			   (scale-float (float -6237939819127611 1.0d0) -108)
			   (scale-float (float -8310809855799018 1.0d0) -167)
			   (scale-float (float -4607997215797586 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8099477666776158 1.0d0) -54)
			   (scale-float (float 6338746169655183 1.0d0) -110)
			   (scale-float (float 6349016711906624 1.0d0) -164)
			   (scale-float (float -6594231578666108 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8148805730028833 1.0d0) -54)
			   (scale-float (float -4811953802956820 1.0d0) -108)
			   (scale-float (float -8996711906404359 1.0d0) -163)
			   (scale-float (float 7437936247641814 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8198057093618523 1.0d0) -54)
			   (scale-float (float -8035018871140280 1.0d0) -109)
			   (scale-float (float 6464477674883353 1.0d0) -163)
			   (scale-float (float -7193445626531301 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8247231293972637 1.0d0) -54)
			   (scale-float (float -5487884902609878 1.0d0) -109)
			   (scale-float (float -7456042848390653 1.0d0) -163)
			   (scale-float (float 6693281418534385 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8296327868244873 1.0d0) -54)
			   (scale-float (float 5999951330674037 1.0d0) -108)
			   (scale-float (float -6154519112303483 1.0d0) -162)
			   (scale-float (float 7000233030992444 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8345346354319577 1.0d0) -54)
			   (scale-float (float -4771391396366549 1.0d0) -109)
			   (scale-float (float 7854156202477445 1.0d0) -163)
			   (scale-float (float 8339496630900022 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8394286290816088 1.0d0) -54)
			   (scale-float (float -8573403169330254 1.0d0) -111)
			   (scale-float (float 6529695060451631 1.0d0) -167)
			   (scale-float (float -6393362274584590 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8443147217093086 1.0d0) -54)
			   (scale-float (float -7447457963335574 1.0d0) -108)
			   (scale-float (float -6643844760557667 1.0d0) -162)
			   (scale-float (float 7249753184337927 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8491928673252923 1.0d0) -54)
			   (scale-float (float 8459131853498433 1.0d0) -110)
			   (scale-float (float 6888360499664938 1.0d0) -164)
			   (scale-float (float -5236945859638041 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8540630200145957 1.0d0) -54)
			   (scale-float (float -5286511185567367 1.0d0) -109)
			   (scale-float (float -8135173764139151 1.0d0) -164)
			   (scale-float (float -4921009164459924 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8589251339374868 1.0d0) -54)
			   (scale-float (float -6680873419295655 1.0d0) -109)
			   (scale-float (float -8554354988263275 1.0d0) -164)
			   (scale-float (float 7339900865625287 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8637791633298976 1.0d0) -54)
			   (scale-float (float 5977631648923170 1.0d0) -108)
			   (scale-float (float -7623682798863608 1.0d0) -162)
			   (scale-float (float 4624107632594484 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8686250625038550 1.0d0) -54)
			   (scale-float (float -8392536875785958 1.0d0) -108)
			   (scale-float (float -4707724355155067 1.0d0) -169)
			   (scale-float (float 5500147221680155 1.0d0) -223))
	       (%make-qd-d (scale-float (float 8734627858479102 1.0d0) -54)
			   (scale-float (float -5852368960712652 1.0d0) -108)
			   (scale-float (float -8241530944970066 1.0d0) -164)
			   (scale-float (float -7219502451510509 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8782922878275687 1.0d0) -54)
			   (scale-float (float 4618253045998479 1.0d0) -108)
			   (scale-float (float -8548139780246601 1.0d0) -165)
			   (scale-float (float -5125184194605572 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8831135229857187 1.0d0) -54)
			   (scale-float (float -6684581881277189 1.0d0) -110)
			   (scale-float (float -8629413596046384 1.0d0) -164)
			   (scale-float (float 6391588371080480 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8879264459430586 1.0d0) -54)
			   (scale-float (float -5326170718959288 1.0d0) -112)
			   (scale-float (float 6502706495111478 1.0d0) -166)
			   (scale-float (float -8175927755321089 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8927310113985246 1.0d0) -54)
			   (scale-float (float -6121928410302052 1.0d0) -109)
			   (scale-float (float 5839069660685259 1.0d0) -167)
			   (scale-float (float 5662811753865077 1.0d0) -223))
	       (%make-qd-d (scale-float (float 8975271741297168 1.0d0) -54)
			   (scale-float (float -5233310756427739 1.0d0) -108)
			   (scale-float (float -8823317657688998 1.0d0) -162)
			   (scale-float (float 4654507950124385 1.0d0) -218))
	       (%make-qd-d (scale-float (float 4511574444966625 1.0d0) -53)
			   (scale-float (float -6426118857297543 1.0d0) -107)
			   (scale-float (float -6491521190013141 1.0d0) -161)
			   (scale-float (float 7186617536341604 1.0d0) -215))
	       (%make-qd-d (scale-float (float 4535470554627767 1.0d0) -53)
			   (scale-float (float -5429619939489420 1.0d0) -108)
			   (scale-float (float -5927987229493283 1.0d0) -162)
			   (scale-float (float 8625723713246926 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4559323974712726 1.0d0) -53)
			   (scale-float (float -7840626733224058 1.0d0) -107)
			   (scale-float (float 5428491030047448 1.0d0) -162)
			   (scale-float (float 8993628089295535 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4583134480704026 1.0d0) -53)
			   (scale-float (float 7761991876870000 1.0d0) -107)
			   (scale-float (float -6271024629654463 1.0d0) -162)
			   (scale-float (float 5752025628139535 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4606901848488119 1.0d0) -53)
			   (scale-float (float -8494598453042205 1.0d0) -109)
			   (scale-float (float 4785427941994550 1.0d0) -163)
			   (scale-float (float -7993664237807223 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4630625854357486 1.0d0) -53)
			   (scale-float (float -7417310864687212 1.0d0) -107)
			   (scale-float (float 4527229152853963 1.0d0) -161)
			   (scale-float (float -5445479406340099 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4654306275012748 1.0d0) -53)
			   (scale-float (float 5388216318289433 1.0d0) -109)
			   (scale-float (float 6810717761619515 1.0d0) -163)
			   (scale-float (float -4804851653177209 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4677942887564769 1.0d0) -53)
			   (scale-float (float -8978008309930964 1.0d0) -107)
			   (scale-float (float -5916790110693661 1.0d0) -167)
			   (scale-float (float -8118978520081596 1.0d0) -221))
	       (%make-qd-d (scale-float (float 4701535469536748 1.0d0) -53)
			   (scale-float (float -7554109741206949 1.0d0) -107)
			   (scale-float (float 5422636526155651 1.0d0) -163)
			   (scale-float (float -5639775327748784 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4725083798866319 1.0d0) -53)
			   (scale-float (float -6988323544295858 1.0d0) -107)
			   (scale-float (float -4912183619887695 1.0d0) -163)
			   (scale-float (float -6359206876678376 1.0d0) -218))
	       (%make-qd-d (scale-float (float 4748587653907638 1.0d0) -53)
			   (scale-float (float -6847825579591004 1.0d0) -107)
			   (scale-float (float 5003358265465959 1.0d0) -162)
			   (scale-float (float 8422280950230119 1.0d0) -216))
	       (%make-qd-d (scale-float (float 4772046813433470 1.0d0) -53)
			   (scale-float (float -7799453234034926 1.0d0) -107)
			   (scale-float (float 6817580222556671 1.0d0) -163)
			   (scale-float (float -7560644201550137 1.0d0) -219))
	       (%make-qd-d (scale-float (float 4795461056637271 1.0d0) -53)
			   (scale-float (float -6655925208907997 1.0d0) -107)
			   (scale-float (float -5623857240635796 1.0d0) -161)
			   (scale-float (float -8070601107899198 1.0d0) -215))
	       (%make-qd-d (scale-float (float 4818830163135267 1.0d0) -53)
			   (scale-float (float -8710586291184881 1.0d0) -107)
			   (scale-float (float -8126282278485839 1.0d0) -162)
			   (scale-float (float 5719317781414307 1.0d0) -217))
	       (%make-qd-d (scale-float (float 4842153912968527 1.0d0) -53)
			   (scale-float (float -7339754703408720 1.0d0) -108)
			   (scale-float (float -6990336495915397 1.0d0) -163)
			   (scale-float (float 5257934322964996 1.0d0) -220))
	       (%make-qd-d (scale-float (float 4865432086605035 1.0d0) -53)
			   (scale-float (float 8785511657898515 1.0d0) -108)
			   (scale-float (float 6839125971928921 1.0d0) -162)
			   (scale-float (float -6223394966801216 1.0d0) -216))
	       (%make-qd-d (scale-float (float 4888664464941756 1.0d0) -53)
			   (scale-float (float 5564928859020974 1.0d0) -108)
			   (scale-float (float -7907253462425933 1.0d0) -162)
			   (scale-float (float 5236591704896374 1.0d0) -216))
	       (%make-qd-d (scale-float (float 4911850829306697 1.0d0) -53)
			   (scale-float (float -6736651049305461 1.0d0) -107)
			   (scale-float (float -8955456639116160 1.0d0) -162)
			   (scale-float (float 6701012809879390 1.0d0) -216))
	       (%make-qd-d (scale-float (float 4934990961460965 1.0d0) -53)
			   (scale-float (float -7809824017498950 1.0d0) -108)
			   (scale-float (float -5333685159010237 1.0d0) -170)
			   (scale-float (float -7013163948693077 1.0d0) -224))
	       (%make-qd-d (scale-float (float 4958084643600824 1.0d0) -53)
			   (scale-float (float -5407770883530058 1.0d0) -109)
			   (scale-float (float -5391994932415003 1.0d0) -164)
			   (scale-float (float 8910660424091806 1.0d0) -218))
	       (%make-qd-d (scale-float (float 4981131658359743 1.0d0) -53)
			   (scale-float (float -7636170899049036 1.0d0) -107)
			   (scale-float (float -6206770363233629 1.0d0) -162)
			   (scale-float (float -6822684679023966 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5004131788810440 1.0d0) -53)
			   (scale-float (float 7641456135071232 1.0d0) -107)
			   (scale-float (float -6033230867222893 1.0d0) -161)
			   (scale-float (float 6471526251842736 1.0d0) -215))
	       (%make-qd-d (scale-float (float 5027084818466930 1.0d0) -53)
			   (scale-float (float 8749783685054072 1.0d0) -109)
			   (scale-float (float -6432564900081691 1.0d0) -163)
			   (scale-float (float -4946481004218511 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5049990531286555 1.0d0) -53)
			   (scale-float (float -4800045970584779 1.0d0) -109)
			   (scale-float (float 4639463359548121 1.0d0) -163)
			   (scale-float (float 6739134100775357 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5072848711672022 1.0d0) -53)
			   (scale-float (float 7735151275984803 1.0d0) -108)
			   (scale-float (float 6319202510957152 1.0d0) -165)
			   (scale-float (float 7852194967309185 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5095659144473433 1.0d0) -53)
			   (scale-float (float -5532405218054066 1.0d0) -107)
			   (scale-float (float -4990528183184909 1.0d0) -161)
			   (scale-float (float 4694142170446455 1.0d0) -215))
	       (%make-qd-d (scale-float (float 5118421614990306 1.0d0) -53)
			   (scale-float (float -8264785570084562 1.0d0) -107)
			   (scale-float (float -4756999690706873 1.0d0) -161)
			   (scale-float (float 8271914155363375 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5141135908973599 1.0d0) -53)
			   (scale-float (float 7972820976421517 1.0d0) -108)
			   (scale-float (float -7508892149590212 1.0d0) -162)
			   (scale-float (float -7598338450058821 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5163801812627728 1.0d0) -53)
			   (scale-float (float 5528278164889757 1.0d0) -109)
			   (scale-float (float -7534708412684668 1.0d0) -163)
			   (scale-float (float 4748764085926481 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5186419112612575 1.0d0) -53)
			   (scale-float (float -6151167318128396 1.0d0) -107)
			   (scale-float (float -8018890614716932 1.0d0) -161)
			   (scale-float (float 5861072145574034 1.0d0) -215))
	       (%make-qd-d (scale-float (float 5208987596045498 1.0d0) -53)
			   (scale-float (float -8514617700931210 1.0d0) -108)
			   (scale-float (float 7996782571413148 1.0d0) -162)
			   (scale-float (float -6615677919703496 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5231507050503336 1.0d0) -53)
			   (scale-float (float 6031287197379932 1.0d0) -108)
			   (scale-float (float 6471258723704346 1.0d0) -164)
			   (scale-float (float 8258737189713217 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5253977264024408 1.0d0) -53)
			   (scale-float (float 8961021967501223 1.0d0) -111)
			   (scale-float (float 8449105812948238 1.0d0) -165)
			   (scale-float (float -5388110305851105 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5276398025110506 1.0d0) -53)
			   (scale-float (float -4865896352247366 1.0d0) -110)
			   (scale-float (float 6539437345050652 1.0d0) -164)
			   (scale-float (float -6050564890654524 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5298769122728888 1.0d0) -53)
			   (scale-float (float -4752925789560358 1.0d0) -107)
			   (scale-float (float -6940658006329329 1.0d0) -161)
			   (scale-float (float -4874539996486145 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5321090346314263 1.0d0) -53)
			   (scale-float (float -7628390168680570 1.0d0) -107)
			   (scale-float (float 7251508591837652 1.0d0) -161)
			   (scale-float (float 5307279358527743 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5343361485770773 1.0d0) -53)
			   (scale-float (float 8367594692216948 1.0d0) -109)
			   (scale-float (float 6203590959579987 1.0d0) -163)
			   (scale-float (float 8665448091350130 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5365582331473973 1.0d0) -53)
			   (scale-float (float -8722177288784495 1.0d0) -109)
			   (scale-float (float -6349014528983703 1.0d0) -166)
			   (scale-float (float 8570508217536058 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5387752674272799 1.0d0) -53)
			   (scale-float (float 6295965926759422 1.0d0) -107)
			   (scale-float (float -7064411274953418 1.0d0) -162)
			   (scale-float (float -8521156802129240 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5409872305491543 1.0d0) -53)
			   (scale-float (float -7528538090890981 1.0d0) -107)
			   (scale-float (float -4873667464989738 1.0d0) -161)
			   (scale-float (float 5474430362703076 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5431941016931809 1.0d0) -53)
			   (scale-float (float 6056061026085675 1.0d0) -107)
			   (scale-float (float 8117741563781443 1.0d0) -161)
			   (scale-float (float -8527257181106372 1.0d0) -215))
	       (%make-qd-d (scale-float (float 5453958600874483 1.0d0) -53)
			   (scale-float (float -5062923073902567 1.0d0) -107)
			   (scale-float (float 7460245243959813 1.0d0) -162)
			   (scale-float (float -8605987486451288 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5475924850081677 1.0d0) -53)
			   (scale-float (float 5705171231787006 1.0d0) -107)
			   (scale-float (float -5973740103346300 1.0d0) -164)
			   (scale-float (float -5933426595796939 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5497839557798690 1.0d0) -53)
			   (scale-float (float -7322198333974194 1.0d0) -108)
			   (scale-float (float 7708295787222922 1.0d0) -162)
			   (scale-float (float 8668959416020342 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5519702517755945 1.0d0) -53)
			   (scale-float (float -5541930106652097 1.0d0) -110)
			   (scale-float (float 6042424392306259 1.0d0) -164)
			   (scale-float (float 7112544487152837 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5541513524170937 1.0d0) -53)
			   (scale-float (float 8512581754243428 1.0d0) -108)
			   (scale-float (float -8240160558210729 1.0d0) -162)
			   (scale-float (float 7588665830274554 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5563272371750168 1.0d0) -53)
			   (scale-float (float -7703842410206491 1.0d0) -107)
			   (scale-float (float -8533597952376245 1.0d0) -163)
			   (scale-float (float -6350821420004830 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5584978855691076 1.0d0) -53)
			   (scale-float (float -4540568005736910 1.0d0) -107)
			   (scale-float (float 6810569017348767 1.0d0) -162)
			   (scale-float (float -5743636460441176 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5606632771683968 1.0d0) -53)
			   (scale-float (float 6872099470811347 1.0d0) -110)
			   (scale-float (float -4535230040345874 1.0d0) -166)
			   (scale-float (float 6845954161715752 1.0d0) -225))
	       (%make-qd-d (scale-float (float 5628233915913940 1.0d0) -53)
			   (scale-float (float 5463569387507809 1.0d0) -107)
			   (scale-float (float -8139410524833584 1.0d0) -161)
			   (scale-float (float 5908305814053563 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5649782085062796 1.0d0) -53)
			   (scale-float (float 4991677084184053 1.0d0) -107)
			   (scale-float (float 6329805746482172 1.0d0) -164)
			   (scale-float (float -4706296920171159 1.0d0) -218))
	       (%make-qd-d (scale-float (float 5671277076310961 1.0d0) -53)
			   (scale-float (float 6671344369483978 1.0d0) -107)
			   (scale-float (float -5602658804200812 1.0d0) -161)
			   (scale-float (float 5854533570742313 1.0d0) -215))
	       (%make-qd-d (scale-float (float 5692718687339392 1.0d0) -53)
			   (scale-float (float -6517134490911270 1.0d0) -107)
			   (scale-float (float -8442644072947353 1.0d0) -163)
			   (scale-float (float 7967700612201239 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5714106716331478 1.0d0) -53)
			   (scale-float (float 6763552043812531 1.0d0) -109)
			   (scale-float (float 4814134823321695 1.0d0) -163)
			   (scale-float (float -4874409913813393 1.0d0) -221))
	       (%make-qd-d (scale-float (float 5735440961974946 1.0d0) -53)
			   (scale-float (float 5098032122654983 1.0d0) -107)
			   (scale-float (float -6633387170173303 1.0d0) -161)
			   (scale-float (float -8437401866493262 1.0d0) -215))
	       (%make-qd-d (scale-float (float 5756721223463751 1.0d0) -53)
			   (scale-float (float 8058961560658971 1.0d0) -109)
			   (scale-float (float -7260204596373573 1.0d0) -163)
			   (scale-float (float 5847373583723548 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5777947300499967 1.0d0) -53)
			   (scale-float (float -6482805255133693 1.0d0) -109)
			   (scale-float (float 4907047913048716 1.0d0) -163)
			   (scale-float (float 4800601318416331 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5799118993295673 1.0d0) -53)
			   (scale-float (float -5206056249695124 1.0d0) -107)
			   (scale-float (float -7363227589940729 1.0d0) -162)
			   (scale-float (float -8468347824445839 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5820236102574833 1.0d0) -53)
			   (scale-float (float -4828209332879607 1.0d0) -107)
			   (scale-float (float -6006988076989561 1.0d0) -162)
			   (scale-float (float 6811807852310658 1.0d0) -219))
	       (%make-qd-d (scale-float (float 5841298429575172 1.0d0) -53)
			   (scale-float (float 5175456982428321 1.0d0) -110)
			   (scale-float (float 4538462653543703 1.0d0) -164)
			   (scale-float (float -8728016611215022 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5862305776050047 1.0d0) -53)
			   (scale-float (float 6444073748996113 1.0d0) -107)
			   (scale-float (float 6823119024662590 1.0d0) -164)
			   (scale-float (float 6426684369717617 1.0d0) -220))
	       (%make-qd-d (scale-float (float 5883257944270313 1.0d0) -53)
			   (scale-float (float 5561965163229991 1.0d0) -109)
			   (scale-float (float -8086818543630428 1.0d0) -163)
			   (scale-float (float 5028398904287973 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5904154737026182 1.0d0) -53)
			   (scale-float (float 5782715275133621 1.0d0) -107)
			   (scale-float (float 7421719155960077 1.0d0) -162)
			   (scale-float (float 4632156185190014 1.0d0) -216))
	       (%make-qd-d (scale-float (float 5924995957629083 1.0d0) -53)
			   (scale-float (float 6354379320602223 1.0d0) -108)
			   (scale-float (float -6982629383914688 1.0d0) -162)
			   (scale-float (float 6014680402693896 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5945781409913510 1.0d0) -53)
			   (scale-float (float -5798779723014377 1.0d0) -115)
			   (scale-float (float 4603157000630414 1.0d0) -169)
			   (scale-float (float 7213200979097056 1.0d0) -223))
	       (%make-qd-d (scale-float (float 5966510898238870 1.0d0) -53)
			   (scale-float (float -7339152233857623 1.0d0) -108)
			   (scale-float (float 5866707295710201 1.0d0) -163)
			   (scale-float (float 6142346235706265 1.0d0) -217))
	       (%make-qd-d (scale-float (float 5987184227491324 1.0d0) -53)
			   (scale-float (float -5878295590335062 1.0d0) -107)
			   (scale-float (float -5296945800600359 1.0d0) -162)
			   (scale-float (float 6511887897632255 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6007801203085623 1.0d0) -53)
			   (scale-float (float 5725215547860703 1.0d0) -107)
			   (scale-float (float -6069357457640343 1.0d0) -162)
			   (scale-float (float 7773390546671458 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6028361630966943 1.0d0) -53)
			   (scale-float (float -8858164301443705 1.0d0) -107)
			   (scale-float (float -7360418845574603 1.0d0) -161)
			   (scale-float (float -8881973385408916 1.0d0) -215))
	       (%make-qd-d (scale-float (float 6048865317612704 1.0d0) -53)
			   (scale-float (float -6569721984711602 1.0d0) -107)
			   (scale-float (float 7481914584676442 1.0d0) -164)
			   (scale-float (float -5916197970128717 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6069312070034399 1.0d0) -53)
			   (scale-float (float 7493750390382232 1.0d0) -108)
			   (scale-float (float 6714493630887683 1.0d0) -163)
			   (scale-float (float 4735122177247567 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6089701695779408 1.0d0) -53)
			   (scale-float (float 6045278015665200 1.0d0) -107)
			   (scale-float (float 4986473437314348 1.0d0) -161)
			   (scale-float (float 5124830363027070 1.0d0) -215))
	       (%make-qd-d (scale-float (float 6110034002932808 1.0d0) -53)
			   (scale-float (float 5939368762867376 1.0d0) -108)
			   (scale-float (float 5567834601844250 1.0d0) -162)
			   (scale-float (float 5300167663866890 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6130308800119180 1.0d0) -53)
			   (scale-float (float 4620055988650794 1.0d0) -107)
			   (scale-float (float 4832520168769970 1.0d0) -163)
			   (scale-float (float 8968190560224699 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6150525896504412 1.0d0) -53)
			   (scale-float (float -8410260520695715 1.0d0) -109)
			   (scale-float (float 8554993117360727 1.0d0) -165)
			   (scale-float (float 5819339724088257 1.0d0) -220))
	       (%make-qd-d (scale-float (float 6170685101797492 1.0d0) -53)
			   (scale-float (float 8420651303499559 1.0d0) -108)
			   (scale-float (float -4970902812289148 1.0d0) -162)
			   (scale-float (float -7326795827672023 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6190786226252304 1.0d0) -53)
			   (scale-float (float -8949598425759774 1.0d0) -107)
			   (scale-float (float 6954695760200578 1.0d0) -162)
			   (scale-float (float -6614108672187788 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6210829080669407 1.0d0) -53)
			   (scale-float (float -5156380214241847 1.0d0) -108)
			   (scale-float (float 5334034121559607 1.0d0) -162)
			   (scale-float (float 8070176566193680 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6230813476397823 1.0d0) -53)
			   (scale-float (float 8893780947316055 1.0d0) -108)
			   (scale-float (float 7767301829960617 1.0d0) -162)
			   (scale-float (float 7179345590973681 1.0d0) -222))
	       (%make-qd-d (scale-float (float 6250739225336809 1.0d0) -53)
			   (scale-float (float 4825271369095292 1.0d0) -109)
			   (scale-float (float 8776203731192851 1.0d0) -163)
			   (scale-float (float -6709656828176138 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6270606139937627 1.0d0) -53)
			   (scale-float (float -6688989605664720 1.0d0) -107)
			   (scale-float (float -5956139094822349 1.0d0) -167)
			   (scale-float (float 4660601968416390 1.0d0) -221))
	       (%make-qd-d (scale-float (float 6290414033205309 1.0d0) -53)
			   (scale-float (float 7948803281116707 1.0d0) -107)
			   (scale-float (float 5592877509532575 1.0d0) -161)
			   (scale-float (float 5510182001592507 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6310162718700422 1.0d0) -53)
			   (scale-float (float 5034574382400651 1.0d0) -107)
			   (scale-float (float 5591018388425185 1.0d0) -162)
			   (scale-float (float 7733615070437822 1.0d0) -220))
	       (%make-qd-d (scale-float (float 6329852010540816 1.0d0) -53)
			   (scale-float (float 6562620425861985 1.0d0) -111)
			   (scale-float (float -8136290568547131 1.0d0) -166)
			   (scale-float (float 8426790677064152 1.0d0) -220))
	       (%make-qd-d (scale-float (float 6349481723403377 1.0d0) -53)
			   (scale-float (float 8959543695439504 1.0d0) -108)
			   (scale-float (float 6972321431588115 1.0d0) -164)
			   (scale-float (float 4858285252195155 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6369051672525773 1.0d0) -53)
			   (scale-float (float -7843040109683798 1.0d0) -107)
			   (scale-float (float 6048680740045173 1.0d0) -161)
			   (scale-float (float 5197737643093849 1.0d0) -217))))
  "Table of sin(k/1024) for k = 1 to 256")

(defconstant +qd-cos-table+
  (make-array 256
	      :initial-contents
	      (list
	       (%make-qd-d (scale-float (float 9007156865146114 1.0d0) -53)
			   (scale-float (float -6382651775133715 1.0d0) -108)
			   (scale-float (float -7372276689025835 1.0d0) -163)
			   (scale-float (float 7180257539184632 1.0d0) -223))
	       (%make-qd-d (scale-float (float 9007029696760466 1.0d0) -53)
			   (scale-float (float 5446736202153207 1.0d0) -107)
			   (scale-float (float -5514938334717690 1.0d0) -168)
			   (scale-float (float 6645835630926151 1.0d0) -222))
	       (%make-qd-d (scale-float (float 9006817750781007 1.0d0) -53)
			   (scale-float (float -5115684009971601 1.0d0) -107)
			   (scale-float (float 7705986954927589 1.0d0) -161)
			   (scale-float (float 5269566330016024 1.0d0) -215))
	       (%make-qd-d (scale-float (float 9006521029202651 1.0d0) -53)
			   (scale-float (float 6154670017854733 1.0d0) -107)
			   (scale-float (float -7959914909379173 1.0d0) -166)
			   (scale-float (float -8417733335951937 1.0d0) -220))
	       (%make-qd-d (scale-float (float 9006139534818257 1.0d0) -53)
			   (scale-float (float -5756604584677720 1.0d0) -107)
			   (scale-float (float 4998920502946311 1.0d0) -161)
			   (scale-float (float -5647576219871589 1.0d0) -215))
	       (%make-qd-d (scale-float (float 9005673271218593 1.0d0) -53)
			   (scale-float (float 6109107373172336 1.0d0) -108)
			   (scale-float (float -6007767124009731 1.0d0) -163)
			   (scale-float (float -8083524655498703 1.0d0) -217))
	       (%make-qd-d (scale-float (float 9005122242792311 1.0d0) -53)
			   (scale-float (float 6925416919478846 1.0d0) -107)
			   (scale-float (float 5571917222010501 1.0d0) -161)
			   (scale-float (float -6342027657037425 1.0d0) -216))
	       (%make-qd-d (scale-float (float 9004486454725901 1.0d0) -53)
			   (scale-float (float -4843680596157643 1.0d0) -107)
			   (scale-float (float -5578489598087899 1.0d0) -161)
			   (scale-float (float 4716327604025735 1.0d0) -219))
	       (%make-qd-d (scale-float (float 9003765913003641 1.0d0) -53)
			   (scale-float (float -6682155943911976 1.0d0) -107)
			   (scale-float (float 6113568212113372 1.0d0) -161)
			   (scale-float (float 8572777647471794 1.0d0) -216))
	       (%make-qd-d (scale-float (float 9002960624407544 1.0d0) -53)
			   (scale-float (float 6658445016247619 1.0d0) -108)
			   (scale-float (float -5574027242944025 1.0d0) -163)
			   (scale-float (float -6201546866284994 1.0d0) -217))
	       (%make-qd-d (scale-float (float 9002070596517294 1.0d0) -53)
			   (scale-float (float 6432687535538725 1.0d0) -107)
			   (scale-float (float -5555395417668222 1.0d0) -164)
			   (scale-float (float -8665438431468013 1.0d0) -222))
	       (%make-qd-d (scale-float (float 9001095837710173 1.0d0) -53)
			   (scale-float (float -6954195453368662 1.0d0) -107)
			   (scale-float (float 7771704866044900 1.0d0) -164)
			   (scale-float (float -7039433522181404 1.0d0) -219))
	       (%make-qd-d (scale-float (float 9000036357160980 1.0d0) -53)
			   (scale-float (float 5957921611966531 1.0d0) -109)
			   (scale-float (float 6479270319865368 1.0d0) -163)
			   (scale-float (float 5409988246591494 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8998892164841951 1.0d0) -53)
			   (scale-float (float 6950865384540836 1.0d0) -108)
			   (scale-float (float -4621163143123886 1.0d0) -162)
			   (scale-float (float -5599064490362240 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8997663271522660 1.0d0) -53)
			   (scale-float (float -6688535702623983 1.0d0) -108)
			   (scale-float (float -7334707016190584 1.0d0) -162)
			   (scale-float (float -7916945128397036 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8996349688769918 1.0d0) -53)
			   (scale-float (float -7977765087521301 1.0d0) -109)
			   (scale-float (float 5721708006624170 1.0d0) -164)
			   (scale-float (float 4517430183150016 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8994951428947667 1.0d0) -53)
			   (scale-float (float -7900445453445422 1.0d0) -107)
			   (scale-float (float -6891478759949600 1.0d0) -164)
			   (scale-float (float -5476513299440062 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8993468505216860 1.0d0) -53)
			   (scale-float (float -7140359403681271 1.0d0) -108)
			   (scale-float (float -7232392529862741 1.0d0) -162)
			   (scale-float (float -5246916413682806 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8991900931535341 1.0d0) -53)
			   (scale-float (float -8416291772118320 1.0d0) -107)
			   (scale-float (float 6126729149397296 1.0d0) -162)
			   (scale-float (float -6107196519366287 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8990248722657709 1.0d0) -53)
			   (scale-float (float 4532792009051038 1.0d0) -107)
			   (scale-float (float 7138950646897488 1.0d0) -161)
			   (scale-float (float -7124028913967965 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8988511894135185 1.0d0) -53)
			   (scale-float (float 5563435675856346 1.0d0) -108)
			   (scale-float (float 6768020100627694 1.0d0) -163)
			   (scale-float (float -7801655263446071 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8986690462315460 1.0d0) -53)
			   (scale-float (float -8565496940783238 1.0d0) -108)
			   (scale-float (float -7565304489103248 1.0d0) -165)
			   (scale-float (float -8418659784422752 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8984784444342543 1.0d0) -53)
			   (scale-float (float 7270150983818169 1.0d0) -110)
			   (scale-float (float -5563309902486145 1.0d0) -166)
			   (scale-float (float -4888785479057611 1.0d0) -231))
	       (%make-qd-d (scale-float (float 8982793858156602 1.0d0) -53)
			   (scale-float (float 5948275509591605 1.0d0) -109)
			   (scale-float (float 7930006667538804 1.0d0) -163)
			   (scale-float (float -5809288382338202 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8980718722493792 1.0d0) -53)
			   (scale-float (float 5430523834411255 1.0d0) -108)
			   (scale-float (float -7699162237707398 1.0d0) -162)
			   (scale-float (float 8687041402074628 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8978559056886080 1.0d0) -53)
			   (scale-float (float 7636379253722903 1.0d0) -107)
			   (scale-float (float 8304848910636198 1.0d0) -161)
			   (scale-float (float -8425631601226793 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8976314881661062 1.0d0) -53)
			   (scale-float (float 7598393650369643 1.0d0) -109)
			   (scale-float (float -8878261545093758 1.0d0) -163)
			   (scale-float (float 5997503087615023 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8973986217941769 1.0d0) -53)
			   (scale-float (float 7357807798683726 1.0d0) -109)
			   (scale-float (float 7951143844149272 1.0d0) -164)
			   (scale-float (float 5218035394662342 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8971573087646471 1.0d0) -53)
			   (scale-float (float 7421749611895653 1.0d0) -108)
			   (scale-float (float -4581496555918016 1.0d0) -163)
			   (scale-float (float -7810225024786925 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8969075513488470 1.0d0) -53)
			   (scale-float (float -7513223803443073 1.0d0) -108)
			   (scale-float (float -7626238511742260 1.0d0) -165)
			   (scale-float (float -5366856187311050 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8966493518975884 1.0d0) -53)
			   (scale-float (float 8329643948299160 1.0d0) -111)
			   (scale-float (float -7408252878990684 1.0d0) -170)
			   (scale-float (float -7497946385569394 1.0d0) -224))
	       (%make-qd-d (scale-float (float 8963827128411430 1.0d0) -53)
			   (scale-float (float -6893895888146887 1.0d0) -107)
			   (scale-float (float 7784256318365108 1.0d0) -162)
			   (scale-float (float 7153652023322651 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8961076366892190 1.0d0) -53)
			   (scale-float (float 5468892236673259 1.0d0) -110)
			   (scale-float (float -7868743052739110 1.0d0) -167)
			   (scale-float (float 8477913984177349 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8958241260309380 1.0d0) -53)
			   (scale-float (float 5962228427073425 1.0d0) -107)
			   (scale-float (float -8945355811576285 1.0d0) -161)
			   (scale-float (float 5475118791675541 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8955321835348103 1.0d0) -53)
			   (scale-float (float 7160408339531907 1.0d0) -107)
			   (scale-float (float -8800353687418162 1.0d0) -161)
			   (scale-float (float 7814338741356067 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8952318119487099 1.0d0) -53)
			   (scale-float (float -6154445520718857 1.0d0) -108)
			   (scale-float (float -5979147254374853 1.0d0) -168)
			   (scale-float (float -5754250618745921 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8949230140998484 1.0d0) -53)
			   (scale-float (float 4827588292883036 1.0d0) -107)
			   (scale-float (float -5269205324285223 1.0d0) -163)
			   (scale-float (float -7066073884583852 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8946057928947489 1.0d0) -53)
			   (scale-float (float 5370280075238301 1.0d0) -107)
			   (scale-float (float 4557784045899430 1.0d0) -161)
			   (scale-float (float 6055026141926995 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8942801513192182 1.0d0) -53)
			   (scale-float (float -4573932509451197 1.0d0) -108)
			   (scale-float (float -6988642513170233 1.0d0) -162)
			   (scale-float (float 7903423679430231 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8939460924383187 1.0d0) -53)
			   (scale-float (float 5045136634195182 1.0d0) -107)
			   (scale-float (float -5372361566405903 1.0d0) -161)
			   (scale-float (float -6720737022123546 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8936036193963400 1.0d0) -53)
			   (scale-float (float -6398195821015223 1.0d0) -107)
			   (scale-float (float -7337680936016907 1.0d0) -163)
			   (scale-float (float -5459780776141598 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8932527354167686 1.0d0) -53)
			   (scale-float (float -6067949506678475 1.0d0) -111)
			   (scale-float (float 5064661831761972 1.0d0) -167)
			   (scale-float (float -8471798904647962 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8928934438022583 1.0d0) -53)
			   (scale-float (float -8175307614637614 1.0d0) -108)
			   (scale-float (float -7513563295790417 1.0d0) -162)
			   (scale-float (float 5516806786798278 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8925257479345985 1.0d0) -53)
			   (scale-float (float 4995821998689288 1.0d0) -108)
			   (scale-float (float -6313677797518807 1.0d0) -162)
			   (scale-float (float 4625503888993559 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8921496512746829 1.0d0) -53)
			   (scale-float (float -8991019785543599 1.0d0) -107)
			   (scale-float (float -8543364032599344 1.0d0) -162)
			   (scale-float (float -8075214757855398 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8917651573624763 1.0d0) -53)
			   (scale-float (float -5534821618232727 1.0d0) -108)
			   (scale-float (float 7865766552369999 1.0d0) -162)
			   (scale-float (float 7700180873329070 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8913722698169820 1.0d0) -53)
			   (scale-float (float -8502096954648678 1.0d0) -107)
			   (scale-float (float 7870589230495605 1.0d0) -162)
			   (scale-float (float 6110391933205275 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8909709923362071 1.0d0) -53)
			   (scale-float (float -6650571269560095 1.0d0) -107)
			   (scale-float (float -5244751855479113 1.0d0) -163)
			   (scale-float (float -8301663588356049 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8905613286971281 1.0d0) -53)
			   (scale-float (float -7123978755460638 1.0d0) -109)
			   (scale-float (float 7555692813056111 1.0d0) -164)
			   (scale-float (float 8118983438487515 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8901432827556552 1.0d0) -53)
			   (scale-float (float 8771933742692817 1.0d0) -108)
			   (scale-float (float 7250438674596944 1.0d0) -166)
			   (scale-float (float 7083606337494008 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8897168584465961 1.0d0) -53)
			   (scale-float (float -7658862886582027 1.0d0) -108)
			   (scale-float (float -7204199762688552 1.0d0) -162)
			   (scale-float (float 6346308409048664 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8892820597836187 1.0d0) -53)
			   (scale-float (float -8491394866189883 1.0d0) -107)
			   (scale-float (float -8166182587214152 1.0d0) -161)
			   (scale-float (float 6357787596929140 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8888388908592136 1.0d0) -53)
			   (scale-float (float -8159567034358810 1.0d0) -107)
			   (scale-float (float -6629817546842393 1.0d0) -161)
			   (scale-float (float 4634129890739685 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8883873558446555 1.0d0) -53)
			   (scale-float (float -6983923910930642 1.0d0) -108)
			   (scale-float (float 6937180072251376 1.0d0) -162)
			   (scale-float (float -8270405867504028 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8879274589899640 1.0d0) -53)
			   (scale-float (float -8346528441017500 1.0d0) -107)
			   (scale-float (float 7680611814957263 1.0d0) -161)
			   (scale-float (float 7943027189392270 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8874592046238633 1.0d0) -53)
			   (scale-float (float 7514433837333686 1.0d0) -108)
			   (scale-float (float -8801276453264781 1.0d0) -163)
			   (scale-float (float 8915512537041539 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8869825971537420 1.0d0) -53)
			   (scale-float (float 6846136909451560 1.0d0) -109)
			   (scale-float (float 6731359750255182 1.0d0) -164)
			   (scale-float (float -6197790138101606 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8864976410656110 1.0d0) -53)
			   (scale-float (float 7785836584894173 1.0d0) -107)
			   (scale-float (float 5284186529715868 1.0d0) -164)
			   (scale-float (float 7402980542247590 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8860043409240618 1.0d0) -53)
			   (scale-float (float 6446544258894238 1.0d0) -108)
			   (scale-float (float -8038901621714735 1.0d0) -169)
			   (scale-float (float 4846229103018903 1.0d0) -224))
	       (%make-qd-d (scale-float (float 8855027013722231 1.0d0) -53)
			   (scale-float (float 6842474924546396 1.0d0) -107)
			   (scale-float (float 4816891086673617 1.0d0) -162)
			   (scale-float (float -8509622836947172 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8849927271317175 1.0d0) -53)
			   (scale-float (float 4916320054218436 1.0d0) -108)
			   (scale-float (float -4887585510279573 1.0d0) -163)
			   (scale-float (float -4665371238305833 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8844744230026167 1.0d0) -53)
			   (scale-float (float 6850081623240539 1.0d0) -108)
			   (scale-float (float -8916921648409142 1.0d0) -162)
			   (scale-float (float -7202105646592469 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8839477938633966 1.0d0) -53)
			   (scale-float (float 8715376239079668 1.0d0) -109)
			   (scale-float (float -7634216994416838 1.0d0) -163)
			   (scale-float (float 4712162648716876 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8834128446708912 1.0d0) -53)
			   (scale-float (float 6018826142883795 1.0d0) -108)
			   (scale-float (float -6253218580383489 1.0d0) -162)
			   (scale-float (float 7020978235349363 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8828695804602461 1.0d0) -53)
			   (scale-float (float -5971431338778072 1.0d0) -107)
			   (scale-float (float 7394633722946009 1.0d0) -163)
			   (scale-float (float 7835308697779253 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8823180063448708 1.0d0) -53)
			   (scale-float (float 5054049223849600 1.0d0) -108)
			   (scale-float (float -7834271977802953 1.0d0) -162)
			   (scale-float (float -7272320165403980 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8817581275163911 1.0d0) -53)
			   (scale-float (float -6183435703505308 1.0d0) -111)
			   (scale-float (float -5001726456690585 1.0d0) -165)
			   (scale-float (float -6933175510886964 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8811899492445997 1.0d0) -53)
			   (scale-float (float -7017091372002309 1.0d0) -108)
			   (scale-float (float 6413304785703535 1.0d0) -162)
			   (scale-float (float 8118727090730765 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8806134768774068 1.0d0) -53)
			   (scale-float (float 8196387204119507 1.0d0) -107)
			   (scale-float (float -7748736525621098 1.0d0) -162)
			   (scale-float (float 7388842477950275 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8800287158407901 1.0d0) -53)
			   (scale-float (float -7034568527191045 1.0d0) -107)
			   (scale-float (float 6424625550657811 1.0d0) -163)
			   (scale-float (float -7814615457557805 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8794356716387429 1.0d0) -53)
			   (scale-float (float 6042141602652702 1.0d0) -109)
			   (scale-float (float -4815349649953967 1.0d0) -163)
			   (scale-float (float -6721857373013784 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8788343498532233 1.0d0) -53)
			   (scale-float (float -8298768912839398 1.0d0) -108)
			   (scale-float (float -5446972436275558 1.0d0) -162)
			   (scale-float (float -7049677529730599 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8782247561441008 1.0d0) -53)
			   (scale-float (float 8646037700366584 1.0d0) -108)
			   (scale-float (float 8333782932738579 1.0d0) -165)
			   (scale-float (float -5587385824373688 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8776068962491037 1.0d0) -53)
			   (scale-float (float 5981843094371335 1.0d0) -111)
			   (scale-float (float 5031627907802402 1.0d0) -165)
			   (scale-float (float 8605971594377410 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8769807759837646 1.0d0) -53)
			   (scale-float (float -8393641348716169 1.0d0) -107)
			   (scale-float (float -4533131738151266 1.0d0) -161)
			   (scale-float (float -8690963173342472 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8763464012413658 1.0d0) -53)
			   (scale-float (float -5080534473348267 1.0d0) -107)
			   (scale-float (float -7855304661081380 1.0d0) -161)
			   (scale-float (float -7296856099117507 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8757037779928840 1.0d0) -53)
			   (scale-float (float 5916163041813500 1.0d0) -107)
			   (scale-float (float 8859516786540065 1.0d0) -161)
			   (scale-float (float -8561614259167781 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8750529122869341 1.0d0) -53)
			   (scale-float (float -5183562189985281 1.0d0) -109)
			   (scale-float (float -5101040255073374 1.0d0) -163)
			   (scale-float (float 5780805313355459 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8743938102497119 1.0d0) -53)
			   (scale-float (float -7787173714602643 1.0d0) -107)
			   (scale-float (float 8870592638467604 1.0d0) -161)
			   (scale-float (float 4527859829386072 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8737264780849367 1.0d0) -53)
			   (scale-float (float 5959880706574729 1.0d0) -108)
			   (scale-float (float -8366277013359923 1.0d0) -162)
			   (scale-float (float 7232577075726740 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8730509220737932 1.0d0) -53)
			   (scale-float (float -7409352491475308 1.0d0) -107)
			   (scale-float (float 5620790720594497 1.0d0) -162)
			   (scale-float (float 6846782194285202 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8723671485748716 1.0d0) -53)
			   (scale-float (float 8027789877305549 1.0d0) -107)
			   (scale-float (float 8347728572284626 1.0d0) -161)
			   (scale-float (float 6629242611071548 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8716751640241088 1.0d0) -53)
			   (scale-float (float -7384765759223300 1.0d0) -107)
			   (scale-float (float -8259014728839389 1.0d0) -162)
			   (scale-float (float -8911590265625930 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8709749749347266 1.0d0) -53)
			   (scale-float (float 6246370251798351 1.0d0) -107)
			   (scale-float (float -6299847417742655 1.0d0) -163)
			   (scale-float (float -7418590254845397 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8702665878971716 1.0d0) -53)
			   (scale-float (float 8323712745751476 1.0d0) -107)
			   (scale-float (float 6811334649930440 1.0d0) -165)
			   (scale-float (float 8505841244414894 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8695500095790524 1.0d0) -53)
			   (scale-float (float -7705819592372010 1.0d0) -108)
			   (scale-float (float 6924187360006505 1.0d0) -163)
			   (scale-float (float -8174591260972689 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8688252467250769 1.0d0) -53)
			   (scale-float (float -5547558796790388 1.0d0) -107)
			   (scale-float (float 6717667801494033 1.0d0) -161)
			   (scale-float (float -4752616405244403 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8680923061569891 1.0d0) -53)
			   (scale-float (float 8588042960215234 1.0d0) -108)
			   (scale-float (float -8702070775005543 1.0d0) -171)
			   (scale-float (float -6976332996211473 1.0d0) -225))
	       (%make-qd-d (scale-float (float 8673511947735049 1.0d0) -53)
			   (scale-float (float 5798624754283258 1.0d0) -109)
			   (scale-float (float -4568215043570977 1.0d0) -163)
			   (scale-float (float 6829329873018631 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8666019195502468 1.0d0) -53)
			   (scale-float (float 4944614710107653 1.0d0) -108)
			   (scale-float (float -7629139990045050 1.0d0) -162)
			   (scale-float (float 8321368928085100 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8658444875396786 1.0d0) -53)
			   (scale-float (float 5434765495412269 1.0d0) -111)
			   (scale-float (float 5036267983276872 1.0d0) -165)
			   (scale-float (float -5008959202542514 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8650789058710388 1.0d0) -53)
			   (scale-float (float 8000649532699255 1.0d0) -108)
			   (scale-float (float -8062911270553914 1.0d0) -162)
			   (scale-float (float -8041915918056652 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8643051817502737 1.0d0) -53)
			   (scale-float (float 7139823619402846 1.0d0) -109)
			   (scale-float (float -4914858230587332 1.0d0) -163)
			   (scale-float (float 6743980924865325 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8635233224599694 1.0d0) -53)
			   (scale-float (float -7088298843580067 1.0d0) -107)
			   (scale-float (float 6431133538561354 1.0d0) -161)
			   (scale-float (float -5557182891497346 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8627333353592832 1.0d0) -53)
			   (scale-float (float -5742910758171990 1.0d0) -108)
			   (scale-float (float 8962645513660430 1.0d0) -165)
			   (scale-float (float 6865454473379410 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8619352278838746 1.0d0) -53)
			   (scale-float (float 6580241596413982 1.0d0) -107)
			   (scale-float (float -5012077621452493 1.0d0) -161)
			   (scale-float (float 5420791254282205 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8611290075458352 1.0d0) -53)
			   (scale-float (float 6117993379878867 1.0d0) -107)
			   (scale-float (float 5752090453333422 1.0d0) -161)
			   (scale-float (float 8961357552235688 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8603146819336178 1.0d0) -53)
			   (scale-float (float 8127348605830121 1.0d0) -107)
			   (scale-float (float -7887192887344204 1.0d0) -161)
			   (scale-float (float 5319494234616797 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8594922587119653 1.0d0) -53)
			   (scale-float (float -6092170856221856 1.0d0) -107)
			   (scale-float (float 8740726400738582 1.0d0) -162)
			   (scale-float (float -8711151914884922 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8586617456218381 1.0d0) -53)
			   (scale-float (float -8174862114446858 1.0d0) -108)
			   (scale-float (float -8343560746786883 1.0d0) -162)
			   (scale-float (float -4919904534422867 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8578231504803418 1.0d0) -53)
			   (scale-float (float -6577764069693440 1.0d0) -108)
			   (scale-float (float -6217787362116513 1.0d0) -162)
			   (scale-float (float -7480234698414209 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8569764811806532 1.0d0) -53)
			   (scale-float (float 5086923108014672 1.0d0) -107)
			   (scale-float (float -7256306947528657 1.0d0) -161)
			   (scale-float (float 8041674859768423 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8561217456919463 1.0d0) -53)
			   (scale-float (float 6298936787393783 1.0d0) -108)
			   (scale-float (float -4767967511894935 1.0d0) -162)
			   (scale-float (float -8847251687381265 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8552589520593170 1.0d0) -53)
			   (scale-float (float -4903095784208212 1.0d0) -109)
			   (scale-float (float -5993354562610200 1.0d0) -163)
			   (scale-float (float 7621932199733939 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8543881084037075 1.0d0) -53)
			   (scale-float (float 6707234576005423 1.0d0) -108)
			   (scale-float (float -6949817966021143 1.0d0) -163)
			   (scale-float (float 6010742482639225 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8535092229218300 1.0d0) -53)
			   (scale-float (float 7044972283821195 1.0d0) -107)
			   (scale-float (float -6484078963521046 1.0d0) -164)
			   (scale-float (float 4693487461781030 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8526223038860894 1.0d0) -53)
			   (scale-float (float 5688291050131270 1.0d0) -107)
			   (scale-float (float 5762907725758393 1.0d0) -162)
			   (scale-float (float 6954393126632499 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8517273596445054 1.0d0) -53)
			   (scale-float (float 7467026288494722 1.0d0) -107)
			   (scale-float (float -7311528458402789 1.0d0) -163)
			   (scale-float (float 6638440854815466 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8508243986206341 1.0d0) -53)
			   (scale-float (float 5718052318919608 1.0d0) -109)
			   (scale-float (float 6113951899379181 1.0d0) -163)
			   (scale-float (float -7053239345980276 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8499134293134885 1.0d0) -53)
			   (scale-float (float -7818667001173624 1.0d0) -108)
			   (scale-float (float 4809289711312272 1.0d0) -165)
			   (scale-float (float -7885188792416875 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8489944602974586 1.0d0) -53)
			   (scale-float (float 8590372695674546 1.0d0) -109)
			   (scale-float (float -5336072295288112 1.0d0) -166)
			   (scale-float (float 6731064684041358 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8480675002222309 1.0d0) -53)
			   (scale-float (float -4526446371562791 1.0d0) -107)
			   (scale-float (float 4756672316007874 1.0d0) -161)
			   (scale-float (float -8943278991556374 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8471325578127065 1.0d0) -53)
			   (scale-float (float 4642306313259215 1.0d0) -107)
			   (scale-float (float 8553146367577618 1.0d0) -161)
			   (scale-float (float -5655242195051814 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8461896418689196 1.0d0) -53)
			   (scale-float (float -4553181447976997 1.0d0) -109)
			   (scale-float (float -6593791908274853 1.0d0) -163)
			   (scale-float (float 7491525231836809 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8452387612659540 1.0d0) -53)
			   (scale-float (float 8801356132344547 1.0d0) -107)
			   (scale-float (float -5565388474422551 1.0d0) -161)
			   (scale-float (float -8228993466620115 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8442799249538603 1.0d0) -53)
			   (scale-float (float -5933972051875175 1.0d0) -107)
			   (scale-float (float -6958466561286986 1.0d0) -162)
			   (scale-float (float -4724344086362299 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8433131419575708 1.0d0) -53)
			   (scale-float (float -8446417134371795 1.0d0) -109)
			   (scale-float (float 6106723249054365 1.0d0) -163)
			   (scale-float (float -5724401613088084 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8423384213768154 1.0d0) -53)
			   (scale-float (float -5291176899619174 1.0d0) -107)
			   (scale-float (float -4782794227894570 1.0d0) -162)
			   (scale-float (float 5859801279367932 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8413557723860353 1.0d0) -53)
			   (scale-float (float 7246957581928310 1.0d0) -107)
			   (scale-float (float -7571526425190184 1.0d0) -161)
			   (scale-float (float 8583500343172088 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8403652042342972 1.0d0) -53)
			   (scale-float (float 6821609684893107 1.0d0) -107)
			   (scale-float (float 5278119422243711 1.0d0) -162)
			   (scale-float (float 5583656122229983 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8393667262452058 1.0d0) -53)
			   (scale-float (float -6617897839460155 1.0d0) -107)
			   (scale-float (float 5153678696029531 1.0d0) -161)
			   (scale-float (float 5429144206151925 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8383603478168160 1.0d0) -53)
			   (scale-float (float 6394240597984013 1.0d0) -108)
			   (scale-float (float 7676731287638925 1.0d0) -163)
			   (scale-float (float -6564864277848665 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8373460784215450 1.0d0) -53)
			   (scale-float (float 8321066234508797 1.0d0) -107)
			   (scale-float (float 5546630190255800 1.0d0) -164)
			   (scale-float (float -7258150702831279 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8363239276060827 1.0d0) -53)
			   (scale-float (float -7563437054268512 1.0d0) -108)
			   (scale-float (float -4548139565433169 1.0d0) -162)
			   (scale-float (float -6171043120140633 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8352939049913017 1.0d0) -53)
			   (scale-float (float -8981736255781014 1.0d0) -108)
			   (scale-float (float 5170276812693347 1.0d0) -164)
			   (scale-float (float 8572079675285324 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8342560202721672 1.0d0) -53)
			   (scale-float (float -6052880242154884 1.0d0) -107)
			   (scale-float (float 5981767719278909 1.0d0) -161)
			   (scale-float (float 7283292585326634 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8332102832176454 1.0d0) -53)
			   (scale-float (float 7857171491229206 1.0d0) -110)
			   (scale-float (float -8255170893553344 1.0d0) -166)
			   (scale-float (float 6162188545047406 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8321567036706118 1.0d0) -53)
			   (scale-float (float 5726145159043778 1.0d0) -108)
			   (scale-float (float -5897748070929945 1.0d0) -163)
			   (scale-float (float -8525804628143368 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8310952915477583 1.0d0) -53)
			   (scale-float (float 8593867710650143 1.0d0) -107)
			   (scale-float (float -6680313484611995 1.0d0) -163)
			   (scale-float (float 6353210804206738 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8300260568395001 1.0d0) -53)
			   (scale-float (float 6756450875854190 1.0d0) -107)
			   (scale-float (float 6951770272627742 1.0d0) -162)
			   (scale-float (float 8788284451425813 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8289490096098815 1.0d0) -53)
			   (scale-float (float -4511925664156885 1.0d0) -107)
			   (scale-float (float 7895328143001416 1.0d0) -161)
			   (scale-float (float 6317989146996191 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8278641599964811 1.0d0) -53)
			   (scale-float (float -8598600866676053 1.0d0) -108)
			   (scale-float (float 7646998035931427 1.0d0) -163)
			   (scale-float (float -6107518997826040 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8267715182103167 1.0d0) -53)
			   (scale-float (float -6340213041420117 1.0d0) -107)
			   (scale-float (float 6724262794318068 1.0d0) -161)
			   (scale-float (float 8393760923297867 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8256710945357489 1.0d0) -53)
			   (scale-float (float -6771725202789936 1.0d0) -107)
			   (scale-float (float 7070420353684526 1.0d0) -162)
			   (scale-float (float 5197890020650731 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8245628993303844 1.0d0) -53)
			   (scale-float (float -8821100121339757 1.0d0) -109)
			   (scale-float (float 7006208221552511 1.0d0) -163)
			   (scale-float (float 4508060286446889 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8234469430249786 1.0d0) -53)
			   (scale-float (float -5892637514160882 1.0d0) -107)
			   (scale-float (float -5681973386408990 1.0d0) -161)
			   (scale-float (float 5969243766468564 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8223232361233372 1.0d0) -53)
			   (scale-float (float -7777493634914173 1.0d0) -107)
			   (scale-float (float -5189369030967820 1.0d0) -161)
			   (scale-float (float 6842397883496982 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8211917892022175 1.0d0) -53)
			   (scale-float (float -8733856484976210 1.0d0) -108)
			   (scale-float (float -4857152382333282 1.0d0) -166)
			   (scale-float (float 7641915463494354 1.0d0) -222))
	       (%make-qd-d (scale-float (float 8200526129112289 1.0d0) -53)
			   (scale-float (float -8183228870209481 1.0d0) -107)
			   (scale-float (float 6394798226217471 1.0d0) -162)
			   (scale-float (float 8035603526856955 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8189057179727324 1.0d0) -53)
			   (scale-float (float -4787111311971082 1.0d0) -110)
			   (scale-float (float 7003826926247311 1.0d0) -164)
			   (scale-float (float -5150051672214856 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8177511151817401 1.0d0) -53)
			   (scale-float (float -8025338039515614 1.0d0) -107)
			   (scale-float (float -4852092691112809 1.0d0) -161)
			   (scale-float (float -5468362093021944 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8165888154058130 1.0d0) -53)
			   (scale-float (float 4949998156142078 1.0d0) -107)
			   (scale-float (float -8464337333963361 1.0d0) -162)
			   (scale-float (float 7964294201530510 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8154188295849595 1.0d0) -53)
			   (scale-float (float -6677472217191581 1.0d0) -107)
			   (scale-float (float 8727903250458773 1.0d0) -161)
			   (scale-float (float 5386228110507442 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8142411687315315 1.0d0) -53)
			   (scale-float (float -8579951840942254 1.0d0) -110)
			   (scale-float (float 5952643804849413 1.0d0) -165)
			   (scale-float (float -7249883042029233 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8130558439301216 1.0d0) -53)
			   (scale-float (float -6247237565047575 1.0d0) -108)
			   (scale-float (float 7741357282149559 1.0d0) -162)
			   (scale-float (float -5578500633872854 1.0d0) -216))
	       (%make-qd-d (scale-float (float 8118628663374582 1.0d0) -53)
			   (scale-float (float -8778090168280888 1.0d0) -109)
			   (scale-float (float 7436746217749520 1.0d0) -163)
			   (scale-float (float 7630381168256317 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8106622471823008 1.0d0) -53)
			   (scale-float (float -8216747803830756 1.0d0) -107)
			   (scale-float (float 6304056001984601 1.0d0) -162)
			   (scale-float (float 5924872968038470 1.0d0) -217))
	       (%make-qd-d (scale-float (float 8094539977653340 1.0d0) -53)
			   (scale-float (float 8540324421498539 1.0d0) -108)
			   (scale-float (float 6922258608862064 1.0d0) -167)
			   (scale-float (float -7901865974785605 1.0d0) -221))
	       (%make-qd-d (scale-float (float 8082381294590617 1.0d0) -53)
			   (scale-float (float -5905634609941531 1.0d0) -107)
			   (scale-float (float -6901692996464097 1.0d0) -161)
			   (scale-float (float 6233038068306105 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8070146537076992 1.0d0) -53)
			   (scale-float (float 7954777128849873 1.0d0) -107)
			   (scale-float (float -5682461538967622 1.0d0) -161)
			   (scale-float (float -8988660354400493 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8057835820270665 1.0d0) -53)
			   (scale-float (float -5684340455847933 1.0d0) -108)
			   (scale-float (float -7717120355166554 1.0d0) -162)
			   (scale-float (float -6720192119717512 1.0d0) -218))
	       (%make-qd-d (scale-float (float 8045449260044789 1.0d0) -53)
			   (scale-float (float -5343034318546435 1.0d0) -110)
			   (scale-float (float 5934925198868450 1.0d0) -164)
			   (scale-float (float 7220118970499754 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8032986972986387 1.0d0) -53)
			   (scale-float (float 6060738122016655 1.0d0) -110)
			   (scale-float (float 7553159386729597 1.0d0) -165)
			   (scale-float (float -6675526920595727 1.0d0) -220))
	       (%make-qd-d (scale-float (float 8020449076395251 1.0d0) -53)
			   (scale-float (float 7646910712788417 1.0d0) -109)
			   (scale-float (float -6241730781228944 1.0d0) -165)
			   (scale-float (float -8002249139712356 1.0d0) -219))
	       (%make-qd-d (scale-float (float 8007835688282839 1.0d0) -53)
			   (scale-float (float -7246184498625959 1.0d0) -109)
			   (scale-float (float -8137088343486848 1.0d0) -164)
			   (scale-float (float -6573626944638042 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7995146927371163 1.0d0) -53)
			   (scale-float (float 8310979817766747 1.0d0) -109)
			   (scale-float (float 7473299446962253 1.0d0) -167)
			   (scale-float (float -4891403068085004 1.0d0) -221))
	       (%make-qd-d (scale-float (float 7982382913091674 1.0d0) -53)
			   (scale-float (float -8736996093293672 1.0d0) -110)
			   (scale-float (float 5792500826087577 1.0d0) -165)
			   (scale-float (float 6862659397941285 1.0d0) -221))
	       (%make-qd-d (scale-float (float 7969543765584135 1.0d0) -53)
			   (scale-float (float -6122462417693605 1.0d0) -109)
			   (scale-float (float -6676904309874182 1.0d0) -163)
			   (scale-float (float 7692066278000649 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7956629605695492 1.0d0) -53)
			   (scale-float (float 5134741344813474 1.0d0) -108)
			   (scale-float (float -4613745536456255 1.0d0) -162)
			   (scale-float (float -6227040409576694 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7943640554978737 1.0d0) -53)
			   (scale-float (float -6439502272564487 1.0d0) -108)
			   (scale-float (float -8232593592811641 1.0d0) -163)
			   (scale-float (float -8961461139920910 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7930576735691761 1.0d0) -53)
			   (scale-float (float 5293253478187253 1.0d0) -108)
			   (scale-float (float -6727743417874982 1.0d0) -163)
			   (scale-float (float -8452072153366346 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7917438270796208 1.0d0) -53)
			   (scale-float (float -7684086171775532 1.0d0) -107)
			   (scale-float (float 8411685124468258 1.0d0) -162)
			   (scale-float (float -6126132756509931 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7904225283956311 1.0d0) -53)
			   (scale-float (float 8131349739729868 1.0d0) -107)
			   (scale-float (float 6637034140521224 1.0d0) -164)
			   (scale-float (float 6550694306870995 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7890937899537737 1.0d0) -53)
			   (scale-float (float 7623463201024326 1.0d0) -110)
			   (scale-float (float 6533764524387989 1.0d0) -164)
			   (scale-float (float -7808305661254231 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7877576242606407 1.0d0) -53)
			   (scale-float (float -5941713289950576 1.0d0) -113)
			   (scale-float (float -5557131795313346 1.0d0) -167)
			   (scale-float (float 5890046981724174 1.0d0) -222))
	       (%make-qd-d (scale-float (float 7864140438927325 1.0d0) -53)
			   (scale-float (float 5090052289978408 1.0d0) -109)
			   (scale-float (float -5692258429067560 1.0d0) -163)
			   (scale-float (float -4805520048585976 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7850630614963393 1.0d0) -53)
			   (scale-float (float -8968556689917822 1.0d0) -107)
			   (scale-float (float -6461032805259083 1.0d0) -161)
			   (scale-float (float -5147125785674736 1.0d0) -215))
	       (%make-qd-d (scale-float (float 7837046897874218 1.0d0) -53)
			   (scale-float (float -6796799480983562 1.0d0) -107)
			   (scale-float (float 8289659017936051 1.0d0) -163)
			   (scale-float (float 7919537224500868 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7823389415514919 1.0d0) -53)
			   (scale-float (float 5647719797707326 1.0d0) -114)
			   (scale-float (float -6252005772837378 1.0d0) -168)
			   (scale-float (float -8509580097279105 1.0d0) -222))
	       (%make-qd-d (scale-float (float 7809658296434922 1.0d0) -53)
			   (scale-float (float 7857985603043508 1.0d0) -111)
			   (scale-float (float -5406124386166429 1.0d0) -165)
			   (scale-float (float -7222644714405805 1.0d0) -223))
	       (%make-qd-d (scale-float (float 7795853669876749 1.0d0) -53)
			   (scale-float (float -8271733057494906 1.0d0) -110)
			   (scale-float (float 5547981887481697 1.0d0) -164)
			   (scale-float (float 6702866336981504 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7781975665774802 1.0d0) -53)
			   (scale-float (float 6731546115920822 1.0d0) -107)
			   (scale-float (float 6638133694034468 1.0d0) -161)
			   (scale-float (float -8554347442337204 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7768024414754142 1.0d0) -53)
			   (scale-float (float 6005052363670948 1.0d0) -107)
			   (scale-float (float 6094860705689399 1.0d0) -163)
			   (scale-float (float 5675405789834798 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7754000048129257 1.0d0) -53)
			   (scale-float (float -4875899202965061 1.0d0) -107)
			   (scale-float (float -5185769273148547 1.0d0) -162)
			   (scale-float (float 6320978780778161 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7739902697902825 1.0d0) -53)
			   (scale-float (float 6885578824615594 1.0d0) -107)
			   (scale-float (float 8907187678671986 1.0d0) -163)
			   (scale-float (float -8339075431974752 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7725732496764478 1.0d0) -53)
			   (scale-float (float -7818211417288033 1.0d0) -107)
			   (scale-float (float -6456405933798609 1.0d0) -162)
			   (scale-float (float 8810079633059484 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7711489578089543 1.0d0) -53)
			   (scale-float (float 5958610143385566 1.0d0) -109)
			   (scale-float (float 6585953111264567 1.0d0) -163)
			   (scale-float (float 7861064189197966 1.0d0) -221))
	       (%make-qd-d (scale-float (float 7697174075937797 1.0d0) -53)
			   (scale-float (float -8431721695184386 1.0d0) -109)
			   (scale-float (float 6029995679316329 1.0d0) -165)
			   (scale-float (float -4921123855682338 1.0d0) -223))
	       (%make-qd-d (scale-float (float 7682786125052197 1.0d0) -53)
			   (scale-float (float 8811647176963032 1.0d0) -108)
			   (scale-float (float 8691431362536178 1.0d0) -163)
			   (scale-float (float 8880441644193018 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7668325860857618 1.0d0) -53)
			   (scale-float (float -8645153897161875 1.0d0) -107)
			   (scale-float (float 6512789306468078 1.0d0) -161)
			   (scale-float (float -8484355539904639 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7653793419459571 1.0d0) -53)
			   (scale-float (float 8407034062131169 1.0d0) -107)
			   (scale-float (float 9005956094764978 1.0d0) -161)
			   (scale-float (float -5461770985431486 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7639188937642932 1.0d0) -53)
			   (scale-float (float 6088799942438190 1.0d0) -108)
			   (scale-float (float 8212922076806082 1.0d0) -162)
			   (scale-float (float -5247758149286959 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7624512552870645 1.0d0) -53)
			   (scale-float (float -7783483392394296 1.0d0) -107)
			   (scale-float (float -8043598484014106 1.0d0) -161)
			   (scale-float (float -7742450129971733 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7609764403282432 1.0d0) -53)
			   (scale-float (float -7079592968846542 1.0d0) -107)
			   (scale-float (float -5935955209333083 1.0d0) -161)
			   (scale-float (float 4538668036895069 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7594944627693494 1.0d0) -53)
			   (scale-float (float 5012472405203384 1.0d0) -112)
			   (scale-float (float 8678696578736612 1.0d0) -171)
			   (scale-float (float 5214866625493772 1.0d0) -225))
	       (%make-qd-d (scale-float (float 7580053365593204 1.0d0) -53)
			   (scale-float (float -5532305557551308 1.0d0) -107)
			   (scale-float (float -4918257505158720 1.0d0) -162)
			   (scale-float (float -5207406790673379 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7565090757143791 1.0d0) -53)
			   (scale-float (float -5410923347089996 1.0d0) -108)
			   (scale-float (float -8628228715534538 1.0d0) -162)
			   (scale-float (float -7982155484674416 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7550056943179025 1.0d0) -53)
			   (scale-float (float -5769953684661576 1.0d0) -107)
			   (scale-float (float 6833859811950236 1.0d0) -162)
			   (scale-float (float -6174180304901008 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7534952065202888 1.0d0) -53)
			   (scale-float (float -6782132408285718 1.0d0) -108)
			   (scale-float (float -4588137587016523 1.0d0) -165)
			   (scale-float (float -5326135934499720 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7519776265388244 1.0d0) -53)
			   (scale-float (float 7471785049762459 1.0d0) -107)
			   (scale-float (float -6059669116863189 1.0d0) -163)
			   (scale-float (float -5940063433657282 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7504529686575502 1.0d0) -53)
			   (scale-float (float 6892841323703210 1.0d0) -112)
			   (scale-float (float 4544841146313886 1.0d0) -166)
			   (scale-float (float 7653639258512367 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7489212472271267 1.0d0) -53)
			   (scale-float (float 7307564340927176 1.0d0) -112)
			   (scale-float (float 8783286311491533 1.0d0) -167)
			   (scale-float (float -5455043666319984 1.0d0) -224))
	       (%make-qd-d (scale-float (float 7473824766646994 1.0d0) -53)
			   (scale-float (float -7619464420816061 1.0d0) -111)
			   (scale-float (float 5376884603206074 1.0d0) -165)
			   (scale-float (float 5928941415547088 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7458366714537629 1.0d0) -53)
			   (scale-float (float -7171307255144825 1.0d0) -107)
			   (scale-float (float 8175016055708132 1.0d0) -161)
			   (scale-float (float 5281820716761617 1.0d0) -215))
	       (%make-qd-d (scale-float (float 7442838461440245 1.0d0) -53)
			   (scale-float (float -8755102569226029 1.0d0) -107)
			   (scale-float (float 8064787730576089 1.0d0) -163)
			   (scale-float (float 8026094972828839 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7427240153512674 1.0d0) -53)
			   (scale-float (float -8603752879918352 1.0d0) -108)
			   (scale-float (float 7911734751209565 1.0d0) -165)
			   (scale-float (float 5703206095815899 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7411571937572131 1.0d0) -53)
			   (scale-float (float 4930416562782670 1.0d0) -108)
			   (scale-float (float 5664227737707146 1.0d0) -162)
			   (scale-float (float 6002228034137708 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7395833961093832 1.0d0) -53)
			   (scale-float (float 4983815042703658 1.0d0) -107)
			   (scale-float (float -4979969880744113 1.0d0) -161)
			   (scale-float (float -5871087828457004 1.0d0) -215))
	       (%make-qd-d (scale-float (float 7380026372209606 1.0d0) -53)
			   (scale-float (float -7821016727474824 1.0d0) -107)
			   (scale-float (float -5827108382516599 1.0d0) -168)
			   (scale-float (float -5157322064549901 1.0d0) -225))
	       (%make-qd-d (scale-float (float 7364149319706498 1.0d0) -53)
			   (scale-float (float -4829858251010421 1.0d0) -108)
			   (scale-float (float -4575860067979415 1.0d0) -162)
			   (scale-float (float 8705566695469741 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7348202953025374 1.0d0) -53)
			   (scale-float (float 5364466528429990 1.0d0) -109)
			   (scale-float (float -5385055512047183 1.0d0) -164)
			   (scale-float (float 6361734986933710 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7332187422259511 1.0d0) -53)
			   (scale-float (float -8458146418590874 1.0d0) -107)
			   (scale-float (float -5567640357155716 1.0d0) -161)
			   (scale-float (float -8918513373518274 1.0d0) -215))
	       (%make-qd-d (scale-float (float 7316102878153182 1.0d0) -53)
			   (scale-float (float 5038888112811017 1.0d0) -107)
			   (scale-float (float 5296374816773052 1.0d0) -164)
			   (scale-float (float -6253164519860774 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7299949472100244 1.0d0) -53)
			   (scale-float (float 7632795593885122 1.0d0) -108)
			   (scale-float (float -4532413022792557 1.0d0) -162)
			   (scale-float (float -7665957245126532 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7283727356142706 1.0d0) -53)
			   (scale-float (float 6052374734052898 1.0d0) -109)
			   (scale-float (float -8397589869895301 1.0d0) -163)
			   (scale-float (float 5039286009373352 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7267436682969301 1.0d0) -53)
			   (scale-float (float 7986499572183919 1.0d0) -107)
			   (scale-float (float 8709385497029640 1.0d0) -161)
			   (scale-float (float 8014662541064248 1.0d0) -215))
	       (%make-qd-d (scale-float (float 7251077605914050 1.0d0) -53)
			   (scale-float (float 8334981517291728 1.0d0) -107)
			   (scale-float (float 7375650104466233 1.0d0) -163)
			   (scale-float (float 6173629469842000 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7234650278954817 1.0d0) -53)
			   (scale-float (float -5364390638462068 1.0d0) -107)
			   (scale-float (float -7157105785322597 1.0d0) -162)
			   (scale-float (float 5984618093282123 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7218154856711858 1.0d0) -53)
			   (scale-float (float -6801264200501575 1.0d0) -108)
			   (scale-float (float -5120886861157727 1.0d0) -163)
			   (scale-float (float 8524267759255856 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7201591494446370 1.0d0) -53)
			   (scale-float (float 6606134571941243 1.0d0) -108)
			   (scale-float (float -5696846492939078 1.0d0) -162)
			   (scale-float (float 7226358878672853 1.0d0) -223))
	       (%make-qd-d (scale-float (float 7184960348059028 1.0d0) -53)
			   (scale-float (float -7582499304585468 1.0d0) -107)
			   (scale-float (float 6745092272239030 1.0d0) -161)
			   (scale-float (float 5325527634933226 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7168261574088514 1.0d0) -53)
			   (scale-float (float -4877955993986654 1.0d0) -107)
			   (scale-float (float -6575649792954184 1.0d0) -161)
			   (scale-float (float -6938160611470782 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7151495329710049 1.0d0) -53)
			   (scale-float (float -4815506917589854 1.0d0) -109)
			   (scale-float (float 5641242290599654 1.0d0) -164)
			   (scale-float (float -8417705599718850 1.0d0) -220))
	       (%make-qd-d (scale-float (float 7134661772733911 1.0d0) -53)
			   (scale-float (float -6017847752979687 1.0d0) -107)
			   (scale-float (float -8695617460185062 1.0d0) -162)
			   (scale-float (float 6176165148681625 1.0d0) -217))
	       (%make-qd-d (scale-float (float 7117761061603948 1.0d0) -53)
			   (scale-float (float 7482393772340198 1.0d0) -108)
			   (scale-float (float 8465649163872175 1.0d0) -162)
			   (scale-float (float -8080110543307406 1.0d0) -216))
	       (%make-qd-d (scale-float (float 7100793355396091 1.0d0) -53)
			   (scale-float (float 5581231234277131 1.0d0) -107)
			   (scale-float (float 5176821120801589 1.0d0) -161)
			   (scale-float (float 8995859729422842 1.0d0) -215))
	       (%make-qd-d (scale-float (float 7083758813816853 1.0d0) -53)
			   (scale-float (float -6350271866355127 1.0d0) -109)
			   (scale-float (float 7928602718099880 1.0d0) -164)
			   (scale-float (float 4824946278411294 1.0d0) -219))
	       (%make-qd-d (scale-float (float 7066657597201826 1.0d0) -53)
			   (scale-float (float -5557572698368406 1.0d0) -109)
			   (scale-float (float -4935627699312564 1.0d0) -164)
			   (scale-float (float -7115034144224561 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7049489866514174 1.0d0) -53)
			   (scale-float (float 5889743500293894 1.0d0) -109)
			   (scale-float (float 7906589096317472 1.0d0) -163)
			   (scale-float (float -7234212083698060 1.0d0) -218))
	       (%make-qd-d (scale-float (float 7032255783343117 1.0d0) -53)
			   (scale-float (float -6438369056191217 1.0d0) -109)
			   (scale-float (float -6365182518869508 1.0d0) -171)
			   (scale-float (float 5309542037636005 1.0d0) -230))
	       (%make-qd-d (scale-float (float 7014955509902409 1.0d0) -53)
			   (scale-float (float -8077716446967319 1.0d0) -108)
			   (scale-float (float 6329167020324237 1.0d0) -166)
			   (scale-float (float -8791449117706018 1.0d0) -223))
	       (%make-qd-d (scale-float (float 6997589209028812 1.0d0) -53)
			   (scale-float (float 5024754586498263 1.0d0) -109)
			   (scale-float (float -7013631527035059 1.0d0) -163)
			   (scale-float (float 6438066485620793 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6980157044180565 1.0d0) -53)
			   (scale-float (float -8471408082297477 1.0d0) -107)
			   (scale-float (float -5650375399951533 1.0d0) -162)
			   (scale-float (float 7798954431786796 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6962659179435841 1.0d0) -53)
			   (scale-float (float -5284120524567405 1.0d0) -107)
			   (scale-float (float 8103036997132110 1.0d0) -162)
			   (scale-float (float -8418944709321890 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6945095779491208 1.0d0) -53)
			   (scale-float (float -7230020631985237 1.0d0) -107)
			   (scale-float (float -8729130008304460 1.0d0) -161)
			   (scale-float (float -7244986705962520 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6927467009660074 1.0d0) -53)
			   (scale-float (float 8363890541356943 1.0d0) -107)
			   (scale-float (float 7641557639387694 1.0d0) -161)
			   (scale-float (float -8529781507802362 1.0d0) -215))
	       (%make-qd-d (scale-float (float 6909773035871137 1.0d0) -53)
			   (scale-float (float -6128826147983157 1.0d0) -108)
			   (scale-float (float -7985270411148689 1.0d0) -162)
			   (scale-float (float -4747232722969418 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6892014024666815 1.0d0) -53)
			   (scale-float (float -5307050774979789 1.0d0) -107)
			   (scale-float (float 6534150355198809 1.0d0) -162)
			   (scale-float (float -7794201099075978 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6874190143201685 1.0d0) -53)
			   (scale-float (float 6831699276871462 1.0d0) -111)
			   (scale-float (float 6569994269441010 1.0d0) -165)
			   (scale-float (float 6039155211825079 1.0d0) -222))
	       (%make-qd-d (scale-float (float 6856301559240908 1.0d0) -53)
			   (scale-float (float 5730269256517324 1.0d0) -107)
			   (scale-float (float 7502511311955837 1.0d0) -162)
			   (scale-float (float -8934221579630434 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6838348441158650 1.0d0) -53)
			   (scale-float (float -6256529846772154 1.0d0) -107)
			   (scale-float (float 6949788990055632 1.0d0) -164)
			   (scale-float (float -5274624651616658 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6820330957936494 1.0d0) -53)
			   (scale-float (float -6460871939863669 1.0d0) -108)
			   (scale-float (float 4607738561562238 1.0d0) -163)
			   (scale-float (float 8738499798315367 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6802249279161855 1.0d0) -53)
			   (scale-float (float -6296386214088169 1.0d0) -108)
			   (scale-float (float -8828921206139670 1.0d0) -164)
			   (scale-float (float -8935639395611922 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6784103575026380 1.0d0) -53)
			   (scale-float (float -6155758343732070 1.0d0) -107)
			   (scale-float (float -7834764184816714 1.0d0) -163)
			   (scale-float (float -5655570170200821 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6765894016324346 1.0d0) -53)
			   (scale-float (float 7058239787845383 1.0d0) -107)
			   (scale-float (float 7374070516477953 1.0d0) -161)
			   (scale-float (float -6947421257903780 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6747620774451057 1.0d0) -53)
			   (scale-float (float -7257707922049303 1.0d0) -107)
			   (scale-float (float -7075429107224891 1.0d0) -161)
			   (scale-float (float 5969459465011328 1.0d0) -215))
	       (%make-qd-d (scale-float (float 6729284021401222 1.0d0) -53)
			   (scale-float (float 7707201987390816 1.0d0) -109)
			   (scale-float (float 5142737538491299 1.0d0) -164)
			   (scale-float (float 4644279882924390 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6710883929767346 1.0d0) -53)
			   (scale-float (float 4893313667710853 1.0d0) -108)
			   (scale-float (float 4729360090805088 1.0d0) -162)
			   (scale-float (float 8707005308054696 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6692420672738099 1.0d0) -53)
			   (scale-float (float -8159898852694060 1.0d0) -108)
			   (scale-float (float 8316410770739968 1.0d0) -163)
			   (scale-float (float 6356993048951430 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6673894424096687 1.0d0) -53)
			   (scale-float (float -4773219099675351 1.0d0) -108)
			   (scale-float (float -5793443213505971 1.0d0) -163)
			   (scale-float (float 6620801067481707 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6655305358219218 1.0d0) -53)
			   (scale-float (float 5569529363635887 1.0d0) -107)
			   (scale-float (float -8012910396303650 1.0d0) -162)
			   (scale-float (float -5648248265418359 1.0d0) -220))
	       (%make-qd-d (scale-float (float 6636653650073061 1.0d0) -53)
			   (scale-float (float -4694561351059034 1.0d0) -107)
			   (scale-float (float -8102538682924120 1.0d0) -164)
			   (scale-float (float -7786569469548835 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6617939475215195 1.0d0) -53)
			   (scale-float (float -5599177568223260 1.0d0) -107)
			   (scale-float (float -6932779364632684 1.0d0) -161)
			   (scale-float (float -8360972497909144 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6599163009790561 1.0d0) -53)
			   (scale-float (float 6139460555376271 1.0d0) -108)
			   (scale-float (float -8841336350505836 1.0d0) -162)
			   (scale-float (float -8249924986768898 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6580324430530404 1.0d0) -53)
			   (scale-float (float -4817471423188767 1.0d0) -107)
			   (scale-float (float -6592466314970465 1.0d0) -162)
			   (scale-float (float -6430688881172527 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6561423914750605 1.0d0) -53)
			   (scale-float (float 4953302629983138 1.0d0) -115)
			   (scale-float (float 8830091491978098 1.0d0) -170)
			   (scale-float (float 6566412636432061 1.0d0) -225))
	       (%make-qd-d (scale-float (float 6542461640350018 1.0d0) -53)
			   (scale-float (float -5178910864670558 1.0d0) -107)
			   (scale-float (float 4504226005724943 1.0d0) -162)
			   (scale-float (float 8731627485611706 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6523437785808790 1.0d0) -53)
			   (scale-float (float 4737722843238748 1.0d0) -107)
			   (scale-float (float 6730894629032702 1.0d0) -161)
			   (scale-float (float -8714007801572383 1.0d0) -222))
	       (%make-qd-d (scale-float (float 6504352530186687 1.0d0) -53)
			   (scale-float (float -7746667435587544 1.0d0) -108)
			   (scale-float (float 6217885893994028 1.0d0) -162)
			   (scale-float (float -4696784861307301 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6485206053121402 1.0d0) -53)
			   (scale-float (float -8336770935428512 1.0d0) -108)
			   (scale-float (float -5348661455957571 1.0d0) -162)
			   (scale-float (float 4676263914929793 1.0d0) -216))
	       (%make-qd-d (scale-float (float 6465998534826869 1.0d0) -53)
			   (scale-float (float 8764102551217140 1.0d0) -108)
			   (scale-float (float -5344409034097828 1.0d0) -164)
			   (scale-float (float 7727976365078167 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6446730156091567 1.0d0) -53)
			   (scale-float (float -8369498756096622 1.0d0) -107)
			   (scale-float (float -6424186581703649 1.0d0) -165)
			   (scale-float (float 7285509676227856 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6427401098276813 1.0d0) -53)
			   (scale-float (float -6870464143590238 1.0d0) -107)
			   (scale-float (float -4991363196461545 1.0d0) -163)
			   (scale-float (float -5550457137190991 1.0d0) -217))
	       (%make-qd-d (scale-float (float 6408011543315061 1.0d0) -53)
			   (scale-float (float 5169145614950999 1.0d0) -109)
			   (scale-float (float 6895537652308040 1.0d0) -164)
			   (scale-float (float 7155016695131698 1.0d0) -218))
	       (%make-qd-d (scale-float (float 6388561673708188 1.0d0) -53)
			   (scale-float (float -6100520299916709 1.0d0) -107)
			   (scale-float (float 4963552307172142 1.0d0) -165)
			   (scale-float (float 7537451794849143 1.0d0) -219))
	       (%make-qd-d (scale-float (float 6369051672525773 1.0d0) -53)
			   (scale-float (float -7843040109683798 1.0d0) -107)
			   (scale-float (float 6048680740045173 1.0d0) -161)
			   (scale-float (float 5197737643093849 1.0d0) -217))))
   "A table of cos(k/1024) for k = 1 to 256")


#||
;; Here is a function for clisp that can be used to create the atan2 table
;; that we need.

(defun make-atan-table-data ()
  (let ((scale 1l0))
    (dotimes (k 67)
      (let* ((x (scale-float 1L0 (- 2 k)))
	     (p (atan x)))
	(setf scale (* scale (cos p)))
	(multiple-value-bind (int exp sign)
	    (integer-decode-float p)
	  (let* ((len (integer-length int))
		 (wanted (ldb (byte 212 (- len 212)) int))
		 (bit (ldb (byte 1 (- len (* 4 53) 1)) int))
		 (roundp (not (zerop (ldb (byte (- len (* 4 53) 2) 0) int)))))
	    ;;(format t "~&~v,'0b~%" len int)
	    ;;(format t "~b~a~%" wanted (make-string (- len 212) :initial-element #\-))
	    ;;(format t "~v,'-b~%" len (ash bit (- len 212 1)))
	    ;;(format t "~v,'-b~%" len (ldb (byte (- len (* 4 53) 2) 0) int))
	    ;; See if we need to round up the answer.  
	    (when (= bit 1)
	      ;; Round to even
	      (cond (roundp
		     (incf wanted))
		    (t
		     ;; Round to even
		     (when (oddp wanted)
		       (incf wanted)))))
	    ;;(format t "~b~a~%" wanted (make-string (- len 212) :initial-element #\-))
	    
	    (let* ((i0 (ldb (byte 53 (* 3 53)) wanted))
		   (i1 (ldb (byte 53 (* 2 53)) wanted))
		   (i2 (ldb (byte 53 (* 1 53)) wanted))
		   (i3 (ldb (byte 53 0) wanted)))
	      (write `(make-qd-d
		       (scale-float (float ,i0 1d0) ,(+ exp (- len (* 1 53))))
		       (scale-float (float ,i1 1d0) ,(+ exp (- len (* 2 53))))
		       (scale-float (float ,i2 1d0) ,(+ exp (- len (* 3 53))))
		       (scale-float (float ,i3 1d0) ,(+ exp (- len (* 4 53)))))
		     :case :downcase))))))
    scale))
||#
	       
	
#+nil
(defconstant +atan-table+
  (make-array 66
	      :initial-contents
	      (list
	       +qd-pi/4+
	       +qd-pi/4+
	       +qd-pi/4+
	       ;; Do we need to make these values more accurate?  (The
	       ;; reader has quite a bit of roundoff.)
	       #.(qd-from-string "0.46364760900080611621425623146121440202853705428612026381093308872018q0") 
	       #.(qd-from-string "0.24497866312686415417208248121127581091414409838118406712737591466738q0")
	       #.(qd-from-string "0.12435499454676143503135484916387102557317019176980408991511411911572q0")
	       #.(qd-from-string "0.062418809995957348473979112985505113606273887797499194607527816898697q0")
	       #.(qd-from-string "0.031239833430268276253711744892490977032495663725400040255315586255793q0")
	       #.(qd-from-string "0.0156237286204768308028015212565703189111141398009054178814105073966645q0")
	       #.(qd-from-string "0.0078123410601011112964633918421992816212228117250147235574539022483893q0")
	       #.(qd-from-string "0.003906230131966971827628665311424387140357490115202856215213095149011q0")
	       #.(qd-from-string "0.00195312251647881868512148262507671393161074677723351033905753396043094q0")
	       #.(qd-from-string "9.7656218955931943040343019971729085163419701581008759004900725226773q-4")
	       #.(qd-from-string "4.8828121119489827546923962564484866619236113313500303710940335348752q-4")
	       #.(qd-from-string "2.4414062014936176401672294325965998621241779097061761180790046091019q-4") 
	       #.(qd-from-string "1.22070311893670204239058646117956300930829409015787498451939837846645q-4") 
	       #.(qd-from-string "6.1035156174208775021662569173829153785143536833346179337671134316588q-5") 
	       #.(qd-from-string "3.0517578115526096861825953438536019750949675119437837531021156883611q-5") 
	       #.(qd-from-string "1.5258789061315762107231935812697885137429238144575874846241186407446q-5") 
	       #.(qd-from-string "7.6293945311019702633884823401050905863507439184680771577638306965336q-6") 
	       #.(qd-from-string "3.8146972656064962829230756163729937228052573039688663101874392503939q-6") 
	       #.(qd-from-string "1.9073486328101870353653693059172441687143421654501533666700577234671q-6") 
	       #.(qd-from-string "9.53674316405960879420670689923112390019634124498790160133611802076q-7") 
	       #.(qd-from-string "4.7683715820308885992758382144924707587049404378664196740053215887142q-7") 
	       #.(qd-from-string "2.3841857910155798249094797721893269783096898769063155913766911372218q-7") 
	       #.(qd-from-string "1.19209289550780685311368497137922112645967587664586735576738225215437q-7") 
	       #.(qd-from-string "5.9604644775390554413921062141788874250030195782366297314294565710003q-8") 
	       #.(qd-from-string "2.9802322387695303676740132767709503349043907067445107249258477840843q-8") 
	       #.(qd-from-string "1.4901161193847655147092516595963247108248930025964720012170057805491q-8") 
	       #.(qd-from-string "7.4505805969238279871365645744953921132066925545665870075947601416172q-9") 
	       #.(qd-from-string "3.725290298461914045267070571811923583671948328737040524231998269239q-9") 
	       #.(qd-from-string "1.8626451492309570290958838214764904345065282835738863513491050124951q-9") 
	       #.(qd-from-string "9.3132257461547851535573547768456130389292649614929067394376854242196q-10") 
	       #.(qd-from-string "4.6566128730773925777884193471057016297347863891561617421323492554414q-10") 
	       #.(qd-from-string "2.32830643653869628902042741838821270371274293204981860525486662280605q-10") 
	       #.(qd-from-string "1.16415321826934814452599092729852658796396457380014290026584979170883q-10") 
	       #.(qd-from-string "5.8207660913467407226496761591231582349549156257795272423976206167147q-11") 
	       #.(qd-from-string "2.9103830456733703613273032698903947793693632003639830495829934525029q-11") 
	       #.(qd-from-string "1.4551915228366851806639597837362993474211703608936710732067270213307q-11") 
	       #.(qd-from-string "7.2759576141834259033201841046703741842764629388821429640111752890838q-12") 
	       #.(qd-from-string "3.6379788070917129516601402005837967730345578669779258118296083646486q-12") 
	       #.(qd-from-string "1.81898940354585647583007611882297459662931973336029253714520765350336q-12") 
	       #.(qd-from-string "9.094947017729282379150388117278718245786649666696631862264792881855q-13") 
	       #.(qd-from-string "4.5474735088646411895751949990348397807233312083369623012466392138249q-13") 
	       #.(qd-from-string "2.2737367544323205947875976170668549725904164010421166413578155299654q-13") 
	       #.(qd-from-string "1.1368683772161602973937988232271068715738020501302644662229139921281q-13") 
	       #.(qd-from-string "5.6843418860808014869689941345026335894672525626628305471702634435609q-14") 
	       #.(qd-from-string "2.8421709430404007434844970695472041986834065703328538172835210852389q-14") 
	       #.(qd-from-string "1.42108547152020037174224853506058802483542582129160672712566632799217q-14") 
	       #.(qd-from-string "7.1054273576010018587112426756616725310442822766145084088962160950957q-15") 
	       #.(qd-from-string "3.5527136788005009293556213378756778163805352845768135511116874239215q-15") 
	       #.(qd-from-string "1.7763568394002504646778106689434441020475669105721016938889503158663q-15") 
	       #.(qd-from-string "8.881784197001252323389053344724227002559458638215127117361184578544q-16") 
	       #.(qd-from-string "4.440892098500626161694526672362989312819932329776890889670147968684q-16") 
	       #.(qd-from-string "2.22044604925031308084726333618160413285249154122211136120876849284695q-16") 
	       #.(qd-from-string "1.11022302462515654042363166809081575098156144265276392015109606150467q-16") 
	       #.(qd-from-string "5.5511151231257827021181583404540958606019518033159549001888700768492q-17") 
	       #.(qd-from-string "2.7755575615628913510590791702270500685127439754144943625236087596052q-17") 
	       #.(qd-from-string "1.3877787807814456755295395851135253015328429969268117953154510949506q-17") 
	       #.(qd-from-string "6.9388939039072283776476979255676268417598037461585147441443138686883q-18") 
	       #.(qd-from-string "3.4694469519536141888238489627838134626418504682698143430180392335861q-18") 
	       #.(qd-from-string "1.7347234759768070944119244813919067365411688085337267928772549041983q-18") 
	       #.(qd-from-string "8.673617379884035472059622406959533689231148510667158491096568630248q-19") 
	       #.(qd-from-string "4.336808689942017736029811203479766845431237313833394811387071078781q-19") 
	       #.(qd-from-string "2.16840434497100886801490560173988342281757653922917435142338388484765q-19") 
	       #.(qd-from-string "1.08420217248550443400745280086994171142153300490364679392792298560597q-19") 

	       ))
  "Table of atan(2^(-k)) for k = 1 to 64.  But the first three entries are 1")

(defconstant +atan-table+
  (make-array 67
	      :initial-contents
	      (list
	       (%make-qd-d (scale-float (float 5970951936056572 1.0d0) -52)
			  (scale-float (float 5427585433121543 1.0d0) -105)
			  (scale-float (float 5608515294538868 1.0d0) -158)
			  (scale-float (float 445395631680583 1.0d0) -211))
	       (%make-qd-d (scale-float (float 4986154552901188 1.0d0) -52)
			  (scale-float (float 3814906810089799 1.0d0) -105)
			  (scale-float (float 1896417689773139 1.0d0) -158)
			  (scale-float (float 3393132800284032 1.0d0) -211))
	       (%make-qd-d (scale-float (float 7074237752028440 1.0d0) -53)
			  (scale-float (float 2483878800010755 1.0d0) -106)
			  (scale-float (float 3956492004828932 1.0d0) -159)
			  (scale-float (float 2434854662709436 1.0d0) -212))
	       (%make-qd-d (scale-float (float 8352332796509007 1.0d0) -54)
			  (scale-float (float 3683087214424816 1.0d0) -107)
			  (scale-float (float 8240297260223171 1.0d0) -160)
			  (scale-float (float 5174086704442609 1.0d0) -213))
	       (%make-qd-d (scale-float (float 8826286527774941 1.0d0) -55)
			  (scale-float (float 3471944699336670 1.0d0) -108)
			  (scale-float (float 4798212191802497 1.0d0) -161)
			  (scale-float (float 6908472993489831 1.0d0) -214))
	       (%make-qd-d (scale-float (float 8960721713639277 1.0d0) -56)
			  (scale-float (float 6978747913895162 1.0d0) -109)
			  (scale-float (float 1204496828771308 1.0d0) -162)
			  (scale-float (float 6150314016033077 1.0d0) -215))
	       (%make-qd-d (scale-float (float 8995498542038505 1.0d0) -57)
			  (scale-float (float 6996384121843768 1.0d0) -110)
			  (scale-float (float 6481245652257127 1.0d0) -163)
			  (scale-float (float 6083920726820778 1.0d0) -216))
	       (%make-qd-d (scale-float (float 9004268940523044 1.0d0) -58)
			  (scale-float (float 5921825575778154 1.0d0) -111)
			  (scale-float (float 1742767809528138 1.0d0) -164)
			  (scale-float (float 3392785816514584 1.0d0) -217))
	       (%make-qd-d (scale-float (float 9006466354344602 1.0d0) -59)
			  (scale-float (float 6455912199422039 1.0d0) -112)
			  (scale-float (float 7793493312778976 1.0d0) -165)
			  (scale-float (float 4748718880757240 1.0d0) -218))
	       (%make-qd-d (scale-float (float 9007016009513623 1.0d0) -60)
			  (scale-float (float 1583402193514233 1.0d0) -113)
			  (scale-float (float 4599960241393675 1.0d0) -166)
			  (scale-float (float 4964226307734805 1.0d0) -219))
	       (%make-qd-d (scale-float (float 9007153442175927 1.0d0) -61)
			  (scale-float (float 1458797116501429 1.0d0) -114)
			  (scale-float (float 2180379843517813 1.0d0) -167)
			  (scale-float (float 7244224576758923 1.0d0) -220))
	       (%make-qd-d (scale-float (float 9007187801521083 1.0d0) -62)
			  (scale-float (float 5961909987006481 1.0d0) -115)
			  (scale-float (float 1439161705865198 1.0d0) -168)
			  (scale-float (float 1250151122136839 1.0d0) -221))
	       (%make-qd-d (scale-float (float 9007196391431099 1.0d0) -63)
			  (scale-float (float 6595226783193595 1.0d0) -116)
			  (scale-float (float 7270788700276565 1.0d0) -169)
			  (scale-float (float 5212528258452836 1.0d0) -222))
	       (%make-qd-d (scale-float (float 9007198538913211 1.0d0) -64)
			  (scale-float (float 6605122380416172 1.0d0) -117)
			  (scale-float (float 2579496809882929 1.0d0) -170)
			  (scale-float (float 2545695100421145 1.0d0) -223))
	       (%make-qd-d (scale-float (float 9007199075784027 1.0d0) -65)
			  (scale-float (float 6605276999209814 1.0d0) -118)
			  (scale-float (float 8635423593413256 1.0d0) -171)
			  (scale-float (float 6747877897971029 1.0d0) -224))
	       (%make-qd-d (scale-float (float 9007199210001749 1.0d0) -66)
			  (scale-float (float 6605279415128805 1.0d0) -119)
			  (scale-float (float 5633073770825222 1.0d0) -172)
			  (scale-float (float 744251135568860 1.0d0) -225))
	       (%make-qd-d (scale-float (float 9007199243556181 1.0d0) -67)
			  (scale-float (float 3227579732349669 1.0d0) -120)
			  (scale-float (float 1645511649516378 1.0d0) -173)
			  (scale-float (float 7212311609477561 1.0d0) -226))
	       (%make-qd-d (scale-float (float 9007199251944789 1.0d0) -68)
			  (scale-float (float 3016473500406501 1.0d0) -121)
			  (scale-float (float 1629935234837168 1.0d0) -174)
			  (scale-float (float 1206159191623029 1.0d0) -227))
	       (%make-qd-d (scale-float (float 9007199254041941 1.0d0) -69)
			  (scale-float (float 3003279360882405 1.0d0) -122)
			  (scale-float (float 1629874389467187 1.0d0) -175)
			  (scale-float (float 8712158240272416 1.0d0) -228))
	       (%make-qd-d (scale-float (float 9007199254566229 1.0d0) -70)
			  (scale-float (float 3002454727161717 1.0d0) -123)
			  (scale-float (float 1629874151789961 1.0d0) -176)
			  (scale-float (float 3116377062563786 1.0d0) -229))
	       (%make-qd-d (scale-float (float 9007199254697301 1.0d0) -71)
			  (scale-float (float 3002403187554167 1.0d0) -124)
			  (scale-float (float 3881673964546782 1.0d0) -177)
			  (scale-float (float 6119176246102625 1.0d0) -230))
	       (%make-qd-d (scale-float (float 9007199254730069 1.0d0) -72)
			  (scale-float (float 3002399966328695 1.0d0) -125)
			  (scale-float (float 4198333313342644 1.0d0) -178)
			  (scale-float (float 114377133012236 1.0d0) -231))
	       (%make-qd-d (scale-float (float 9007199254738261 1.0d0) -73)
			  (scale-float (float 3002399765002103 1.0d0) -126)
			  (scale-float (float 4203281115667621 1.0d0) -179)
			  (scale-float (float 7620376512343991 1.0d0) -232))
	       (%make-qd-d (scale-float (float 9007199254740309 1.0d0) -74)
			  (scale-float (float 3002399752419191 1.0d0) -127)
			  (scale-float (float 4203358425078949 1.0d0) -180)
			  (scale-float (float 7121931241085909 1.0d0) -233))
	       (%make-qd-d (scale-float (float 9007199254740821 1.0d0) -75)
			  (scale-float (float 3002399751632759 1.0d0) -128)
			  (scale-float (float 4203359633038501 1.0d0) -181)
			  (scale-float (float 7119984189245056 1.0d0) -234))
	       (%make-qd-d (scale-float (float 9007199254740949 1.0d0) -76)
			  (scale-float (float 3002399751583607 1.0d0) -129)
			  (scale-float (float 4203359651912869 1.0d0) -182)
			  (scale-float (float 7119976583573803 1.0d0) -235))
	       (%make-qd-d (scale-float (float 9007199254740981 1.0d0) -77)
			  (scale-float (float 3002399751580535 1.0d0) -130)
			  (scale-float (float 4203359652207781 1.0d0) -183)
			  (scale-float (float 7119976553864150 1.0d0) -236))
	       (%make-qd-d (scale-float (float 9007199254740989 1.0d0) -78)
			  (scale-float (float 3002399751580343 1.0d0) -131)
			  (scale-float (float 4203359652212389 1.0d0) -184)
			  (scale-float (float 7119976553748096 1.0d0) -237))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -79)
			  (scale-float (float 3002399751580331 1.0d0) -132)
			  (scale-float (float 4203359652212461 1.0d0) -185)
			  (scale-float (float 7119976553747643 1.0d0) -238))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -80)
			  (scale-float (float 7505999378950826 1.0d0) -133)
			  (scale-float (float 6455159465897710 1.0d0) -186)
			  (scale-float (float 8245876460590265 1.0d0) -239))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -81)
			  (scale-float (float 8631899285793450 1.0d0) -134)
			  (scale-float (float 6032947000831726 1.0d0) -187)
			  (scale-float (float 8404206134990009 1.0d0) -240))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -82)
			  (scale-float (float 8913374262504106 1.0d0) -135)
			  (scale-float (float 6006558721765102 1.0d0) -188)
			  (scale-float (float 8406680036152505 1.0d0) -241))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -83)
			  (scale-float (float 8983743006681770 1.0d0) -136)
			  (scale-float (float 6004909454323438 1.0d0) -189)
			  (scale-float (float 8406718690858169 1.0d0) -242))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -84)
			  (scale-float (float 9001335192726186 1.0d0) -137)
			  (scale-float (float 6004806375108334 1.0d0) -190)
			  (scale-float (float 8406719294837945 1.0d0) -243))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -85)
			  (scale-float (float 9005733239237290 1.0d0) -138)
			  (scale-float (float 6004799932657390 1.0d0) -191)
			  (scale-float (float 8406719304275129 1.0d0) -244))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -86)
			  (scale-float (float 9006832750865066 1.0d0) -139)
			  (scale-float (float 6004799530004206 1.0d0) -192)
			  (scale-float (float 8406719304422585 1.0d0) -245))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -87)
			  (scale-float (float 9007107628772010 1.0d0) -140)
			  (scale-float (float 6004799504838382 1.0d0) -193)
			  (scale-float (float 8406719304424889 1.0d0) -246))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -88)
			  (scale-float (float 9007176348248746 1.0d0) -141)
			  (scale-float (float 6004799503265518 1.0d0) -194)
			  (scale-float (float 8406719304424925 1.0d0) -247))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -89)
			  (scale-float (float 9007193528117930 1.0d0) -142)
			  (scale-float (float 6004799503167214 1.0d0) -195)
			  (scale-float (float 8406719304424926 1.0d0) -248))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -90)
			  (scale-float (float 9007197823085226 1.0d0) -143)
			  (scale-float (float 6004799503161070 1.0d0) -196)
			  (scale-float (float 8406719304424926 1.0d0) -249))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -91)
			  (scale-float (float 9007198896827050 1.0d0) -144)
			  (scale-float (float 6004799503160686 1.0d0) -197)
			  (scale-float (float 8406719304424926 1.0d0) -250))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -92)
			  (scale-float (float 9007199165262506 1.0d0) -145)
			  (scale-float (float 6004799503160662 1.0d0) -198)
			  (scale-float (float 8406719304424926 1.0d0) -251))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -93)
			  (scale-float (float 9007199232371370 1.0d0) -146)
			  (scale-float (float 6004799503160661 1.0d0) -199)
			  (scale-float (float 3903119677054430 1.0d0) -252))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -94)
			  (scale-float (float 9007199249148586 1.0d0) -147)
			  (scale-float (float 6004799503160661 1.0d0) -200)
			  (scale-float (float 3058694746922462 1.0d0) -253))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -95)
			  (scale-float (float 9007199253342890 1.0d0) -148)
			  (scale-float (float 6004799503160661 1.0d0) -201)
			  (scale-float (float 3005918188789214 1.0d0) -254))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -96)
			  (scale-float (float 9007199254391466 1.0d0) -149)
			  (scale-float (float 6004799503160661 1.0d0) -202)
			  (scale-float (float 3002619653905886 1.0d0) -255))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -97)
			  (scale-float (float 9007199254653610 1.0d0) -150)
			  (scale-float (float 6004799503160661 1.0d0) -203)
			  (scale-float (float 3002413495475678 1.0d0) -256))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -98)
			  (scale-float (float 9007199254719146 1.0d0) -151)
			  (scale-float (float 6004799503160661 1.0d0) -204)
			  (scale-float (float 3002400610573790 1.0d0) -257))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -99)
			  (scale-float (float 9007199254735530 1.0d0) -152)
			  (scale-float (float 6004799503160661 1.0d0) -205)
			  (scale-float (float 3002399805267422 1.0d0) -258))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -100)
			  (scale-float (float 9007199254739626 1.0d0) -153)
			  (scale-float (float 6004799503160661 1.0d0) -206)
			  (scale-float (float 3002399754935774 1.0d0) -259))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -101)
			  (scale-float (float 9007199254740650 1.0d0) -154)
			  (scale-float (float 6004799503160661 1.0d0) -207)
			  (scale-float (float 3002399751790046 1.0d0) -260))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -102)
			  (scale-float (float 9007199254740906 1.0d0) -155)
			  (scale-float (float 6004799503160661 1.0d0) -208)
			  (scale-float (float 3002399751593438 1.0d0) -261))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -103)
			  (scale-float (float 9007199254740970 1.0d0) -156)
			  (scale-float (float 6004799503160661 1.0d0) -209)
			  (scale-float (float 3002399751581150 1.0d0) -262))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -104)
			  (scale-float (float 9007199254740986 1.0d0) -157)
			  (scale-float (float 6004799503160661 1.0d0) -210)
			  (scale-float (float 3002399751580382 1.0d0) -263))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -105)
			  (scale-float (float 9007199254740990 1.0d0) -158)
			  (scale-float (float 6004799503160661 1.0d0) -211)
			  (scale-float (float 3002399751580334 1.0d0) -264))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -106)
			  (scale-float (float 9007199254740991 1.0d0) -159)
			  (scale-float (float 6004799503160661 1.0d0) -212)
			  (scale-float (float 3002399751580331 1.0d0) -265))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -107)
			  (scale-float (float 9007199254740991 1.0d0) -160)
			  (scale-float (float 8256599316845909 1.0d0) -213)
			  (scale-float (float 3002399751580331 1.0d0) -266))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -108)
			  (scale-float (float 9007199254740991 1.0d0) -161)
			  (scale-float (float 8819549270267221 1.0d0) -214)
			  (scale-float (float 3002399751580331 1.0d0) -267))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -109)
			  (scale-float (float 9007199254740991 1.0d0) -162)
			  (scale-float (float 8960286758622549 1.0d0) -215)
			  (scale-float (float 3002399751580331 1.0d0) -268))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -110)
			  (scale-float (float 9007199254740991 1.0d0) -163)
			  (scale-float (float 8995471130711381 1.0d0) -216)
			  (scale-float (float 3002399751580331 1.0d0) -269))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -111)
			  (scale-float (float 9007199254740991 1.0d0) -164)
			  (scale-float (float 9004267223733589 1.0d0) -217)
			  (scale-float (float 3002399751580331 1.0d0) -270))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -112)
			  (scale-float (float 9007199254740991 1.0d0) -165)
			  (scale-float (float 9006466246989141 1.0d0) -218)
			  (scale-float (float 3002399751580331 1.0d0) -271))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -113)
			  (scale-float (float 9007199254740991 1.0d0) -166)
			  (scale-float (float 9007016002803029 1.0d0) -219)
			  (scale-float (float 3002399751580331 1.0d0) -272))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -114)
			  (scale-float (float 9007199254740991 1.0d0) -167)
			  (scale-float (float 9007153441756501 1.0d0) -220)
			  (scale-float (float 3002399751580331 1.0d0) -273))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -115)
			  (scale-float (float 9007199254740991 1.0d0) -168)
			  (scale-float (float 9007187801494869 1.0d0) -221)
			  (scale-float (float 3002399751580331 1.0d0) -274))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -116)
			  (scale-float (float 9007199254740991 1.0d0) -169)
			  (scale-float (float 9007196391429461 1.0d0) -222)
			  (scale-float (float 3002399751580331 1.0d0) -275))
	       (%make-qd-d (scale-float (float 9007199254740991 1.0d0) -117)
			  (scale-float (float 9007199254740991 1.0d0) -170)
			  (scale-float (float 9007198538913109 1.0d0) -223)
			  (scale-float (float 3002399751580331 1.0d0) -276))
	       ))
  "Table of atan(2^(-k)) for k = -2 to 64.  But the first three entries are 1")

(defconstant +atan-power-table+
  (make-array 67
	      :element-type 'double-float
	      :initial-contents
	       (loop for k from 0 below 67
		     collect (scale-float 1d0 (- 2 k)))
	       )
"Table of (2^(-k)) for k = -2 to 64.  But the first three entries are 1")

(defconstant +cordic-scale+
  #.(qd-from-string "0.065865828601599636584870082133151126045971796871364763285694473524426q0"))

(defun dump-qd (qd)
  (flet ((dump-d (d)
	   (multiple-value-bind (int exp sign)
	       (integer-decode-float d)
	     `(scale-float (float ,(* sign int) 1d0) ,exp))))
  (multiple-value-bind (q0 q1 q2 q3)
      (qd-parts qd)
    `(%make-qd-d ,(dump-d q0)
		 ,(dump-d q1)
		 ,(dump-d q2)
		 ,(dump-d q3)))))
