;;;; -*- Mode: lisp -*-
;;;;
;;;; Copyright (c) 2007 Raymond Toy
;;;;
;;;; Permission is hereby granted, free of charge, to any person
;;;; obtaining a copy of this software and associated documentation
;;;; files (the "Software"), to deal in the Software without
;;;; restriction, including without limitation the rights to use,
;;;; copy, modify, merge, publish, distribute, sublicense, and/or sell
;;;; copies of the Software, and to permit persons to whom the
;;;; Software is furnished to do so, subject to the following
;;;; conditions:
;;;;
;;;; The above copyright notice and this permission notice shall be
;;;; included in all copies or substantial portions of the Software.
;;;;
;;;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;;;; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
;;;; OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
;;;; NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
;;;; HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
;;;; WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
;;;; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;;;; OTHER DEALINGS IN THE SOFTWARE.

(in-package #:octi)

(defconstant +qd-zero+
  (make-qd-d 0d0))

(defconstant +qd-one+
  (make-qd-d 1d0))

;; The bits of 2/pi. Scale these bits by 2^(-1584) and you'll get
;; 2/pi.  These are used for accurate argument reduction for the trig
;; functions.
(defconstant +2/pi-bits+
  #xA2F9836E4E441529FC2757D1F534DDC0DB6295993C439041FE5163ABDEBBC561B7246E3A424DD2E006492EEA09D1921CFE1DEB1CB129A73EE88235F52EBB4484E99C7026B45F7E413991D639835339F49C845F8BBDF9283B1FF897FFDE05980FEF2F118B5A0A6D1F6D367ECF27CB09B74F463F669E5FEA2D7527BAC7EBE5F17B3D0739F78A5292EA6BFB5FB11F8D5D0856033046FC7B6BABF0CFBC209AF4361DA9E391615EE61B086599855F14A068408DFFD8804D73273106061556CA73A8C960E27BC08C6B)

;;   3.1415926535897932384626433832795028841971693993751058209749445923078L0
;; #q3.1415926535897932384626433832795028841971693993751058209749445923q0
(defconstant +qd-pi+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 7074237752028440 1.0d0) -51)
		(scale-float (float 4967757600021511 1.0d0) -105)
		(scale-float (float -8753721960665020 1.0d0) -161)
		(scale-float (float 5857755168774013 1.0d0) -215)
		(scale-float (float 5380502254059520 1.0d0) -269))
    (%make-qd-d q0 q1 q2 q3)))

;;   6.2831853071795864769252867665590057683943387987502116419498891846156328125724L0
;; #q6.2831853071795864769252867665590057683943387987502116419498891846q0
(defconstant +qd-2pi+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 7074237752028440 1.0d0) -50)
		(scale-float (float 4967757600021511 1.0d0) -104)
		(scale-float (float -8753721960665020 1.0d0) -160)
		(scale-float (float 5857755168774013 1.0d0) -214)
		(scale-float (float 5380502254059520 1.0d0) -268))
    (%make-qd-d q0 q1 q2 q3)))

;;   1.5707963267948966192313216916397514420985846996875529104874722961539082031431L0
;; #q1.57079632679489661923132169163975144209858469968755291048747229615q0
(defconstant +qd-pi/2+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 7074237752028440 1.0d0) -52)
		(scale-float (float 4967757600021511 1.0d0) -106)
		(scale-float (float -8753721960665020 1.0d0) -162)
		(scale-float (float 5857755168774013 1.0d0) -216)
		(scale-float (float 5380502254059520 1.0d0) -270))
    (%make-qd-d q0 q1 q2 q3)))

;;   0.78539816339744830961566084581987572104929234984377645524373614807695410157155L0
;; #q0.785398163397448309615660845819875721049292349843776455243736148076q0
(defconstant +qd-pi/4+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 7074237752028440 1.0d0) -53)
		(scale-float (float 4967757600021511 1.0d0) -107)
		(scale-float (float -8753721960665020 1.0d0) -163)
		(scale-float (float 5857755168774013 1.0d0) -217)
		(scale-float (float 5380502254059520 1.0d0) -271))
    (%make-qd-d q0 q1 q2 q3)))

;;   2.35619449019234492884698253745962716314787704953132936573120844423086230471467L0
;; #q2.35619449019234492884698253745962716314787704953132936573120844423q0
(defconstant +qd-3pi/4+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 5305678314021330 1.0d0) -51)
		(scale-float (float 7451636400032266 1.0d0) -106)
		(scale-float (float 5724553519491610 1.0d0) -160)
		(scale-float (float -6810541066450737 1.0d0) -214)
		(scale-float (float -7491566988951552 1.0d0) -273))
    (%make-qd-d q0 q1 q2 q3)))

;;   0.00306796157577128245943617517898388953534879824157725177829584432842560195926387L0
;; #q0.00306796157577128245943617517898388953534879824157725177829584432842q0
(defconstant +qd-pi/1024+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 7074237752028440 1.0d0) -61)
		(scale-float (float 4967757600021511 1.0d0) -115)
		(scale-float (float -8753721960665020 1.0d0) -171)
		(scale-float (float 5857755168774013 1.0d0) -225)
		(scale-float (float 5380502254059520 1.0d0) -279))
    (%make-qd-d q0 q1 q2 q3)))

;;   2.71828182845904523536028747135266249775724709369995957496696762772407663035355L0
;; #q2.71828182845904523536028747135266249775724709369995957496696762773q0
(defconstant +qd-e+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 6121026514868073 1.0d0) -51)
		(scale-float (float 5864240480059706 1.0d0) -105)
		(scale-float (float -6219324074349538 1.0d0) -161)
		(scale-float (float 7980724272743021 1.0d0) -215)
		(scale-float (float -8855251465666560 1.0d0) -269))
    (%make-qd-d q0 q1 q2 q3)))

;;   0.693147180559945309417232121458176568075500134360255254120680009493393621969696L0
;; #q0.693147180559945309417232121458176568075500134360255254120680009495q0
(defconstant +qd-log2+
  #+nil
  (make-qd-d 6.931471805599452862d-01
	     2.319046813846299558d-17
	     5.707708438416212066d-34
	     -3.582432210601811423d-50)
  (%make-qd-d (scale-float (float 6243314768165359 1.0d0) -53)
	      (scale-float (float 7525737178955839 1.0d0) -108)
	      (scale-float (float 6673460182522164 1.0d0) -163)
	      (scale-float (float -7545482916914641 1.0d0) -217)))

;; The rest of log(2) such that (+ +qd-log2+ +qd-log2-extra+) is
;; log(2) to twice the precision of a quad-double.
(defconstant +qd-log2-extra+
  (%make-qd-d (scale-float (float -5130503840205860 1.0d0) -271)
	      (scale-float (float 8312425932334613 1.0d0) -326)
	      (scale-float (float 7130537800999345 1.0d0) -380)
	      (scale-float (float 8345111905183492 1.0d0) -437)))

;; Log(10)
;;   2.30258509299404568401799145468436420760110148862877297603332790096757260967737L0
;; #q2.30258509299404568401799145468436420760110148862877297603332790095q0
(defconstant +qd-log10+
  (multiple-value-bind (q0 q1 q2 q3)
      (renorm-5 (scale-float (float 5184960683398422 1.0d0) -51)
		(scale-float (float -8805633374462953 1.0d0) -105)
		(scale-float (float -7296007962371596 1.0d0) -159)
		(scale-float (float -5296362421624049 1.0d0) -213)
		(scale-float (float 4574234754834432 1.0d0) -267))
    (%make-qd-d q0 q1 q2 q3)))

(defconstant +qd-eps+
  (scale-float 1d0 -209))

(defconstant +qd-sin-table+
  (make-array 256 :initial-contents
	      (list
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7074226654454970 1.0d0) -61)
			       (scale-float (float 5271335698347442 1.0d0) -115)
			       (scale-float (float 7913822574154586 1.0d0) -170)
			       (scale-float (float -4804352564403217 1.0d0) -224)
			       (scale-float (float 6064389487591424 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7074193361797233 1.0d0) -60)
			       (scale-float (float 7522205695703707 1.0d0) -116)
			       (scale-float (float 7787047147324868 1.0d0) -175)
			       (scale-float (float -6728650631839117 1.0d0) -232)
			       (scale-float (float 5184626653921280 1.0d0) -286))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5305603405682435 1.0d0) -59)
			       (scale-float (float -5041342953893321 1.0d0) -115)
			       (scale-float (float 8335474310793984 1.0d0) -170)
			       (scale-float (float 6743025479788607 1.0d0) -225)
			       (scale-float (float -6023389004300288 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7074060192106372 1.0d0) -59)
			       (scale-float (float 7185921569156509 1.0d0) -113)
			       (scale-float (float -6016799991653399 1.0d0) -170)
			       (scale-float (float -5577663458559350 1.0d0) -224)
			       (scale-float (float -7969393573560320 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8842450394781643 1.0d0) -59)
			       (scale-float (float -8771095658131507 1.0d0) -113)
			       (scale-float (float 8705573170983202 1.0d0) -167)
			       (scale-float (float -4692271881407162 1.0d0) -221)
			       (scale-float (float 8141919777882112 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5305378684473085 1.0d0) -58)
			       (scale-float (float 7704904742673764 1.0d0) -113)
			       (scale-float (float 7308626221243388 1.0d0) -167)
			       (scale-float (float 4905810005485122 1.0d0) -223)
			       (scale-float (float -5326632406941696 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6189482235310630 1.0d0) -58)
			       (scale-float (float -4715432182777116 1.0d0) -113)
			       (scale-float (float -8243063834437948 1.0d0) -168)
			       (scale-float (float 8566398131092182 1.0d0) -222)
			       (scale-float (float -6086611201163264 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7073527528384126 1.0d0) -58)
			       (scale-float (float -7632135562854704 1.0d0) -116)
			       (scale-float (float 7289253486557291 1.0d0) -170)
			       (scale-float (float -7590289326531904 1.0d0) -224)
			       (scale-float (float 7722148853710848 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7957506242722589 1.0d0) -58)
			       (scale-float (float -8272553670927212 1.0d0) -112)
			       (scale-float (float -6591995918745221 1.0d0) -166)
			       (scale-float (float -4636857096009409 1.0d0) -220)
			       (scale-float (float 7183488739295232 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8841410057981697 1.0d0) -58)
			       (scale-float (float -5627969559234247 1.0d0) -118)
			       (scale-float (float 6018105389463175 1.0d0) -172)
			       (scale-float (float 7544891264015395 1.0d0) -230)
			       (scale-float (float 6209179752595456 1.0d0) -284))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4862615327261055 1.0d0) -57)
			       (scale-float (float -5217239170857332 1.0d0) -111)
			       (scale-float (float -6336246586437174 1.0d0) -165)
			       (scale-float (float 5522987872330073 1.0d0) -219)
			       (scale-float (float -5649337847988224 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5304479856743885 1.0d0) -57)
			       (scale-float (float 6340842145528512 1.0d0) -113)
			       (scale-float (float -7566831660699656 1.0d0) -167)
			       (scale-float (float -7114412056121165 1.0d0) -221)
			       (scale-float (float -8974201406881792 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5746294458442105 1.0d0) -57)
			       (scale-float (float 4845186982751657 1.0d0) -113)
			       (scale-float (float 6382779118838290 1.0d0) -167)
			       (scale-float (float 8090523197847278 1.0d0) -221)
			       (scale-float (float 6384881576181760 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6188054973828419 1.0d0) -57)
			       (scale-float (float 7360584602593505 1.0d0) -111)
			       (scale-float (float 7946504576809704 1.0d0) -165)
			       (scale-float (float 5731224328660037 1.0d0) -219)
			       (scale-float (float 6575748996808704 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6629757244884614 1.0d0) -57)
			       (scale-float (float -5806448969106076 1.0d0) -112)
			       (scale-float (float 7037190739826080 1.0d0) -166)
			       (scale-float (float 5552037724818900 1.0d0) -223)
			       (scale-float (float 6596791471308800 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7071397114140692 1.0d0) -57)
			       (scale-float (float -7057477599664784 1.0d0) -113)
			       (scale-float (float -8290828586102809 1.0d0) -167)
			       (scale-float (float -6697971486035361 1.0d0) -222)
			       (scale-float (float -7883618700230656 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7512970424714007 1.0d0) -57)
			       (scale-float (float -6294023145184360 1.0d0) -111)
			       (scale-float (float -6395720725273163 1.0d0) -165)
			       (scale-float (float -7071774105018818 1.0d0) -219)
			       (scale-float (float -5298326162341888 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7954473020348387 1.0d0) -57)
			       (scale-float (float -6926679705961747 1.0d0) -112)
			       (scale-float (float -6427721451859560 1.0d0) -167)
			       (scale-float (float 8028310015339695 1.0d0) -222)
			       (scale-float (float 6198625664499712 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8395900745453257 1.0d0) -57)
			       (scale-float (float 4839201044457661 1.0d0) -114)
			       (scale-float (float 5799570435052711 1.0d0) -171)
			       (scale-float (float -5529353034270453 1.0d0) -226)
			       (scale-float (float 6823048531410944 1.0d0) -280))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8837249445142752 1.0d0) -57)
			       (scale-float (float -5314952832401406 1.0d0) -113)
			       (scale-float (float -7992910057771694 1.0d0) -167)
			       (scale-float (float 8886165424019995 1.0d0) -221)
			       (scale-float (float 8017893964447744 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4639257482637412 1.0d0) -56)
			       (scale-float (float -5494228531443205 1.0d0) -110)
			       (scale-float (float 6222043711193090 1.0d0) -167)
			       (scale-float (float 4966112393074763 1.0d0) -221)
			       (scale-float (float 6647651906093056 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4859846576245171 1.0d0) -56)
			       (scale-float (float -8985502920124077 1.0d0) -110)
			       (scale-float (float 7440463379940699 1.0d0) -165)
			       (scale-float (float -6641325637598524 1.0d0) -219)
			       (scale-float (float -5163628344082432 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5080389927126093 1.0d0) -56)
			       (scale-float (float -8898661047761268 1.0d0) -110)
			       (scale-float (float -4667727006484474 1.0d0) -164)
			       (scale-float (float 8478536563323652 1.0d0) -218)
			       (scale-float (float 8774483460931584 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5300885459442166 1.0d0) -56)
			       (scale-float (float -7213383224879916 1.0d0) -111)
			       (scale-float (float -8534269322822802 1.0d0) -166)
			       (scale-float (float -6601733372219099 1.0d0) -221)
			       (scale-float (float 8396826690453504 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5521331097805465 1.0d0) -56)
			       (scale-float (float 4829604598179156 1.0d0) -114)
			       (scale-float (float -7893599535446481 1.0d0) -172)
			       (scale-float (float -5384211130874634 1.0d0) -226)
			       (scale-float (float -5250039492378624 1.0d0) -282))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5741724767297686 1.0d0) -56)
			       (scale-float (float -5824155811343436 1.0d0) -110)
			       (scale-float (float 6673985610265747 1.0d0) -164)
			       (scale-float (float 4800782739249759 1.0d0) -220)
			       (scale-float (float 7109827096051712 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5962064393489674 1.0d0) -56)
			       (scale-float (float 7651360099479755 1.0d0) -112)
			       (scale-float (float 6974817744235260 1.0d0) -167)
			       (scale-float (float 7824970858345265 1.0d0) -224)
			       (scale-float (float -7627319001219072 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6182347902460953 1.0d0) -56)
			       (scale-float (float -8796242544913562 1.0d0) -111)
			       (scale-float (float -7546272905440146 1.0d0) -165)
			       (scale-float (float 6512061516709508 1.0d0) -219)
			       (scale-float (float 5909873078861824 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6402573220819241 1.0d0) -56)
			       (scale-float (float -4868008820827392 1.0d0) -110)
			       (scale-float (float 8779206749884591 1.0d0) -164)
			       (scale-float (float -8648470131210884 1.0d0) -218)
			       (scale-float (float -7064277529821184 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6622738275719969 1.0d0) -56)
			       (scale-float (float 6182934508221337 1.0d0) -110)
			       (scale-float (float 7353282250945404 1.0d0) -165)
			       (scale-float (float -8166192353391047 1.0d0) -220)
			       (scale-float (float -8567002520092672 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6842840994885793 1.0d0) -56)
			       (scale-float (float -8552477024466766 1.0d0) -110)
			       (scale-float (float -4997427595980002 1.0d0) -164)
			       (scale-float (float 5821398332046138 1.0d0) -218)
			       (scale-float (float 6922342312886272 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7062879306626092 1.0d0) -56)
			       (scale-float (float -8487236864497288 1.0d0) -112)
			       (scale-float (float -4942162982072151 1.0d0) -168)
			       (scale-float (float -4811145377091453 1.0d0) -223)
			       (scale-float (float -8730216008515584 1.0d0) -284))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7282851139856476 1.0d0) -56)
			       (scale-float (float 8609951212389606 1.0d0) -111)
			       (scale-float (float -5614142183842944 1.0d0) -165)
			       (scale-float (float 6068416796043208 1.0d0) -219)
			       (scale-float (float 8196791178133504 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7502754424118275 1.0d0) -56)
			       (scale-float (float 8536169017599928 1.0d0) -110)
			       (scale-float (float 7981550951145323 1.0d0) -165)
			       (scale-float (float -8340622458345952 1.0d0) -220)
			       (scale-float (float 6285858857648128 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7722587089598028 1.0d0) -56)
			       (scale-float (float 8362719068102409 1.0d0) -110)
			       (scale-float (float -7853008551658302 1.0d0) -166)
			       (scale-float (float -6852498985157079 1.0d0) -220)
			       (scale-float (float -4875056737550336 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7942347067146965 1.0d0) -56)
			       (scale-float (float -5897359216343841 1.0d0) -113)
			       (scale-float (float 7767443765766550 1.0d0) -169)
			       (scale-float (float 8203371449514667 1.0d0) -225)
			       (scale-float (float -8271467659657216 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8162032288300481 1.0d0) -56)
			       (scale-float (float 7035687121204020 1.0d0) -111)
			       (scale-float (float 5733124558862890 1.0d0) -168)
			       (scale-float (float 6681272325774503 1.0d0) -223)
			       (scale-float (float 8561939877724160 1.0d0) -281))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8381640685297609 1.0d0) -56)
			       (scale-float (float 5345425417737710 1.0d0) -112)
			       (scale-float (float -8790124191829010 1.0d0) -166)
			       (scale-float (float 7297964455931531 1.0d0) -225)
			       (scale-float (float 6532791441293312 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8601170191100479 1.0d0) -56)
			       (scale-float (float -5127404751534987 1.0d0) -110)
			       (scale-float (float 8258618371098839 1.0d0) -164)
			       (scale-float (float 6354475203379338 1.0d0) -221)
			       (scale-float (float 6679197895688192 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8820618739413774 1.0d0) -56)
			       (scale-float (float 7361249450583405 1.0d0) -111)
			       (scale-float (float 8489175872343797 1.0d0) -165)
			       (scale-float (float -4838736209868180 1.0d0) -220)
			       (scale-float (float -8316549956370432 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4519992132352091 1.0d0) -55)
			       (scale-float (float 6319901705801489 1.0d0) -110)
			       (scale-float (float 5600764727998866 1.0d0) -166)
			       (scale-float (float -5650573825026412 1.0d0) -220)
			       (scale-float (float 8973806114308096 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4629632351109917 1.0d0) -55)
			       (scale-float (float 4958462282897610 1.0d0) -110)
			       (scale-float (float -8711719640720475 1.0d0) -165)
			       (scale-float (float -8191834096705166 1.0d0) -221)
			       (scale-float (float -5689038166556672 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4739228994004870 1.0d0) -55)
			       (scale-float (float -6495525500297301 1.0d0) -110)
			       (scale-float (float -6071898187587615 1.0d0) -165)
			       (scale-float (float -7897922259441451 1.0d0) -220)
			       (scale-float (float 8718132485029888 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4848781029471607 1.0d0) -55)
			       (scale-float (float -5949746474335482 1.0d0) -109)
			       (scale-float (float 7443833788929433 1.0d0) -165)
			       (scale-float (float 6779921506403360 1.0d0) -220)
			       (scale-float (float -6235838319558656 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4958287426364647 1.0d0) -55)
			       (scale-float (float 8600164307618932 1.0d0) -110)
			       (scale-float (float -5552907197025195 1.0d0) -164)
			       (scale-float (float -6315628760329704 1.0d0) -222)
			       (scale-float (float 5886558061723648 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5067747153968079 1.0d0) -55)
			       (scale-float (float -5139980116898898 1.0d0) -109)
			       (scale-float (float 7128908501078503 1.0d0) -163)
			       (scale-float (float 5174334784143035 1.0d0) -217)
			       (scale-float (float -7994959068307456 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5177159182005257 1.0d0) -55)
			       (scale-float (float 7446222959753664 1.0d0) -109)
			       (scale-float (float -4853116546479197 1.0d0) -166)
			       (scale-float (float -7114171320789543 1.0d0) -220)
			       (scale-float (float -6689741129777152 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5286522480648506 1.0d0) -55)
			       (scale-float (float 4837853990883808 1.0d0) -110)
			       (scale-float (float 8734494569006220 1.0d0) -164)
			       (scale-float (float -6888573428631769 1.0d0) -220)
			       (scale-float (float 7536408677842944 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5395836020528807 1.0d0) -55)
			       (scale-float (float 5245006079192873 1.0d0) -109)
			       (scale-float (float 6070092190452118 1.0d0) -165)
			       (scale-float (float 8372804672547503 1.0d0) -219)
			       (scale-float (float 6966171302363136 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5505098772745492 1.0d0) -55)
			       (scale-float (float -4953034127800088 1.0d0) -109)
			       (scale-float (float 6748009167290918 1.0d0) -163)
			       (scale-float (float -7947104079128991 1.0d0) -217)
			       (scale-float (float -8524610016018432 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5614309708875923 1.0d0) -55)
			       (scale-float (float 7879649848150358 1.0d0) -111)
			       (scale-float (float -5133702133285397 1.0d0) -165)
			       (scale-float (float 6633380945160774 1.0d0) -219)
			       (scale-float (float 6441044708917248 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5723467800985178 1.0d0) -55)
			       (scale-float (float -5213481504208817 1.0d0) -110)
			       (scale-float (float -8683946243665639 1.0d0) -166)
			       (scale-float (float -4813600752545885 1.0d0) -220)
			       (scale-float (float 5425715381862400 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5832572021635720 1.0d0) -55)
			       (scale-float (float 7691426989666512 1.0d0) -109)
			       (scale-float (float -5897567218587937 1.0d0) -163)
			       (scale-float (float 6426162084210735 1.0d0) -217)
			       (scale-float (float -6540530815762432 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5941621343897074 1.0d0) -55)
			       (scale-float (float -7311303147276965 1.0d0) -113)
			       (scale-float (float 6212875260931578 1.0d0) -167)
			       (scale-float (float 5841094814764128 1.0d0) -222)
			       (scale-float (float 8143620349362176 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6050614741355486 1.0d0) -55)
			       (scale-float (float 7046535347736856 1.0d0) -110)
			       (scale-float (float -7778307984467600 1.0d0) -164)
			       (scale-float (float -7808429293088315 1.0d0) -218)
			       (scale-float (float 4835521567211520 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6159551188123590 1.0d0) -55)
			       (scale-float (float 5965947804179142 1.0d0) -109)
			       (scale-float (float -7914176807889465 1.0d0) -163)
			       (scale-float (float -8743204545259556 1.0d0) -219)
			       (scale-float (float 5663160515559424 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6268429658850061 1.0d0) -55)
			       (scale-float (float 7548560474328400 1.0d0) -110)
			       (scale-float (float -7834123143654772 1.0d0) -165)
			       (scale-float (float -5643244224302487 1.0d0) -219)
			       (scale-float (float 8164719771910144 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6377249128729266 1.0d0) -55)
			       (scale-float (float 8739842904414420 1.0d0) -110)
			       (scale-float (float 6557520883328920 1.0d0) -164)
			       (scale-float (float 6198578405040918 1.0d0) -220)
			       (scale-float (float 8421926009438208 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6486008573510911 1.0d0) -55)
			       (scale-float (float 5172944262567044 1.0d0) -109)
			       (scale-float (float -8273960648700810 1.0d0) -163)
			       (scale-float (float 8265967084369073 1.0d0) -218)
			       (scale-float (float 7699060397178880 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6594706969509681 1.0d0) -55)
			       (scale-float (float 5020296747686703 1.0d0) -109)
			       (scale-float (float -5238462653363294 1.0d0) -163)
			       (scale-float (float 4718474594983838 1.0d0) -218)
			       (scale-float (float -6926646404186112 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6703343293614876 1.0d0) -55)
			       (scale-float (float -8155081811450095 1.0d0) -109)
			       (scale-float (float 8880533418464333 1.0d0) -163)
			       (scale-float (float -6482467806029927 1.0d0) -220)
			       (scale-float (float 8908780907528192 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6811916523300038 1.0d0) -55)
			       (scale-float (float -4946244022635960 1.0d0) -109)
			       (scale-float (float -5237121426122221 1.0d0) -163)
			       (scale-float (float 8718098324302620 1.0d0) -217)
			       (scale-float (float -5334437152194560 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6920425636632580 1.0d0) -55)
			       (scale-float (float 5626936751711242 1.0d0) -110)
			       (scale-float (float -5472825984215756 1.0d0) -164)
			       (scale-float (float 6651512109810514 1.0d0) -218)
			       (scale-float (float -5422089080733696 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7028869612283403 1.0d0) -55)
			       (scale-float (float -5186506842934658 1.0d0) -109)
			       (scale-float (float 7231073992256617 1.0d0) -163)
			       (scale-float (float -7548842128799985 1.0d0) -217)
			       (scale-float (float -6885880199282688 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7137247429536506 1.0d0) -55)
			       (scale-float (float -4785846924082858 1.0d0) -111)
			       (scale-float (float 6612549575000546 1.0d0) -165)
			       (scale-float (float 8882300801909735 1.0d0) -219)
			       (scale-float (float 7661200690282496 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7245558068298598 1.0d0) -55)
			       (scale-float (float 7145919755147006 1.0d0) -109)
			       (scale-float (float -4574333719136121 1.0d0) -163)
			       (scale-float (float 8116579236098782 1.0d0) -221)
			       (scale-float (float 6201037847003136 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7353800509108698 1.0d0) -55)
			       (scale-float (float 7910632724668908 1.0d0) -110)
			       (scale-float (float -6611929274882350 1.0d0) -164)
			       (scale-float (float 7768004576091902 1.0d0) -220)
			       (scale-float (float -7107771239563264 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7461973733147729 1.0d0) -55)
			       (scale-float (float -6888466114708653 1.0d0) -109)
			       (scale-float (float 5251305190626995 1.0d0) -164)
			       (scale-float (float 5680012606429775 1.0d0) -218)
			       (scale-float (float 6897724502097920 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7570076722248107 1.0d0) -55)
			       (scale-float (float 7503873979299470 1.0d0) -109)
			       (scale-float (float 7056820389775269 1.0d0) -163)
			       (scale-float (float 7020098326040376 1.0d0) -217)
			       (scale-float (float -8422007318265856 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7678108458903330 1.0d0) -55)
			       (scale-float (float 7809132580424664 1.0d0) -109)
			       (scale-float (float -7983937846917205 1.0d0) -164)
			       (scale-float (float -5238765332718576 1.0d0) -218)
			       (scale-float (float -8059861090435072 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7786067926277549 1.0d0) -55)
			       (scale-float (float -6562541456970122 1.0d0) -109)
			       (scale-float (float 8510563175036132 1.0d0) -163)
			       (scale-float (float -6181313461401740 1.0d0) -217)
			       (scale-float (float 4510744032436224 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7893954108215139 1.0d0) -55)
			       (scale-float (float -7583622115760437 1.0d0) -114)
			       (scale-float (float -8739826341766039 1.0d0) -168)
			       (scale-float (float 8569299442299246 1.0d0) -224)
			       (scale-float (float 7953143845355520 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8001765989250269 1.0d0) -55)
			       (scale-float (float -7875990267513186 1.0d0) -111)
			       (scale-float (float 6234618013881755 1.0d0) -166)
			       (scale-float (float 6777347195615505 1.0d0) -221)
			       (scale-float (float 7479102375460864 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8109502554616454 1.0d0) -55)
			       (scale-float (float 5128307098824184 1.0d0) -110)
			       (scale-float (float 4543608696005937 1.0d0) -167)
			       (scale-float (float 7638129994812919 1.0d0) -223)
			       (scale-float (float 7328067514007552 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8217162790256110 1.0d0) -55)
			       (scale-float (float 5345588865997323 1.0d0) -109)
			       (scale-float (float 8159479612637540 1.0d0) -163)
			       (scale-float (float -5402348902098945 1.0d0) -219)
			       (scale-float (float -6129953259257856 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8324745682830097 1.0d0) -55)
			       (scale-float (float 6574607749416877 1.0d0) -109)
			       (scale-float (float -8109490796402671 1.0d0) -163)
			       (scale-float (float -6082280992156331 1.0d0) -217)
			       (scale-float (float 6059016873918464 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8432250219727258 1.0d0) -55)
			       (scale-float (float -4538223398252166 1.0d0) -109)
			       (scale-float (float -6702216400949692 1.0d0) -163)
			       (scale-float (float 8946082027051995 1.0d0) -220)
			       (scale-float (float -8078529194885120 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8539675389073947 1.0d0) -55)
			       (scale-float (float 5746889479488039 1.0d0) -109)
			       (scale-float (float 6355067832497967 1.0d0) -165)
			       (scale-float (float 8745994171732987 1.0d0) -219)
			       (scale-float (float -7260136702705664 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8647020179743560 1.0d0) -55)
			       (scale-float (float -7877855974853474 1.0d0) -109)
			       (scale-float (float -6184796128853677 1.0d0) -164)
			       (scale-float (float -6716307004457317 1.0d0) -221)
			       (scale-float (float -4679972601069568 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8754283581366043 1.0d0) -55)
			       (scale-float (float -5680003804930756 1.0d0) -109)
			       (scale-float (float -7684372211678467 1.0d0) -163)
			       (scale-float (float -8705668463298701 1.0d0) -219)
			       (scale-float (float -4658178006188032 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8861464584337410 1.0d0) -55)
			       (scale-float (float -7223162559193390 1.0d0) -109)
			       (scale-float (float 5121803047874294 1.0d0) -163)
			       (scale-float (float 5147411879671042 1.0d0) -218)
			       (scale-float (float 4588877908574208 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8968562179829241 1.0d0) -55)
			       (scale-float (float -5308048479279035 1.0d0) -109)
			       (scale-float (float 6508578347136807 1.0d0) -163)
			       (scale-float (float 8020683771279042 1.0d0) -217)
			       (scale-float (float -8358038240133120 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4537787679899090 1.0d0) -54)
			       (scale-float (float -5708747378047162 1.0d0) -108)
			       (scale-float (float -6407036826384189 1.0d0) -162)
			       (scale-float (float 5919543467564908 1.0d0) -216)
			       (scale-float (float -8121882668752896 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4591251558497710 1.0d0) -54)
			       (scale-float (float -5650174284497868 1.0d0) -115)
			       (scale-float (float -8990517484150757 1.0d0) -170)
			       (scale-float (float -8107597715031434 1.0d0) -224)
			       (scale-float (float -5959355159543808 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4644672222488094 1.0d0) -54)
			       (scale-float (float 5997115408045016 1.0d0) -108)
			       (scale-float (float 7763885974670757 1.0d0) -164)
			       (scale-float (float -4679894517345222 1.0d0) -219)
			       (scale-float (float 5603403843633152 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4698049169054608 1.0d0) -54)
			       (scale-float (float 5545557499125773 1.0d0) -110)
			       (scale-float (float 5311178975123782 1.0d0) -166)
			       (scale-float (float 5295664491197940 1.0d0) -220)
			       (scale-float (float 5581004062720000 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4751381895793102 1.0d0) -54)
			       (scale-float (float -6113263535019274 1.0d0) -108)
			       (scale-float (float 8020796425904764 1.0d0) -162)
			       (scale-float (float -8716004022289625 1.0d0) -216)
			       (scale-float (float 7649880035377152 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4804669900715639 1.0d0) -54)
			       (scale-float (float 6795815263120026 1.0d0) -108)
			       (scale-float (float -6608013933362003 1.0d0) -162)
			       (scale-float (float 8405700252907754 1.0d0) -218)
			       (scale-float (float -8728274539773952 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4857912682255224 1.0d0) -54)
			       (scale-float (float 5116248407710562 1.0d0) -108)
			       (scale-float (float -8148882072162222 1.0d0) -163)
			       (scale-float (float -8520890580178720 1.0d0) -217)
			       (scale-float (float -5398325126758400 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4911109739270519 1.0d0) -54)
			       (scale-float (float 5107738102425278 1.0d0) -109)
			       (scale-float (float 6190162227247694 1.0d0) -166)
			       (scale-float (float -4657820058623469 1.0d0) -220)
			       (scale-float (float 5044535082876928 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4964260571050563 1.0d0) -54)
			       (scale-float (float 6269805211133874 1.0d0) -108)
			       (scale-float (float 8144711382265961 1.0d0) -162)
			       (scale-float (float 5736256866199006 1.0d0) -218)
			       (scale-float (float -6525423926870016 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5017364677319486 1.0d0) -54)
			       (scale-float (float -6510019840528798 1.0d0) -109)
			       (scale-float (float 8487479632464686 1.0d0) -163)
			       (scale-float (float -8482708199224338 1.0d0) -219)
			       (scale-float (float -6883346636800000 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5070421558241214 1.0d0) -54)
			       (scale-float (float -7997629714663984 1.0d0) -109)
			       (scale-float (float -4940945917580418 1.0d0) -165)
			       (scale-float (float 6330315470378748 1.0d0) -219)
			       (scale-float (float 5443507329499136 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5123430714424177 1.0d0) -54)
			       (scale-float (float 7207319694891503 1.0d0) -108)
			       (scale-float (float -5367984184293639 1.0d0) -162)
			       (scale-float (float -5496551307550694 1.0d0) -216)
			       (scale-float (float -7850046943559680 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5176391646926010 1.0d0) -54)
			       (scale-float (float 5017419446091570 1.0d0) -108)
			       (scale-float (float -7396832087454611 1.0d0) -163)
			       (scale-float (float -4840687577999527 1.0d0) -217)
			       (scale-float (float -5841829911068672 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5229303857258246 1.0d0) -54)
			       (scale-float (float -6142480273924397 1.0d0) -108)
			       (scale-float (float 6736325962420316 1.0d0) -162)
			       (scale-float (float 7870899103225375 1.0d0) -216)
			       (scale-float (float -6481337268527104 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5282166847391008 1.0d0) -54)
			       (scale-float (float 7264487630099164 1.0d0) -108)
			       (scale-float (float 7987097472370426 1.0d0) -162)
			       (scale-float (float -8941292693731426 1.0d0) -217)
			       (scale-float (float -5269253683658752 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5334980119757703 1.0d0) -54)
			       (scale-float (float -6562004117740143 1.0d0) -108)
			       (scale-float (float -7412943256346969 1.0d0) -166)
			       (scale-float (float -4884902683994743 1.0d0) -220)
			       (scale-float (float 6498418964824064 1.0d0) -282))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5387743177259695 1.0d0) -54)
			       (scale-float (float 8671749280336977 1.0d0) -112)
			       (scale-float (float 8052630932330237 1.0d0) -166)
			       (scale-float (float 5382726735559265 1.0d0) -223)
			       (scale-float (float 8322033028956160 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5440455523270994 1.0d0) -54)
			       (scale-float (float -5571226216357986 1.0d0) -108)
			       (scale-float (float 5456938947172397 1.0d0) -164)
			       (scale-float (float 6994870598847095 1.0d0) -219)
			       (scale-float (float -5157268310982656 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5493116661642923 1.0d0) -54)
			       (scale-float (float -7460368030645572 1.0d0) -108)
			       (scale-float (float -6827621715323733 1.0d0) -165)
			       (scale-float (float 6362629589576016 1.0d0) -220)
			       (scale-float (float -5304207807086592 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5545726096708791 1.0d0) -54)
			       (scale-float (float 8786044050481812 1.0d0) -108)
			       (scale-float (float 7347762739505304 1.0d0) -162)
			       (scale-float (float 7680616584349999 1.0d0) -216)
			       (scale-float (float -8241241114238976 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5598283333288561 1.0d0) -54)
			       (scale-float (float 6778243811814134 1.0d0) -108)
			       (scale-float (float -7045745243982448 1.0d0) -164)
			       (scale-float (float 4676451795272765 1.0d0) -221)
			       (scale-float (float 8570209083850752 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5650787876693505 1.0d0) -54)
			       (scale-float (float 4725135298405656 1.0d0) -108)
			       (scale-float (float 8550179043058735 1.0d0) -164)
			       (scale-float (float 4909349307819338 1.0d0) -218)
			       (scale-float (float 6696986363297792 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5703239232730864 1.0d0) -54)
			       (scale-float (float 6956150123475237 1.0d0) -108)
			       (scale-float (float 7212901813329486 1.0d0) -162)
			       (scale-float (float 7153556903673412 1.0d0) -217)
			       (scale-float (float -7350582136963072 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5755636907708500 1.0d0) -54)
			       (scale-float (float -4537276437495587 1.0d0) -108)
			       (scale-float (float 4777941193532901 1.0d0) -162)
			       (scale-float (float -8179721144625040 1.0d0) -216)
			       (scale-float (float 7659081222668288 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5807980408439539 1.0d0) -54)
			       (scale-float (float -5259672094517845 1.0d0) -110)
			       (scale-float (float 8754582529967018 1.0d0) -164)
			       (scale-float (float 7408654934690508 1.0d0) -219)
			       (scale-float (float -5191954652200960 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5860269242247018 1.0d0) -54)
			       (scale-float (float 5138507873462360 1.0d0) -109)
			       (scale-float (float -6320854003064805 1.0d0) -166)
			       (scale-float (float 7758282409924483 1.0d0) -221)
			       (scale-float (float -7239829310668800 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5912502916968520 1.0d0) -54)
			       (scale-float (float -8662419418939044 1.0d0) -108)
			       (scale-float (float 4614185824928788 1.0d0) -162)
			       (scale-float (float 8601963191388429 1.0d0) -221)
			       (scale-float (float -7236690074664960 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5964680940960804 1.0d0) -54)
			       (scale-float (float -8914351205645270 1.0d0) -108)
			       (scale-float (float -7834377139759957 1.0d0) -162)
			       (scale-float (float 6901300084898985 1.0d0) -216)
			       (scale-float (float 7894019060555776 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6016802823104436 1.0d0) -54)
			       (scale-float (float 7333790512522496 1.0d0) -108)
			       (scale-float (float 4563571436080821 1.0d0) -162)
			       (scale-float (float 8605109854377494 1.0d0) -218)
			       (scale-float (float -7597538248097792 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6068868072808413 1.0d0) -54)
			       (scale-float (float -8723253959652896 1.0d0) -114)
			       (scale-float (float -8733624133784357 1.0d0) -171)
			       (scale-float (float -6253293004427605 1.0d0) -225)
			       (scale-float (float 7903885175816192 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6120876200014774 1.0d0) -54)
			       (scale-float (float 8571012628450813 1.0d0) -110)
			       (scale-float (float 5881087260125824 1.0d0) -165)
			       (scale-float (float 8616758768675350 1.0d0) -221)
			       (scale-float (float -6485427212255232 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6172826715203219 1.0d0) -54)
			       (scale-float (float 6250720108433989 1.0d0) -108)
			       (scale-float (float -5422415971662036 1.0d0) -162)
			       (scale-float (float 8997881851302993 1.0d0) -216)
			       (scale-float (float 5663871216648192 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6224719129395714 1.0d0) -54)
			       (scale-float (float 8843501730272727 1.0d0) -108)
			       (scale-float (float 8200563275489647 1.0d0) -163)
			       (scale-float (float -5971751274707875 1.0d0) -218)
			       (scale-float (float 7152787190022144 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6276552954161094 1.0d0) -54)
			       (scale-float (float 4799554187051297 1.0d0) -110)
			       (scale-float (float 8308846534529580 1.0d0) -164)
			       (scale-float (float 8241934792467017 1.0d0) -218)
			       (scale-float (float 6142252833701888 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6328327701619659 1.0d0) -54)
			       (scale-float (float -7357066700707823 1.0d0) -108)
			       (scale-float (float -7947864157743905 1.0d0) -165)
			       (scale-float (float 7675632966777644 1.0d0) -219)
			       (scale-float (float -7859656524824576 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6380042884447767 1.0d0) -54)
			       (scale-float (float -5501161709946803 1.0d0) -108)
			       (scale-float (float 7466713522323834 1.0d0) -162)
			       (scale-float (float -7098845764308001 1.0d0) -217)
			       (scale-float (float 6821858551332864 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6431698015882422 1.0d0) -54)
			       (scale-float (float -5007263247392991 1.0d0) -113)
			       (scale-float (float -7795754867074493 1.0d0) -167)
			       (scale-float (float -4821191128464752 1.0d0) -222)
			       (scale-float (float 7539590174343168 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6483292609725855 1.0d0) -54)
			       (scale-float (float -5712074047376477 1.0d0) -108)
			       (scale-float (float 7819107111345661 1.0d0) -162)
			       (scale-float (float 8368937774054671 1.0d0) -216)
			       (scale-float (float -6753988863688704 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6534826180350098 1.0d0) -54)
			       (scale-float (float -5949616244538138 1.0d0) -109)
			       (scale-float (float -8689252050077247 1.0d0) -163)
			       (scale-float (float -8509057300264997 1.0d0) -218)
			       (scale-float (float -8943610587250688 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6586298242701558 1.0d0) -54)
			       (scale-float (float 5263009052367660 1.0d0) -108)
			       (scale-float (float 6598370143038445 1.0d0) -162)
			       (scale-float (float -7564085607225777 1.0d0) -216)
			       (scale-float (float 4742479682797568 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6637708312305582 1.0d0) -54)
			       (scale-float (float 6791291154341829 1.0d0) -109)
			       (scale-float (float 7690532825767619 1.0d0) -168)
			       (scale-float (float 7037800597631649 1.0d0) -222)
			       (scale-float (float 8060966153486336 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6689055905271015 1.0d0) -54)
			       (scale-float (float 7217134714480857 1.0d0) -114)
			       (scale-float (float -8997551068716333 1.0d0) -173)
			       (scale-float (float -6072128060810686 1.0d0) -227)
			       (scale-float (float 6009466801618944 1.0d0) -281))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6740340538294756 1.0d0) -54)
			       (scale-float (float 5199702616094614 1.0d0) -109)
			       (scale-float (float 6246995808738228 1.0d0) -163)
			       (scale-float (float 8721019383942846 1.0d0) -219)
			       (scale-float (float 7653531236958208 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6791561728666308 1.0d0) -54)
			       (scale-float (float -7075880958543542 1.0d0) -111)
			       (scale-float (float 5953253779194679 1.0d0) -166)
			       (scale-float (float 5597468420642533 1.0d0) -222)
			       (scale-float (float -7151042605088768 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6842718994272319 1.0d0) -54)
			       (scale-float (float 6435287673892967 1.0d0) -109)
			       (scale-float (float 5701190408884571 1.0d0) -163)
			       (scale-float (float 5908054947863245 1.0d0) -218)
			       (scale-float (float 4556920054480896 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6893811853601123 1.0d0) -54)
			       (scale-float (float -6523324437210640 1.0d0) -109)
			       (scale-float (float -4818352562283701 1.0d0) -164)
			       (scale-float (float -5357330931060650 1.0d0) -218)
			       (scale-float (float 4611839504777216 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6944839825747268 1.0d0) -54)
			       (scale-float (float 4925434022374747 1.0d0) -108)
			       (scale-float (float 8300294859713104 1.0d0) -162)
			       (scale-float (float 6208703759312379 1.0d0) -216)
			       (scale-float (float -5013140189642752 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6995802430416048 1.0d0) -54)
			       (scale-float (float -6525270186811934 1.0d0) -109)
			       (scale-float (float 8879265420406843 1.0d0) -163)
			       (scale-float (float -6733241213708231 1.0d0) -217)
			       (scale-float (float -6737959053164544 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7046699187928017 1.0d0) -54)
			       (scale-float (float 5840616084808535 1.0d0) -108)
			       (scale-float (float -6204648763678812 1.0d0) -162)
			       (scale-float (float -5748171176195803 1.0d0) -216)
			       (scale-float (float -7375070776360960 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7097529619223511 1.0d0) -54)
			       (scale-float (float 6337798132651441 1.0d0) -109)
			       (scale-float (float -4965270455978562 1.0d0) -164)
			       (scale-float (float -4678379495118649 1.0d0) -219)
			       (scale-float (float 5929984816447488 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7148293245867151 1.0d0) -54)
			       (scale-float (float 6667254347281325 1.0d0) -108)
			       (scale-float (float 7172706150755633 1.0d0) -163)
			       (scale-float (float 4521599313713307 1.0d0) -218)
			       (scale-float (float 6319153054941184 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7198989590052351 1.0d0) -54)
			       (scale-float (float -4889033451117653 1.0d0) -108)
			       (scale-float (float -5825736040848376 1.0d0) -162)
			       (scale-float (float -6058018356871033 1.0d0) -216)
			       (scale-float (float 4719922365956096 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7249618174605810 1.0d0) -54)
			       (scale-float (float 7076204518174404 1.0d0) -109)
			       (scale-float (float 8651917601296873 1.0d0) -163)
			       (scale-float (float 4790821447612866 1.0d0) -217)
			       (scale-float (float 6079401430253568 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7300178522992010 1.0d0) -54)
			       (scale-float (float 6432697761913771 1.0d0) -109)
			       (scale-float (float -5885542131804050 1.0d0) -164)
			       (scale-float (float 5002309445714852 1.0d0) -225)
			       (scale-float (float 8157883497709568 1.0d0) -280))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7350670159317696 1.0d0) -54)
			       (scale-float (float -4543650155952635 1.0d0) -109)
			       (scale-float (float -6598133798027798 1.0d0) -165)
			       (scale-float (float 8182638753990352 1.0d0) -225)
			       (scale-float (float -8334158438858752 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7401092608336357 1.0d0) -54)
			       (scale-float (float -7859785885819633 1.0d0) -108)
			       (scale-float (float -6675498128747218 1.0d0) -162)
			       (scale-float (float -8844902686085099 1.0d0) -218)
			       (scale-float (float -5439421702995968 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7451445395452699 1.0d0) -54)
			       (scale-float (float -6746081919340579 1.0d0) -109)
			       (scale-float (float -5369758667471624 1.0d0) -165)
			       (scale-float (float -6834701290217458 1.0d0) -221)
			       (scale-float (float -8025543898300416 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7501728046727114 1.0d0) -54)
			       (scale-float (float -8267298509278455 1.0d0) -108)
			       (scale-float (float -8063438575398244 1.0d0) -164)
			       (scale-float (float 6048179215733349 1.0d0) -219)
			       (scale-float (float 7101057283194880 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7551940088880137 1.0d0) -54)
			       (scale-float (float -5482087221447130 1.0d0) -110)
			       (scale-float (float -8430648353819219 1.0d0) -164)
			       (scale-float (float 8658592177651743 1.0d0) -218)
			       (scale-float (float 7093572807426048 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7602081049296905 1.0d0) -54)
			       (scale-float (float 5652239210598920 1.0d0) -110)
			       (scale-float (float 7420759427593921 1.0d0) -164)
			       (scale-float (float -5717719400948822 1.0d0) -218)
			       (scale-float (float 7916673537998848 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7652150456031602 1.0d0) -54)
			       (scale-float (float 8912029836648224 1.0d0) -108)
			       (scale-float (float -5442965062816235 1.0d0) -163)
			       (scale-float (float 5557269064076599 1.0d0) -219)
			       (scale-float (float -8143037067689984 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7702147837811904 1.0d0) -54)
			       (scale-float (float 6108211414778243 1.0d0) -109)
			       (scale-float (float -8159473578389260 1.0d0) -165)
			       (scale-float (float -7432349312262155 1.0d0) -221)
			       (scale-float (float -6255586292269056 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7752072724043411 1.0d0) -54)
			       (scale-float (float 7223681421721881 1.0d0) -108)
			       (scale-float (float 5025963318844636 1.0d0) -162)
			       (scale-float (float -6196764359275049 1.0d0) -217)
			       (scale-float (float 6675143307739136 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7801924644814081 1.0d0) -54)
			       (scale-float (float 7284976384109012 1.0d0) -109)
			       (scale-float (float 4978342074042849 1.0d0) -166)
			       (scale-float (float -8927853027064514 1.0d0) -220)
			       (scale-float (float 8209556624113664 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7851703130898649 1.0d0) -54)
			       (scale-float (float 5267103399173910 1.0d0) -108)
			       (scale-float (float -6021054605042187 1.0d0) -166)
			       (scale-float (float 6370660996304786 1.0d0) -220)
			       (scale-float (float -6401332536410112 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7901407713763047 1.0d0) -54)
			       (scale-float (float -6777023449092614 1.0d0) -108)
			       (scale-float (float -6668929501654487 1.0d0) -165)
			       (scale-float (float 8608953101571494 1.0d0) -223)
			       (scale-float (float 8586013985210368 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7951037925568809 1.0d0) -54)
			       (scale-float (float 7256489245666525 1.0d0) -108)
			       (scale-float (float 5548921664669512 1.0d0) -165)
			       (scale-float (float -6417647354800337 1.0d0) -220)
			       (scale-float (float -5655827515965440 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8000593299177483 1.0d0) -54)
			       (scale-float (float -7859474098720372 1.0d0) -108)
			       (scale-float (float 5192476996492227 1.0d0) -164)
			       (scale-float (float 7762192920165123 1.0d0) -219)
			       (scale-float (float 5315557988761600 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8050073368155017 1.0d0) -54)
			       (scale-float (float -6237939819127611 1.0d0) -108)
			       (scale-float (float -8310809855799018 1.0d0) -167)
			       (scale-float (float -4607997215797586 1.0d0) -221)
			       (scale-float (float -8992526383972352 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8099477666776158 1.0d0) -54)
			       (scale-float (float 6338746169655183 1.0d0) -110)
			       (scale-float (float 6349016711906624 1.0d0) -164)
			       (scale-float (float -6594231578666108 1.0d0) -218)
			       (scale-float (float -7469627433549824 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8148805730028833 1.0d0) -54)
			       (scale-float (float -4811953802956820 1.0d0) -108)
			       (scale-float (float -8996711906404359 1.0d0) -163)
			       (scale-float (float 7437936247641814 1.0d0) -218)
			       (scale-float (float 7267646205329408 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8198057093618523 1.0d0) -54)
			       (scale-float (float -8035018871140280 1.0d0) -109)
			       (scale-float (float 6464477674883353 1.0d0) -163)
			       (scale-float (float -7193445626531301 1.0d0) -219)
			       (scale-float (float 6613589106622464 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8247231293972637 1.0d0) -54)
			       (scale-float (float -5487884902609878 1.0d0) -109)
			       (scale-float (float -7456042848390653 1.0d0) -163)
			       (scale-float (float 6693281418534385 1.0d0) -217)
			       (scale-float (float 6220894588780544 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8296327868244873 1.0d0) -54)
			       (scale-float (float 5999951330674037 1.0d0) -108)
			       (scale-float (float -6154519112303483 1.0d0) -162)
			       (scale-float (float 7000233030992444 1.0d0) -217)
			       (scale-float (float 5649438551359488 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8345346354319577 1.0d0) -54)
			       (scale-float (float -4771391396366549 1.0d0) -109)
			       (scale-float (float 7854156202477445 1.0d0) -163)
			       (scale-float (float 8339496630900022 1.0d0) -217)
			       (scale-float (float 4728827042594816 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8394286290816088 1.0d0) -54)
			       (scale-float (float -8573403169330254 1.0d0) -111)
			       (scale-float (float 6529695060451631 1.0d0) -167)
			       (scale-float (float -6393362274584590 1.0d0) -221)
			       (scale-float (float -6254752461488128 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8443147217093086 1.0d0) -54)
			       (scale-float (float -7447457963335574 1.0d0) -108)
			       (scale-float (float -6643844760557667 1.0d0) -162)
			       (scale-float (float 7249753184337927 1.0d0) -216)
			       (scale-float (float 4515101693927424 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8491928673252923 1.0d0) -54)
			       (scale-float (float 8459131853498433 1.0d0) -110)
			       (scale-float (float 6888360499664938 1.0d0) -164)
			       (scale-float (float -5236945859638041 1.0d0) -219)
			       (scale-float (float 7442291196362752 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8540630200145957 1.0d0) -54)
			       (scale-float (float -5286511185567367 1.0d0) -109)
			       (scale-float (float -8135173764139151 1.0d0) -164)
			       (scale-float (float -4921009164459924 1.0d0) -218)
			       (scale-float (float -7640091499790336 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8589251339374868 1.0d0) -54)
			       (scale-float (float -6680873419295655 1.0d0) -109)
			       (scale-float (float -8554354988263275 1.0d0) -164)
			       (scale-float (float 7339900865625287 1.0d0) -218)
			       (scale-float (float 4639882940514304 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8637791633298976 1.0d0) -54)
			       (scale-float (float 5977631648923170 1.0d0) -108)
			       (scale-float (float -7623682798863608 1.0d0) -162)
			       (scale-float (float 4624107632594484 1.0d0) -218)
			       (scale-float (float -7698762918789120 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8686250625038550 1.0d0) -54)
			       (scale-float (float -8392536875785958 1.0d0) -108)
			       (scale-float (float -4707724355155067 1.0d0) -169)
			       (scale-float (float 5500147221680155 1.0d0) -223)
			       (scale-float (float -7943631934586880 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8734627858479102 1.0d0) -54)
			       (scale-float (float -5852368960712652 1.0d0) -108)
			       (scale-float (float -8241530944970066 1.0d0) -164)
			       (scale-float (float -7219502451510509 1.0d0) -218)
			       (scale-float (float 8301579172839424 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8782922878275687 1.0d0) -54)
			       (scale-float (float 4618253045998479 1.0d0) -108)
			       (scale-float (float -8548139780246601 1.0d0) -165)
			       (scale-float (float -5125184194605572 1.0d0) -221)
			       (scale-float (float 4634136227610624 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8831135229857187 1.0d0) -54)
			       (scale-float (float -6684581881277189 1.0d0) -110)
			       (scale-float (float -8629413596046384 1.0d0) -164)
			       (scale-float (float 6391588371080480 1.0d0) -218)
			       (scale-float (float 7218057820504064 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8879264459430586 1.0d0) -54)
			       (scale-float (float -5326170718959288 1.0d0) -112)
			       (scale-float (float 6502706495111478 1.0d0) -166)
			       (scale-float (float -8175927755321089 1.0d0) -221)
			       (scale-float (float 5117625807405056 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8927310113985246 1.0d0) -54)
			       (scale-float (float -6121928410302052 1.0d0) -109)
			       (scale-float (float 5839069660685259 1.0d0) -167)
			       (scale-float (float 5662811753865077 1.0d0) -223)
			       (scale-float (float 8107771649064960 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8975271741297168 1.0d0) -54)
			       (scale-float (float -5233310756427739 1.0d0) -108)
			       (scale-float (float -8823317657688998 1.0d0) -162)
			       (scale-float (float 4654507950124385 1.0d0) -218)
			       (scale-float (float -6216207424782336 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4511574444966625 1.0d0) -53)
			       (scale-float (float -6426118857297543 1.0d0) -107)
			       (scale-float (float -6491521190013141 1.0d0) -161)
			       (scale-float (float 7186617536341604 1.0d0) -215)
			       (scale-float (float 6990809699385344 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4535470554627767 1.0d0) -53)
			       (scale-float (float -5429619939489420 1.0d0) -108)
			       (scale-float (float -5927987229493283 1.0d0) -162)
			       (scale-float (float 8625723713246926 1.0d0) -217)
			       (scale-float (float 6472651296374784 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4559323974712726 1.0d0) -53)
			       (scale-float (float -7840626733224058 1.0d0) -107)
			       (scale-float (float 5428491030047448 1.0d0) -162)
			       (scale-float (float 8993628089295535 1.0d0) -217)
			       (scale-float (float -4802179639607296 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4583134480704026 1.0d0) -53)
			       (scale-float (float 7761991876870000 1.0d0) -107)
			       (scale-float (float -6271024629654463 1.0d0) -162)
			       (scale-float (float 5752025628139535 1.0d0) -217)
			       (scale-float (float 5915389374300160 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4606901848488119 1.0d0) -53)
			       (scale-float (float -8494598453042205 1.0d0) -109)
			       (scale-float (float 4785427941994550 1.0d0) -163)
			       (scale-float (float -7993664237807223 1.0d0) -217)
			       (scale-float (float 5685423035973632 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4630625854357486 1.0d0) -53)
			       (scale-float (float -7417310864687212 1.0d0) -107)
			       (scale-float (float 4527229152853963 1.0d0) -161)
			       (scale-float (float -5445479406340099 1.0d0) -217)
			       (scale-float (float -8528540161802240 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4654306275012748 1.0d0) -53)
			       (scale-float (float 5388216318289433 1.0d0) -109)
			       (scale-float (float 6810717761619515 1.0d0) -163)
			       (scale-float (float -4804851653177209 1.0d0) -217)
			       (scale-float (float -5911309836353536 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4677942887564769 1.0d0) -53)
			       (scale-float (float -8978008309930964 1.0d0) -107)
			       (scale-float (float -5916790110693661 1.0d0) -167)
			       (scale-float (float -8118978520081596 1.0d0) -221)
			       (scale-float (float -5330927914319872 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4701535469536748 1.0d0) -53)
			       (scale-float (float -7554109741206949 1.0d0) -107)
			       (scale-float (float 5422636526155651 1.0d0) -163)
			       (scale-float (float -5639775327748784 1.0d0) -220)
			       (scale-float (float -4829205204828160 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4725083798866319 1.0d0) -53)
			       (scale-float (float -6988323544295858 1.0d0) -107)
			       (scale-float (float -4912183619887695 1.0d0) -163)
			       (scale-float (float -6359206876678376 1.0d0) -218)
			       (scale-float (float -5407918016692224 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4748587653907638 1.0d0) -53)
			       (scale-float (float -6847825579591004 1.0d0) -107)
			       (scale-float (float 5003358265465959 1.0d0) -162)
			       (scale-float (float 8422280950230119 1.0d0) -216)
			       (scale-float (float 8433490093867008 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4772046813433470 1.0d0) -53)
			       (scale-float (float -7799453234034926 1.0d0) -107)
			       (scale-float (float 6817580222556671 1.0d0) -163)
			       (scale-float (float -7560644201550137 1.0d0) -219)
			       (scale-float (float 4511177827942400 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4795461056637271 1.0d0) -53)
			       (scale-float (float -6655925208907997 1.0d0) -107)
			       (scale-float (float -5623857240635796 1.0d0) -161)
			       (scale-float (float -8070601107899198 1.0d0) -215)
			       (scale-float (float 7784203411095552 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4818830163135267 1.0d0) -53)
			       (scale-float (float -8710586291184881 1.0d0) -107)
			       (scale-float (float -8126282278485839 1.0d0) -162)
			       (scale-float (float 5719317781414307 1.0d0) -217)
			       (scale-float (float 7015619784343552 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4842153912968527 1.0d0) -53)
			       (scale-float (float -7339754703408720 1.0d0) -108)
			       (scale-float (float -6990336495915397 1.0d0) -163)
			       (scale-float (float 5257934322964996 1.0d0) -220)
			       (scale-float (float 5758322719588352 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4865432086605035 1.0d0) -53)
			       (scale-float (float 8785511657898515 1.0d0) -108)
			       (scale-float (float 6839125971928921 1.0d0) -162)
			       (scale-float (float -6223394966801216 1.0d0) -216)
			       (scale-float (float -4552744967618560 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4888664464941756 1.0d0) -53)
			       (scale-float (float 5564928859020974 1.0d0) -108)
			       (scale-float (float -7907253462425933 1.0d0) -162)
			       (scale-float (float 5236591704896374 1.0d0) -216)
			       (scale-float (float 7437180777906176 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4911850829306697 1.0d0) -53)
			       (scale-float (float -6736651049305461 1.0d0) -107)
			       (scale-float (float -8955456639116160 1.0d0) -162)
			       (scale-float (float 6701012809879390 1.0d0) -216)
			       (scale-float (float 7989770023075840 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4934990961460965 1.0d0) -53)
			       (scale-float (float -7809824017498950 1.0d0) -108)
			       (scale-float (float -5333685159010237 1.0d0) -170)
			       (scale-float (float -7013163948693077 1.0d0) -224)
			       (scale-float (float -7603687610384384 1.0d0) -280))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4958084643600824 1.0d0) -53)
			       (scale-float (float -5407770883530058 1.0d0) -109)
			       (scale-float (float -5391994932415003 1.0d0) -164)
			       (scale-float (float 8910660424091807 1.0d0) -218)
			       (scale-float (float -4742718246092800 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 4981131658359743 1.0d0) -53)
			       (scale-float (float -7636170899049036 1.0d0) -107)
			       (scale-float (float -6206770363233629 1.0d0) -162)
			       (scale-float (float -6822684679023966 1.0d0) -218)
			       (scale-float (float 7403295272861696 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5004131788810440 1.0d0) -53)
			       (scale-float (float 7641456135071232 1.0d0) -107)
			       (scale-float (float -6033230867222893 1.0d0) -161)
			       (scale-float (float 6471526251842736 1.0d0) -215)
			       (scale-float (float 7371837832855552 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5027084818466930 1.0d0) -53)
			       (scale-float (float 8749783685054072 1.0d0) -109)
			       (scale-float (float -6432564900081691 1.0d0) -163)
			       (scale-float (float -4946481004218511 1.0d0) -217)
			       (scale-float (float 7036909802094592 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5049990531286555 1.0d0) -53)
			       (scale-float (float -4800045970584779 1.0d0) -109)
			       (scale-float (float 4639463359548121 1.0d0) -163)
			       (scale-float (float 6739134100775357 1.0d0) -217)
			       (scale-float (float -6512123275313152 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5072848711672022 1.0d0) -53)
			       (scale-float (float 7735151275984803 1.0d0) -108)
			       (scale-float (float 6319202510957152 1.0d0) -165)
			       (scale-float (float 7852194967309185 1.0d0) -219)
			       (scale-float (float 8522408257650688 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5095659144473433 1.0d0) -53)
			       (scale-float (float -5532405218054066 1.0d0) -107)
			       (scale-float (float -4990528183184909 1.0d0) -161)
			       (scale-float (float 4694142170446455 1.0d0) -215)
			       (scale-float (float 4959870619623424 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5118421614990306 1.0d0) -53)
			       (scale-float (float -8264785570084562 1.0d0) -107)
			       (scale-float (float -4756999690706873 1.0d0) -161)
			       (scale-float (float 8271914155363375 1.0d0) -219)
			       (scale-float (float 8618867845365760 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5141135908973599 1.0d0) -53)
			       (scale-float (float 7972820976421517 1.0d0) -108)
			       (scale-float (float -7508892149590212 1.0d0) -162)
			       (scale-float (float -7598338450058821 1.0d0) -218)
			       (scale-float (float -7523805491494912 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5163801812627728 1.0d0) -53)
			       (scale-float (float 5528278164889757 1.0d0) -109)
			       (scale-float (float -7534708412684668 1.0d0) -163)
			       (scale-float (float 4748764085926481 1.0d0) -217)
			       (scale-float (float 7408881401200640 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5186419112612575 1.0d0) -53)
			       (scale-float (float -6151167318128396 1.0d0) -107)
			       (scale-float (float -8018890614716932 1.0d0) -161)
			       (scale-float (float 5861072145574035 1.0d0) -215)
			       (scale-float (float -6777560767791104 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5208987596045498 1.0d0) -53)
			       (scale-float (float -8514617700931210 1.0d0) -108)
			       (scale-float (float 7996782571413148 1.0d0) -162)
			       (scale-float (float -6615677919703496 1.0d0) -217)
			       (scale-float (float -8592814844411904 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5231507050503336 1.0d0) -53)
			       (scale-float (float 6031287197379932 1.0d0) -108)
			       (scale-float (float 6471258723704346 1.0d0) -164)
			       (scale-float (float 8258737189713217 1.0d0) -218)
			       (scale-float (float 7567381847080960 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5253977264024408 1.0d0) -53)
			       (scale-float (float 8961021967501223 1.0d0) -111)
			       (scale-float (float 8449105812948238 1.0d0) -165)
			       (scale-float (float -5388110305851105 1.0d0) -219)
			       (scale-float (float -7044177615388672 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5276398025110506 1.0d0) -53)
			       (scale-float (float -4865896352247366 1.0d0) -110)
			       (scale-float (float 6539437345050652 1.0d0) -164)
			       (scale-float (float -6050564890654524 1.0d0) -219)
			       (scale-float (float 5949983326994432 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5298769122728888 1.0d0) -53)
			       (scale-float (float -4752925789560358 1.0d0) -107)
			       (scale-float (float -6940658006329329 1.0d0) -161)
			       (scale-float (float -4874539996486145 1.0d0) -218)
			       (scale-float (float 7343781472239616 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5321090346314263 1.0d0) -53)
			       (scale-float (float -7628390168680570 1.0d0) -107)
			       (scale-float (float 7251508591837652 1.0d0) -161)
			       (scale-float (float 5307279358527743 1.0d0) -218)
			       (scale-float (float -7589365976268800 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5343361485770773 1.0d0) -53)
			       (scale-float (float 8367594692216948 1.0d0) -109)
			       (scale-float (float 6203590959579987 1.0d0) -163)
			       (scale-float (float 8665448091350130 1.0d0) -217)
			       (scale-float (float 7720213071331328 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5365582331473973 1.0d0) -53)
			       (scale-float (float -8722177288784495 1.0d0) -109)
			       (scale-float (float -6349014528983703 1.0d0) -166)
			       (scale-float (float 8570508217536058 1.0d0) -220)
			       (scale-float (float 5525942506094592 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5387752674272799 1.0d0) -53)
			       (scale-float (float 6295965926759422 1.0d0) -107)
			       (scale-float (float -7064411274953418 1.0d0) -162)
			       (scale-float (float -8521156802129240 1.0d0) -217)
			       (scale-float (float 7485998772518912 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5409872305491543 1.0d0) -53)
			       (scale-float (float -7528538090890981 1.0d0) -107)
			       (scale-float (float -4873667464989738 1.0d0) -161)
			       (scale-float (float 5474430362703076 1.0d0) -216)
			       (scale-float (float 6624897617756160 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5431941016931809 1.0d0) -53)
			       (scale-float (float 6056061026085675 1.0d0) -107)
			       (scale-float (float 8117741563781443 1.0d0) -161)
			       (scale-float (float -8527257181106372 1.0d0) -215)
			       (scale-float (float -6995774656077824 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5453958600874483 1.0d0) -53)
			       (scale-float (float -5062923073902567 1.0d0) -107)
			       (scale-float (float 7460245243959813 1.0d0) -162)
			       (scale-float (float -8605987486451288 1.0d0) -217)
			       (scale-float (float 6674159906947072 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5475924850081677 1.0d0) -53)
			       (scale-float (float 5705171231787006 1.0d0) -107)
			       (scale-float (float -5973740103346300 1.0d0) -164)
			       (scale-float (float -5933426595796939 1.0d0) -218)
			       (scale-float (float -7551225704611840 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5497839557798690 1.0d0) -53)
			       (scale-float (float -7322198333974194 1.0d0) -108)
			       (scale-float (float 7708295787222922 1.0d0) -162)
			       (scale-float (float 8668959416020342 1.0d0) -216)
			       (scale-float (float 6087956852113408 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5519702517755945 1.0d0) -53)
			       (scale-float (float -5541930106652097 1.0d0) -110)
			       (scale-float (float 6042424392306259 1.0d0) -164)
			       (scale-float (float 7112544487152837 1.0d0) -218)
			       (scale-float (float -5854708334592000 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5541513524170937 1.0d0) -53)
			       (scale-float (float 8512581754243428 1.0d0) -108)
			       (scale-float (float -8240160558210729 1.0d0) -162)
			       (scale-float (float 7588665830274554 1.0d0) -216)
			       (scale-float (float -6504131954491392 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5563272371750168 1.0d0) -53)
			       (scale-float (float -7703842410206491 1.0d0) -107)
			       (scale-float (float -8533597952376245 1.0d0) -163)
			       (scale-float (float -6350821420004830 1.0d0) -217)
			       (scale-float (float 7273129369075712 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5584978855691076 1.0d0) -53)
			       (scale-float (float -4540568005736910 1.0d0) -107)
			       (scale-float (float 6810569017348767 1.0d0) -162)
			       (scale-float (float -5743636460441176 1.0d0) -216)
			       (scale-float (float -6502230776709120 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5606632771683968 1.0d0) -53)
			       (scale-float (float 6872099470811347 1.0d0) -110)
			       (scale-float (float -4535230040345874 1.0d0) -166)
			       (scale-float (float 6845954161715752 1.0d0) -225)
			       (scale-float (float 5601564580380672 1.0d0) -280))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5628233915913940 1.0d0) -53)
			       (scale-float (float 5463569387507809 1.0d0) -107)
			       (scale-float (float -8139410524833584 1.0d0) -161)
			       (scale-float (float 5908305814053563 1.0d0) -216)
			       (scale-float (float 6734201719308288 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5649782085062796 1.0d0) -53)
			       (scale-float (float 4991677084184053 1.0d0) -107)
			       (scale-float (float 6329805746482172 1.0d0) -164)
			       (scale-float (float -4706296920171159 1.0d0) -218)
			       (scale-float (float 4607403172560896 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5671277076310961 1.0d0) -53)
			       (scale-float (float 6671344369483978 1.0d0) -107)
			       (scale-float (float -5602658804200812 1.0d0) -161)
			       (scale-float (float 5854533570742313 1.0d0) -215)
			       (scale-float (float 7577836945825792 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5692718687339392 1.0d0) -53)
			       (scale-float (float -6517134490911270 1.0d0) -107)
			       (scale-float (float -8442644072947353 1.0d0) -163)
			       (scale-float (float 7967700612201239 1.0d0) -217)
			       (scale-float (float -5908403881443328 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5714106716331478 1.0d0) -53)
			       (scale-float (float 6763552043812531 1.0d0) -109)
			       (scale-float (float 4814134823321695 1.0d0) -163)
			       (scale-float (float -4874409913813393 1.0d0) -221)
			       (scale-float (float 6265799002030080 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5735440961974946 1.0d0) -53)
			       (scale-float (float 5098032122654983 1.0d0) -107)
			       (scale-float (float -6633387170173303 1.0d0) -161)
			       (scale-float (float -8437401866493263 1.0d0) -215)
			       (scale-float (float 8850482936709120 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5756721223463751 1.0d0) -53)
			       (scale-float (float 8058961560658971 1.0d0) -109)
			       (scale-float (float -7260204596373573 1.0d0) -163)
			       (scale-float (float 5847373583723548 1.0d0) -217)
			       (scale-float (float -4857353439117312 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5777947300499967 1.0d0) -53)
			       (scale-float (float -6482805255133693 1.0d0) -109)
			       (scale-float (float 4907047913048716 1.0d0) -163)
			       (scale-float (float 4800601318416331 1.0d0) -219)
			       (scale-float (float 8773454969962496 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5799118993295673 1.0d0) -53)
			       (scale-float (float -5206056249695124 1.0d0) -107)
			       (scale-float (float -7363227589940729 1.0d0) -162)
			       (scale-float (float -8468347824445839 1.0d0) -217)
			       (scale-float (float -5240432990945280 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5820236102574833 1.0d0) -53)
			       (scale-float (float -4828209332879607 1.0d0) -107)
			       (scale-float (float -6006988076989561 1.0d0) -162)
			       (scale-float (float 6811807852310658 1.0d0) -219)
			       (scale-float (float 5809724755279872 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5841298429575172 1.0d0) -53)
			       (scale-float (float 5175456982428321 1.0d0) -110)
			       (scale-float (float 4538462653543703 1.0d0) -164)
			       (scale-float (float -8728016611215022 1.0d0) -220)
			       (scale-float (float 8118126690435072 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5862305776050047 1.0d0) -53)
			       (scale-float (float 6444073748996113 1.0d0) -107)
			       (scale-float (float 6823119024662590 1.0d0) -164)
			       (scale-float (float 6426684369717617 1.0d0) -220)
			       (scale-float (float -6584771784998912 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5883257944270313 1.0d0) -53)
			       (scale-float (float 5561965163229991 1.0d0) -109)
			       (scale-float (float -8086818543630428 1.0d0) -163)
			       (scale-float (float 5028398904287973 1.0d0) -217)
			       (scale-float (float -7931166882234368 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5904154737026182 1.0d0) -53)
			       (scale-float (float 5782715275133621 1.0d0) -107)
			       (scale-float (float 7421719155960077 1.0d0) -162)
			       (scale-float (float 4632156185190014 1.0d0) -216)
			       (scale-float (float -5738789061853184 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5924995957629083 1.0d0) -53)
			       (scale-float (float 6354379320602223 1.0d0) -108)
			       (scale-float (float -6982629383914688 1.0d0) -162)
			       (scale-float (float 6014680402693896 1.0d0) -217)
			       (scale-float (float -8539292463071232 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5945781409913510 1.0d0) -53)
			       (scale-float (float -5798779723014377 1.0d0) -115)
			       (scale-float (float 4603157000630414 1.0d0) -169)
			       (scale-float (float 7213200979097056 1.0d0) -223)
			       (scale-float (float -8826565714509824 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5966510898238870 1.0d0) -53)
			       (scale-float (float -7339152233857623 1.0d0) -108)
			       (scale-float (float 5866707295710201 1.0d0) -163)
			       (scale-float (float 6142346235706265 1.0d0) -217)
			       (scale-float (float 8313774792736768 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 5987184227491324 1.0d0) -53)
			       (scale-float (float -5878295590335062 1.0d0) -107)
			       (scale-float (float -5296945800600359 1.0d0) -162)
			       (scale-float (float 6511887897632255 1.0d0) -217)
			       (scale-float (float 5276882688147456 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6007801203085623 1.0d0) -53)
			       (scale-float (float 5725215547860703 1.0d0) -107)
			       (scale-float (float -6069357457640343 1.0d0) -162)
			       (scale-float (float 7773390546671458 1.0d0) -216)
			       (scale-float (float 7968963672981504 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6028361630966943 1.0d0) -53)
			       (scale-float (float -8858164301443705 1.0d0) -107)
			       (scale-float (float -7360418845574603 1.0d0) -161)
			       (scale-float (float -8881973385408916 1.0d0) -215)
			       (scale-float (float 8555186859573248 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6048865317612704 1.0d0) -53)
			       (scale-float (float -6569721984711602 1.0d0) -107)
			       (scale-float (float 7481914584676442 1.0d0) -164)
			       (scale-float (float -5916197970128717 1.0d0) -218)
			       (scale-float (float -7836459686559744 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6069312070034399 1.0d0) -53)
			       (scale-float (float 7493750390382232 1.0d0) -108)
			       (scale-float (float 6714493630887683 1.0d0) -163)
			       (scale-float (float 4735122177247567 1.0d0) -218)
			       (scale-float (float -4941962754916352 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6089701695779408 1.0d0) -53)
			       (scale-float (float 6045278015665200 1.0d0) -107)
			       (scale-float (float 4986473437314348 1.0d0) -161)
			       (scale-float (float 5124830363027071 1.0d0) -215)
			       (scale-float (float -8685303774765056 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6110034002932808 1.0d0) -53)
			       (scale-float (float 5939368762867376 1.0d0) -108)
			       (scale-float (float 5567834601844250 1.0d0) -162)
			       (scale-float (float 5300167663866890 1.0d0) -216)
			       (scale-float (float 6738040557109248 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6130308800119180 1.0d0) -53)
			       (scale-float (float 4620055988650794 1.0d0) -107)
			       (scale-float (float 4832520168769970 1.0d0) -163)
			       (scale-float (float 8968190560224699 1.0d0) -217)
			       (scale-float (float 7514552917917696 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6150525896504412 1.0d0) -53)
			       (scale-float (float -8410260520695715 1.0d0) -109)
			       (scale-float (float 8554993117360727 1.0d0) -165)
			       (scale-float (float 5819339724088257 1.0d0) -220)
			       (scale-float (float 8400329153183744 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6170685101797492 1.0d0) -53)
			       (scale-float (float 8420651303499559 1.0d0) -108)
			       (scale-float (float -4970902812289148 1.0d0) -162)
			       (scale-float (float -7326795827672023 1.0d0) -216)
			       (scale-float (float 7224475175321600 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6190786226252304 1.0d0) -53)
			       (scale-float (float -8949598425759774 1.0d0) -107)
			       (scale-float (float 6954695760200578 1.0d0) -162)
			       (scale-float (float -6614108672187788 1.0d0) -219)
			       (scale-float (float 5154762600218624 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6210829080669407 1.0d0) -53)
			       (scale-float (float -5156380214241847 1.0d0) -108)
			       (scale-float (float 5334034121559607 1.0d0) -162)
			       (scale-float (float 8070176566193680 1.0d0) -217)
			       (scale-float (float 8851958962061312 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6230813476397823 1.0d0) -53)
			       (scale-float (float 8893780947316055 1.0d0) -108)
			       (scale-float (float 7767301829960617 1.0d0) -162)
			       (scale-float (float 7179345590973681 1.0d0) -222)
			       (scale-float (float 5937979382038528 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6250739225336809 1.0d0) -53)
			       (scale-float (float 4825271369095292 1.0d0) -109)
			       (scale-float (float 8776203731192851 1.0d0) -163)
			       (scale-float (float -6709656828176138 1.0d0) -218)
			       (scale-float (float -6050141510893568 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6270606139937627 1.0d0) -53)
			       (scale-float (float -6688989605664720 1.0d0) -107)
			       (scale-float (float -5956139094822349 1.0d0) -167)
			       (scale-float (float 4660601968416390 1.0d0) -221)
			       (scale-float (float -5979205406294016 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6290414033205309 1.0d0) -53)
			       (scale-float (float 7948803281116707 1.0d0) -107)
			       (scale-float (float 5592877509532575 1.0d0) -161)
			       (scale-float (float 5510182001592507 1.0d0) -217)
			       (scale-float (float 7841036626427904 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6310162718700422 1.0d0) -53)
			       (scale-float (float 5034574382400651 1.0d0) -107)
			       (scale-float (float 5591018388425185 1.0d0) -162)
			       (scale-float (float 7733615070437822 1.0d0) -220)
			       (scale-float (float -8216659223379968 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6329852010540816 1.0d0) -53)
			       (scale-float (float 6562620425861985 1.0d0) -111)
			       (scale-float (float -8136290568547131 1.0d0) -166)
			       (scale-float (float 8426790677064153 1.0d0) -220)
			       (scale-float (float -7975017094316032 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6349481723403377 1.0d0) -53)
			       (scale-float (float 8959543695439504 1.0d0) -108)
			       (scale-float (float 6972321431588115 1.0d0) -164)
			       (scale-float (float 4858285252195155 1.0d0) -218)
			       (scale-float (float 5563275298799616 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6369051672525773 1.0d0) -53)
			       (scale-float (float -7843040109683798 1.0d0) -107)
			       (scale-float (float 6048680740045173 1.0d0) -161)
			       (scale-float (float 5197737643093849 1.0d0) -217)
			       (scale-float (float 6206530073657344 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))))
  "Table of sin(k/1024) for k = 1 to 256")

(defconstant +qd-cos-table+
  (make-array 256 :initial-contents
	      (list
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9007156865146114 1.0d0) -53)
			       (scale-float (float -6382651775133715 1.0d0) -108)
			       (scale-float (float -7372276689025835 1.0d0) -163)
			       (scale-float (float 7180257539184632 1.0d0) -223)
			       (scale-float (float 4647614729420800 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9007029696760466 1.0d0) -53)
			       (scale-float (float 5446736202153207 1.0d0) -107)
			       (scale-float (float -5514938334717690 1.0d0) -168)
			       (scale-float (float 6645835630926151 1.0d0) -222)
			       (scale-float (float 6226651211890688 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9006817750781007 1.0d0) -53)
			       (scale-float (float -5115684009971601 1.0d0) -107)
			       (scale-float (float 7705986954927589 1.0d0) -161)
			       (scale-float (float 5269566330016025 1.0d0) -215)
			       (scale-float (float -4652247029481472 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9006521029202651 1.0d0) -53)
			       (scale-float (float 6154670017854733 1.0d0) -107)
			       (scale-float (float -7959914909379173 1.0d0) -166)
			       (scale-float (float -8417733335951937 1.0d0) -220)
			       (scale-float (float 8340201740959744 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9006139534818257 1.0d0) -53)
			       (scale-float (float -5756604584677720 1.0d0) -107)
			       (scale-float (float 4998920502946311 1.0d0) -161)
			       (scale-float (float -5647576219871589 1.0d0) -215)
			       (scale-float (float -6721652409794560 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9005673271218593 1.0d0) -53)
			       (scale-float (float 6109107373172336 1.0d0) -108)
			       (scale-float (float -6007767124009731 1.0d0) -163)
			       (scale-float (float -8083524655498703 1.0d0) -217)
			       (scale-float (float -7072462970978304 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9005122242792311 1.0d0) -53)
			       (scale-float (float 6925416919478846 1.0d0) -107)
			       (scale-float (float 5571917222010501 1.0d0) -161)
			       (scale-float (float -6342027657037425 1.0d0) -216)
			       (scale-float (float -4603410360238080 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9004486454725901 1.0d0) -53)
			       (scale-float (float -4843680596157643 1.0d0) -107)
			       (scale-float (float -5578489598087899 1.0d0) -161)
			       (scale-float (float 4716327604025735 1.0d0) -219)
			       (scale-float (float -6122578428821504 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9003765913003641 1.0d0) -53)
			       (scale-float (float -6682155943911976 1.0d0) -107)
			       (scale-float (float 6113568212113372 1.0d0) -161)
			       (scale-float (float 8572777647471794 1.0d0) -216)
			       (scale-float (float -5138763782258688 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9002960624407544 1.0d0) -53)
			       (scale-float (float 6658445016247619 1.0d0) -108)
			       (scale-float (float -5574027242944025 1.0d0) -163)
			       (scale-float (float -6201546866284994 1.0d0) -217)
			       (scale-float (float -6038475427643392 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9002070596517294 1.0d0) -53)
			       (scale-float (float 6432687535538725 1.0d0) -107)
			       (scale-float (float -5555395417668222 1.0d0) -164)
			       (scale-float (float -8665438431468013 1.0d0) -222)
			       (scale-float (float -5031988419362816 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9001095837710173 1.0d0) -53)
			       (scale-float (float -6954195453368662 1.0d0) -107)
			       (scale-float (float 7771704866044900 1.0d0) -164)
			       (scale-float (float -7039433522181404 1.0d0) -219)
			       (scale-float (float -6185930852270080 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 9000036357160980 1.0d0) -53)
			       (scale-float (float 5957921611966531 1.0d0) -109)
			       (scale-float (float 6479270319865368 1.0d0) -163)
			       (scale-float (float 5409988246591494 1.0d0) -222)
			       (scale-float (float -7994611314196480 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8998892164841951 1.0d0) -53)
			       (scale-float (float 6950865384540836 1.0d0) -108)
			       (scale-float (float -4621163143123886 1.0d0) -162)
			       (scale-float (float -5599064490362240 1.0d0) -216)
			       (scale-float (float 5583424856309760 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8997663271522660 1.0d0) -53)
			       (scale-float (float -6688535702623983 1.0d0) -108)
			       (scale-float (float -7334707016190584 1.0d0) -162)
			       (scale-float (float -7916945128397036 1.0d0) -216)
			       (scale-float (float -8791179288117248 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8996349688769918 1.0d0) -53)
			       (scale-float (float -7977765087521301 1.0d0) -109)
			       (scale-float (float 5721708006624170 1.0d0) -164)
			       (scale-float (float 4517430183150016 1.0d0) -218)
			       (scale-float (float 5871275226955776 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8994951428947667 1.0d0) -53)
			       (scale-float (float -7900445453445422 1.0d0) -107)
			       (scale-float (float -6891478759949600 1.0d0) -164)
			       (scale-float (float -5476513299440062 1.0d0) -218)
			       (scale-float (float 8356532741472256 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8993468505216860 1.0d0) -53)
			       (scale-float (float -7140359403681271 1.0d0) -108)
			       (scale-float (float -7232392529862741 1.0d0) -162)
			       (scale-float (float -5246916413682806 1.0d0) -217)
			       (scale-float (float -7238965407514624 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8991900931535341 1.0d0) -53)
			       (scale-float (float -8416291772118320 1.0d0) -107)
			       (scale-float (float 6126729149397296 1.0d0) -162)
			       (scale-float (float -6107196519366287 1.0d0) -217)
			       (scale-float (float -5238413251313664 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8990248722657709 1.0d0) -53)
			       (scale-float (float 4532792009051038 1.0d0) -107)
			       (scale-float (float 7138950646897488 1.0d0) -161)
			       (scale-float (float -7124028913967965 1.0d0) -216)
			       (scale-float (float -8901045372518400 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8988511894135185 1.0d0) -53)
			       (scale-float (float 5563435675856346 1.0d0) -108)
			       (scale-float (float 6768020100627694 1.0d0) -163)
			       (scale-float (float -7801655263446071 1.0d0) -219)
			       (scale-float (float -7241441876901888 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8986690462315460 1.0d0) -53)
			       (scale-float (float -8565496940783238 1.0d0) -108)
			       (scale-float (float -7565304489103248 1.0d0) -165)
			       (scale-float (float -8418659784422752 1.0d0) -219)
			       (scale-float (float 6926739732430848 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8984784444342543 1.0d0) -53)
			       (scale-float (float 7270150983818169 1.0d0) -110)
			       (scale-float (float -5563309902486145 1.0d0) -166)
			       (scale-float (float -4888785479057611 1.0d0) -231)
			       (scale-float (float 7720818968625152 1.0d0) -286))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8982793858156602 1.0d0) -53)
			       (scale-float (float 5948275509591605 1.0d0) -109)
			       (scale-float (float 7930006667538804 1.0d0) -163)
			       (scale-float (float -5809288382338202 1.0d0) -222)
			       (scale-float (float -5183447321542656 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8980718722493792 1.0d0) -53)
			       (scale-float (float 5430523834411255 1.0d0) -108)
			       (scale-float (float -7699162237707398 1.0d0) -162)
			       (scale-float (float 8687041402074628 1.0d0) -219)
			       (scale-float (float -5875359970492416 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8978559056886080 1.0d0) -53)
			       (scale-float (float 7636379253722903 1.0d0) -107)
			       (scale-float (float 8304848910636198 1.0d0) -161)
			       (scale-float (float -8425631601226793 1.0d0) -216)
			       (scale-float (float -7284343497818112 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8976314881661062 1.0d0) -53)
			       (scale-float (float 7598393650369643 1.0d0) -109)
			       (scale-float (float -8878261545093758 1.0d0) -163)
			       (scale-float (float 5997503087615023 1.0d0) -217)
			       (scale-float (float -6238645926363136 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8973986217941769 1.0d0) -53)
			       (scale-float (float 7357807798683726 1.0d0) -109)
			       (scale-float (float 7951143844149272 1.0d0) -164)
			       (scale-float (float 5218035394662342 1.0d0) -222)
			       (scale-float (float 7027860686503936 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8971573087646471 1.0d0) -53)
			       (scale-float (float 7421749611895653 1.0d0) -108)
			       (scale-float (float -4581496555918016 1.0d0) -163)
			       (scale-float (float -7810225024786925 1.0d0) -217)
			       (scale-float (float 7869119827017728 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8969075513488470 1.0d0) -53)
			       (scale-float (float -7513223803443073 1.0d0) -108)
			       (scale-float (float -7626238511742260 1.0d0) -165)
			       (scale-float (float -5366856187311050 1.0d0) -221)
			       (scale-float (float -8321992797192192 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8966493518975884 1.0d0) -53)
			       (scale-float (float 8329643948299160 1.0d0) -111)
			       (scale-float (float -7408252878990684 1.0d0) -170)
			       (scale-float (float -7497946385569394 1.0d0) -224)
			       (scale-float (float 7582116766285824 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8963827128411430 1.0d0) -53)
			       (scale-float (float -6893895888146887 1.0d0) -107)
			       (scale-float (float 7784256318365108 1.0d0) -162)
			       (scale-float (float 7153652023322651 1.0d0) -216)
			       (scale-float (float 4965114949697536 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8961076366892190 1.0d0) -53)
			       (scale-float (float 5468892236673259 1.0d0) -110)
			       (scale-float (float -7868743052739110 1.0d0) -167)
			       (scale-float (float 8477913984177349 1.0d0) -221)
			       (scale-float (float -5579356937125888 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8958241260309380 1.0d0) -53)
			       (scale-float (float 5962228427073425 1.0d0) -107)
			       (scale-float (float -8945355811576285 1.0d0) -161)
			       (scale-float (float 5475118791675541 1.0d0) -215)
			       (scale-float (float 4625777543659520 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8955321835348103 1.0d0) -53)
			       (scale-float (float 7160408339531907 1.0d0) -107)
			       (scale-float (float -8800353687418162 1.0d0) -161)
			       (scale-float (float 7814338741356067 1.0d0) -216)
			       (scale-float (float -5255802045693952 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8952318119487099 1.0d0) -53)
			       (scale-float (float -6154445520718857 1.0d0) -108)
			       (scale-float (float -5979147254374853 1.0d0) -168)
			       (scale-float (float -5754250618745921 1.0d0) -222)
			       (scale-float (float 8297896894005248 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8949230140998484 1.0d0) -53)
			       (scale-float (float 4827588292883036 1.0d0) -107)
			       (scale-float (float -5269205324285223 1.0d0) -163)
			       (scale-float (float -7066073884583852 1.0d0) -217)
			       (scale-float (float 8372737114701824 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8946057928947489 1.0d0) -53)
			       (scale-float (float 5370280075238301 1.0d0) -107)
			       (scale-float (float 4557784045899430 1.0d0) -161)
			       (scale-float (float 6055026141926995 1.0d0) -218)
			       (scale-float (float -7308959128748032 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8942801513192182 1.0d0) -53)
			       (scale-float (float -4573932509451197 1.0d0) -108)
			       (scale-float (float -6988642513170233 1.0d0) -162)
			       (scale-float (float 7903423679430231 1.0d0) -218)
			       (scale-float (float -4786535270383616 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8939460924383187 1.0d0) -53)
			       (scale-float (float 5045136634195182 1.0d0) -107)
			       (scale-float (float -5372361566405903 1.0d0) -161)
			       (scale-float (float -6720737022123546 1.0d0) -220)
			       (scale-float (float -5558062788640768 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8936036193963400 1.0d0) -53)
			       (scale-float (float -6398195821015223 1.0d0) -107)
			       (scale-float (float -7337680936016907 1.0d0) -163)
			       (scale-float (float -5459780776141598 1.0d0) -218)
			       (scale-float (float -5736241082269696 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8932527354167686 1.0d0) -53)
			       (scale-float (float -6067949506678475 1.0d0) -111)
			       (scale-float (float 5064661831761972 1.0d0) -167)
			       (scale-float (float -8471798904647962 1.0d0) -222)
			       (scale-float (float -7569794282815488 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8928934438022583 1.0d0) -53)
			       (scale-float (float -8175307614637614 1.0d0) -108)
			       (scale-float (float -7513563295790417 1.0d0) -162)
			       (scale-float (float 5516806786798278 1.0d0) -216)
			       (scale-float (float 5289066156359680 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8925257479345985 1.0d0) -53)
			       (scale-float (float 4995821998689288 1.0d0) -108)
			       (scale-float (float -6313677797518807 1.0d0) -162)
			       (scale-float (float 4625503888993559 1.0d0) -220)
			       (scale-float (float 8326015007326208 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8921496512746829 1.0d0) -53)
			       (scale-float (float -8991019785543599 1.0d0) -107)
			       (scale-float (float -8543364032599344 1.0d0) -162)
			       (scale-float (float -8075214757855398 1.0d0) -217)
			       (scale-float (float -5854745001787392 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8917651573624763 1.0d0) -53)
			       (scale-float (float -5534821618232727 1.0d0) -108)
			       (scale-float (float 7865766552369999 1.0d0) -162)
			       (scale-float (float 7700180873329070 1.0d0) -216)
			       (scale-float (float 6973396458733568 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8913722698169820 1.0d0) -53)
			       (scale-float (float -8502096954648678 1.0d0) -107)
			       (scale-float (float 7870589230495605 1.0d0) -162)
			       (scale-float (float 6110391933205275 1.0d0) -216)
			       (scale-float (float -6053092350230528 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8909709923362071 1.0d0) -53)
			       (scale-float (float -6650571269560095 1.0d0) -107)
			       (scale-float (float -5244751855479113 1.0d0) -163)
			       (scale-float (float -8301663588356049 1.0d0) -217)
			       (scale-float (float -8409129498443776 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8905613286971281 1.0d0) -53)
			       (scale-float (float -7123978755460638 1.0d0) -109)
			       (scale-float (float 7555692813056111 1.0d0) -164)
			       (scale-float (float 8118983438487515 1.0d0) -219)
			       (scale-float (float -6274343922434048 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8901432827556552 1.0d0) -53)
			       (scale-float (float 8771933742692817 1.0d0) -108)
			       (scale-float (float 7250438674596944 1.0d0) -166)
			       (scale-float (float 7083606337494008 1.0d0) -221)
			       (scale-float (float -5911679515754496 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8897168584465961 1.0d0) -53)
			       (scale-float (float -7658862886582027 1.0d0) -108)
			       (scale-float (float -7204199762688552 1.0d0) -162)
			       (scale-float (float 6346308409048664 1.0d0) -217)
			       (scale-float (float -7548343030775808 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8892820597836187 1.0d0) -53)
			       (scale-float (float -8491394866189883 1.0d0) -107)
			       (scale-float (float -8166182587214152 1.0d0) -161)
			       (scale-float (float 6357787596929140 1.0d0) -215)
			       (scale-float (float 8624953857998848 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8888388908592136 1.0d0) -53)
			       (scale-float (float -8159567034358810 1.0d0) -107)
			       (scale-float (float -6629817546842393 1.0d0) -161)
			       (scale-float (float 4634129890739685 1.0d0) -216)
			       (scale-float (float 8624457930817536 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8883873558446555 1.0d0) -53)
			       (scale-float (float -6983923910930642 1.0d0) -108)
			       (scale-float (float 6937180072251376 1.0d0) -162)
			       (scale-float (float -8270405867504028 1.0d0) -216)
			       (scale-float (float -7710785325826048 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8879274589899640 1.0d0) -53)
			       (scale-float (float -8346528441017500 1.0d0) -107)
			       (scale-float (float 7680611814957263 1.0d0) -161)
			       (scale-float (float 7943027189392270 1.0d0) -216)
			       (scale-float (float -8950289039622144 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8874592046238633 1.0d0) -53)
			       (scale-float (float 7514433837333686 1.0d0) -108)
			       (scale-float (float -8801276453264781 1.0d0) -163)
			       (scale-float (float 8915512537041539 1.0d0) -219)
			       (scale-float (float -6706195078053888 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8869825971537420 1.0d0) -53)
			       (scale-float (float 6846136909451560 1.0d0) -109)
			       (scale-float (float 6731359750255182 1.0d0) -164)
			       (scale-float (float -6197790138101606 1.0d0) -220)
			       (scale-float (float -5827577104039936 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8864976410656110 1.0d0) -53)
			       (scale-float (float 7785836584894173 1.0d0) -107)
			       (scale-float (float 5284186529715868 1.0d0) -164)
			       (scale-float (float 7402980542247590 1.0d0) -218)
			       (scale-float (float -6330898283495424 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8860043409240618 1.0d0) -53)
			       (scale-float (float 6446544258894238 1.0d0) -108)
			       (scale-float (float -8038901621714735 1.0d0) -169)
			       (scale-float (float 4846229103018903 1.0d0) -224)
			       (scale-float (float 5075986748014592 1.0d0) -280))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8855027013722231 1.0d0) -53)
			       (scale-float (float 6842474924546396 1.0d0) -107)
			       (scale-float (float 4816891086673617 1.0d0) -162)
			       (scale-float (float -8509622836947172 1.0d0) -216)
			       (scale-float (float 6116515596484608 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8849927271317175 1.0d0) -53)
			       (scale-float (float 4916320054218436 1.0d0) -108)
			       (scale-float (float -4887585510279573 1.0d0) -163)
			       (scale-float (float -4665371238305833 1.0d0) -217)
			       (scale-float (float 5226898507431936 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8844744230026167 1.0d0) -53)
			       (scale-float (float 6850081623240539 1.0d0) -108)
			       (scale-float (float -8916921648409142 1.0d0) -162)
			       (scale-float (float -7202105646592469 1.0d0) -216)
			       (scale-float (float -8736424918941696 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8839477938633966 1.0d0) -53)
			       (scale-float (float 8715376239079668 1.0d0) -109)
			       (scale-float (float -7634216994416838 1.0d0) -163)
			       (scale-float (float 4712162648716876 1.0d0) -220)
			       (scale-float (float 4657639888257024 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8834128446708912 1.0d0) -53)
			       (scale-float (float 6018826142883795 1.0d0) -108)
			       (scale-float (float -6253218580383489 1.0d0) -162)
			       (scale-float (float 7020978235349363 1.0d0) -216)
			       (scale-float (float 4743599271837696 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8828695804602461 1.0d0) -53)
			       (scale-float (float -5971431338778072 1.0d0) -107)
			       (scale-float (float 7394633722946009 1.0d0) -163)
			       (scale-float (float 7835308697779253 1.0d0) -218)
			       (scale-float (float 8677283430989824 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8823180063448708 1.0d0) -53)
			       (scale-float (float 5054049223849600 1.0d0) -108)
			       (scale-float (float -7834271977802953 1.0d0) -162)
			       (scale-float (float -7272320165403980 1.0d0) -218)
			       (scale-float (float -6060777007677440 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8817581275163911 1.0d0) -53)
			       (scale-float (float -6183435703505308 1.0d0) -111)
			       (scale-float (float -5001726456690585 1.0d0) -165)
			       (scale-float (float -6933175510886964 1.0d0) -219)
			       (scale-float (float -5841804373393408 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8811899492445997 1.0d0) -53)
			       (scale-float (float -7017091372002309 1.0d0) -108)
			       (scale-float (float 6413304785703535 1.0d0) -162)
			       (scale-float (float 8118727090730765 1.0d0) -216)
			       (scale-float (float -6790498992046080 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8806134768774068 1.0d0) -53)
			       (scale-float (float 8196387204119507 1.0d0) -107)
			       (scale-float (float -7748736525621098 1.0d0) -162)
			       (scale-float (float 7388842477950275 1.0d0) -216)
			       (scale-float (float -8021260472156160 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8800287158407901 1.0d0) -53)
			       (scale-float (float -7034568527191045 1.0d0) -107)
			       (scale-float (float 6424625550657811 1.0d0) -163)
			       (scale-float (float -7814615457557805 1.0d0) -219)
			       (scale-float (float -6451150358315008 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8794356716387429 1.0d0) -53)
			       (scale-float (float 6042141602652702 1.0d0) -109)
			       (scale-float (float -4815349649953967 1.0d0) -163)
			       (scale-float (float -6721857373013784 1.0d0) -217)
			       (scale-float (float 5344386943254528 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8788343498532233 1.0d0) -53)
			       (scale-float (float -8298768912839398 1.0d0) -108)
			       (scale-float (float -5446972436275558 1.0d0) -162)
			       (scale-float (float -7049677529730599 1.0d0) -219)
			       (scale-float (float 5156198265389056 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8782247561441008 1.0d0) -53)
			       (scale-float (float 8646037700366584 1.0d0) -108)
			       (scale-float (float 8333782932738579 1.0d0) -165)
			       (scale-float (float -5587385824373688 1.0d0) -220)
			       (scale-float (float 7163783185170432 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8776068962491037 1.0d0) -53)
			       (scale-float (float 5981843094371335 1.0d0) -111)
			       (scale-float (float 5031627907802402 1.0d0) -165)
			       (scale-float (float 8605971594377410 1.0d0) -220)
			       (scale-float (float 4691414601957376 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8769807759837646 1.0d0) -53)
			       (scale-float (float -8393641348716169 1.0d0) -107)
			       (scale-float (float -4533131738151266 1.0d0) -161)
			       (scale-float (float -8690963173342473 1.0d0) -215)
			       (scale-float (float 7559291244019712 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8763464012413658 1.0d0) -53)
			       (scale-float (float -5080534473348267 1.0d0) -107)
			       (scale-float (float -7855304661081380 1.0d0) -161)
			       (scale-float (float -7296856099117507 1.0d0) -221)
			       (scale-float (float 5820900656021504 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8757037779928840 1.0d0) -53)
			       (scale-float (float 5916163041813500 1.0d0) -107)
			       (scale-float (float 8859516786540065 1.0d0) -161)
			       (scale-float (float -8561614259167781 1.0d0) -222)
			       (scale-float (float 8906252604145664 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8750529122869341 1.0d0) -53)
			       (scale-float (float -5183562189985281 1.0d0) -109)
			       (scale-float (float -5101040255073374 1.0d0) -163)
			       (scale-float (float 5780805313355459 1.0d0) -220)
			       (scale-float (float -5212699000832000 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8743938102497119 1.0d0) -53)
			       (scale-float (float -7787173714602643 1.0d0) -107)
			       (scale-float (float 8870592638467604 1.0d0) -161)
			       (scale-float (float 4527859829386072 1.0d0) -215)
			       (scale-float (float -7109348041826304 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8737264780849367 1.0d0) -53)
			       (scale-float (float 5959880706574729 1.0d0) -108)
			       (scale-float (float -8366277013359923 1.0d0) -162)
			       (scale-float (float 7232577075726740 1.0d0) -219)
			       (scale-float (float 4922377451601920 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8730509220737932 1.0d0) -53)
			       (scale-float (float -7409352491475308 1.0d0) -107)
			       (scale-float (float 5620790720594497 1.0d0) -162)
			       (scale-float (float 6846782194285202 1.0d0) -219)
			       (scale-float (float -7328175199092736 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8723671485748716 1.0d0) -53)
			       (scale-float (float 8027789877305549 1.0d0) -107)
			       (scale-float (float 8347728572284626 1.0d0) -161)
			       (scale-float (float 6629242611071548 1.0d0) -216)
			       (scale-float (float -5618340135436288 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8716751640241088 1.0d0) -53)
			       (scale-float (float -7384765759223300 1.0d0) -107)
			       (scale-float (float -8259014728839389 1.0d0) -162)
			       (scale-float (float -8911590265625930 1.0d0) -216)
			       (scale-float (float 4719924142702592 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8709749749347266 1.0d0) -53)
			       (scale-float (float 6246370251798351 1.0d0) -107)
			       (scale-float (float -6299847417742655 1.0d0) -163)
			       (scale-float (float -7418590254845397 1.0d0) -217)
			       (scale-float (float 5499354970587136 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8702665878971716 1.0d0) -53)
			       (scale-float (float 8323712745751476 1.0d0) -107)
			       (scale-float (float 6811334649930440 1.0d0) -165)
			       (scale-float (float 8505841244414894 1.0d0) -219)
			       (scale-float (float -4604923142471680 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8695500095790524 1.0d0) -53)
			       (scale-float (float -7705819592372010 1.0d0) -108)
			       (scale-float (float 6924187360006505 1.0d0) -163)
			       (scale-float (float -8174591260972689 1.0d0) -217)
			       (scale-float (float -7148565255880704 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8688252467250769 1.0d0) -53)
			       (scale-float (float -5547558796790388 1.0d0) -107)
			       (scale-float (float 6717667801494033 1.0d0) -161)
			       (scale-float (float -4752616405244403 1.0d0) -216)
			       (scale-float (float -5509960524693504 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8680923061569891 1.0d0) -53)
			       (scale-float (float 8588042960215234 1.0d0) -108)
			       (scale-float (float -8702070775005543 1.0d0) -171)
			       (scale-float (float -6976332996211473 1.0d0) -225)
			       (scale-float (float 5268299529060352 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8673511947735049 1.0d0) -53)
			       (scale-float (float 5798624754283258 1.0d0) -109)
			       (scale-float (float -4568215043570977 1.0d0) -163)
			       (scale-float (float 6829329873018631 1.0d0) -218)
			       (scale-float (float 8280773494046720 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8666019195502468 1.0d0) -53)
			       (scale-float (float 4944614710107653 1.0d0) -108)
			       (scale-float (float -7629139990045050 1.0d0) -162)
			       (scale-float (float 8321368928085100 1.0d0) -216)
			       (scale-float (float 5867063029071872 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8658444875396786 1.0d0) -53)
			       (scale-float (float 5434765495412269 1.0d0) -111)
			       (scale-float (float 5036267983276872 1.0d0) -165)
			       (scale-float (float -5008959202542514 1.0d0) -219)
			       (scale-float (float -8192210130960384 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8650789058710388 1.0d0) -53)
			       (scale-float (float 8000649532699255 1.0d0) -108)
			       (scale-float (float -8062911270553914 1.0d0) -162)
			       (scale-float (float -8041915918056652 1.0d0) -220)
			       (scale-float (float 7385556375830528 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8643051817502737 1.0d0) -53)
			       (scale-float (float 7139823619402846 1.0d0) -109)
			       (scale-float (float -4914858230587332 1.0d0) -163)
			       (scale-float (float 6743980924865325 1.0d0) -220)
			       (scale-float (float 6632308531527680 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8635233224599694 1.0d0) -53)
			       (scale-float (float -7088298843580067 1.0d0) -107)
			       (scale-float (float 6431133538561354 1.0d0) -161)
			       (scale-float (float -5557182891497347 1.0d0) -215)
			       (scale-float (float 7201854697758720 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8627333353592832 1.0d0) -53)
			       (scale-float (float -5742910758171990 1.0d0) -108)
			       (scale-float (float 8962645513660430 1.0d0) -165)
			       (scale-float (float 6865454473379410 1.0d0) -219)
			       (scale-float (float -8219752905572352 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8619352278838746 1.0d0) -53)
			       (scale-float (float 6580241596413982 1.0d0) -107)
			       (scale-float (float -5012077621452493 1.0d0) -161)
			       (scale-float (float 5420791254282205 1.0d0) -217)
			       (scale-float (float -8049457508581376 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8611290075458352 1.0d0) -53)
			       (scale-float (float 6117993379878867 1.0d0) -107)
			       (scale-float (float 5752090453333422 1.0d0) -161)
			       (scale-float (float 8961357552235688 1.0d0) -216)
			       (scale-float (float 6756547536617472 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8603146819336178 1.0d0) -53)
			       (scale-float (float 8127348605830121 1.0d0) -107)
			       (scale-float (float -7887192887344204 1.0d0) -161)
			       (scale-float (float 5319494234616797 1.0d0) -215)
			       (scale-float (float 8259537162674176 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8594922587119653 1.0d0) -53)
			       (scale-float (float -6092170856221856 1.0d0) -107)
			       (scale-float (float 8740726400738582 1.0d0) -162)
			       (scale-float (float -8711151914884922 1.0d0) -216)
			       (scale-float (float 8803203561996288 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8586617456218381 1.0d0) -53)
			       (scale-float (float -8174862114446858 1.0d0) -108)
			       (scale-float (float -8343560746786883 1.0d0) -162)
			       (scale-float (float -4919904534422867 1.0d0) -216)
			       (scale-float (float 8146749183688704 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8578231504803418 1.0d0) -53)
			       (scale-float (float -6577764069693440 1.0d0) -108)
			       (scale-float (float -6217787362116513 1.0d0) -162)
			       (scale-float (float -7480234698414209 1.0d0) -217)
			       (scale-float (float -8872072106082304 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8569764811806532 1.0d0) -53)
			       (scale-float (float 5086923108014672 1.0d0) -107)
			       (scale-float (float -7256306947528657 1.0d0) -161)
			       (scale-float (float 8041674859768423 1.0d0) -219)
			       (scale-float (float 8406880918700032 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8561217456919463 1.0d0) -53)
			       (scale-float (float 6298936787393783 1.0d0) -108)
			       (scale-float (float -4767967511894935 1.0d0) -162)
			       (scale-float (float -8847251687381265 1.0d0) -219)
			       (scale-float (float -7487138496512000 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8552589520593170 1.0d0) -53)
			       (scale-float (float -4903095784208212 1.0d0) -109)
			       (scale-float (float -5993354562610200 1.0d0) -163)
			       (scale-float (float 7621932199733939 1.0d0) -218)
			       (scale-float (float 8114090528079872 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8543881084037075 1.0d0) -53)
			       (scale-float (float 6707234576005423 1.0d0) -108)
			       (scale-float (float -6949817966021143 1.0d0) -163)
			       (scale-float (float 6010742482639225 1.0d0) -218)
			       (scale-float (float -5561237956722688 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8535092229218300 1.0d0) -53)
			       (scale-float (float 7044972283821195 1.0d0) -107)
			       (scale-float (float -6484078963521046 1.0d0) -164)
			       (scale-float (float 4693487461781030 1.0d0) -219)
			       (scale-float (float -7065305917292544 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8526223038860894 1.0d0) -53)
			       (scale-float (float 5688291050131270 1.0d0) -107)
			       (scale-float (float 5762907725758393 1.0d0) -162)
			       (scale-float (float 6954393126632499 1.0d0) -216)
			       (scale-float (float -6550640399876096 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8517273596445054 1.0d0) -53)
			       (scale-float (float 7467026288494722 1.0d0) -107)
			       (scale-float (float -7311528458402789 1.0d0) -163)
			       (scale-float (float 6638440854815466 1.0d0) -218)
			       (scale-float (float 5317362131927040 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8508243986206341 1.0d0) -53)
			       (scale-float (float 5718052318919608 1.0d0) -109)
			       (scale-float (float 6113951899379181 1.0d0) -163)
			       (scale-float (float -7053239345980276 1.0d0) -217)
			       (scale-float (float 7260571414298624 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8499134293134885 1.0d0) -53)
			       (scale-float (float -7818667001173624 1.0d0) -108)
			       (scale-float (float 4809289711312272 1.0d0) -165)
			       (scale-float (float -7885188792416875 1.0d0) -221)
			       (scale-float (float -6091756757581824 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8489944602974586 1.0d0) -53)
			       (scale-float (float 8590372695674546 1.0d0) -109)
			       (scale-float (float -5336072295288112 1.0d0) -166)
			       (scale-float (float 6731064684041358 1.0d0) -220)
			       (scale-float (float -4655136581353472 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8480675002222309 1.0d0) -53)
			       (scale-float (float -4526446371562791 1.0d0) -107)
			       (scale-float (float 4756672316007874 1.0d0) -161)
			       (scale-float (float -8943278991556374 1.0d0) -220)
			       (scale-float (float -5996878158888960 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8471325578127065 1.0d0) -53)
			       (scale-float (float 4642306313259215 1.0d0) -107)
			       (scale-float (float 8553146367577618 1.0d0) -161)
			       (scale-float (float -5655242195051814 1.0d0) -217)
			       (scale-float (float 7938131067076608 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8461896418689196 1.0d0) -53)
			       (scale-float (float -4553181447976997 1.0d0) -109)
			       (scale-float (float -6593791908274853 1.0d0) -163)
			       (scale-float (float 7491525231836809 1.0d0) -217)
			       (scale-float (float -7913394222759936 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8452387612659540 1.0d0) -53)
			       (scale-float (float 8801356132344547 1.0d0) -107)
			       (scale-float (float -5565388474422551 1.0d0) -161)
			       (scale-float (float -8228993466620115 1.0d0) -215)
			       (scale-float (float -4947381776957440 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8442799249538603 1.0d0) -53)
			       (scale-float (float -5933972051875175 1.0d0) -107)
			       (scale-float (float -6958466561286986 1.0d0) -162)
			       (scale-float (float -4724344086362299 1.0d0) -218)
			       (scale-float (float 5772665657425920 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8433131419575708 1.0d0) -53)
			       (scale-float (float -8446417134371795 1.0d0) -109)
			       (scale-float (float 6106723249054365 1.0d0) -163)
			       (scale-float (float -5724401613088084 1.0d0) -220)
			       (scale-float (float -5777673332195328 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8423384213768154 1.0d0) -53)
			       (scale-float (float -5291176899619174 1.0d0) -107)
			       (scale-float (float -4782794227894570 1.0d0) -162)
			       (scale-float (float 5859801279367932 1.0d0) -216)
			       (scale-float (float 6433573390663680 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8413557723860353 1.0d0) -53)
			       (scale-float (float 7246957581928310 1.0d0) -107)
			       (scale-float (float -7571526425190184 1.0d0) -161)
			       (scale-float (float 8583500343172088 1.0d0) -216)
			       (scale-float (float -6011419024031744 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8403652042342972 1.0d0) -53)
			       (scale-float (float 6821609684893107 1.0d0) -107)
			       (scale-float (float 5278119422243711 1.0d0) -162)
			       (scale-float (float 5583656122229983 1.0d0) -216)
			       (scale-float (float -8360196826890240 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8393667262452058 1.0d0) -53)
			       (scale-float (float -6617897839460155 1.0d0) -107)
			       (scale-float (float 5153678696029531 1.0d0) -161)
			       (scale-float (float 5429144206151925 1.0d0) -217)
			       (scale-float (float 5869493572206592 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8383603478168160 1.0d0) -53)
			       (scale-float (float 6394240597984013 1.0d0) -108)
			       (scale-float (float 7676731287638925 1.0d0) -163)
			       (scale-float (float -6564864277848665 1.0d0) -221)
			       (scale-float (float -5907456036175872 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8373460784215450 1.0d0) -53)
			       (scale-float (float 8321066234508797 1.0d0) -107)
			       (scale-float (float 5546630190255800 1.0d0) -164)
			       (scale-float (float -7258150702831279 1.0d0) -218)
			       (scale-float (float -5075166913626112 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8363239276060827 1.0d0) -53)
			       (scale-float (float -7563437054268512 1.0d0) -108)
			       (scale-float (float -4548139565433169 1.0d0) -162)
			       (scale-float (float -6171043120140633 1.0d0) -216)
			       (scale-float (float 6671610356039680 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8352939049913017 1.0d0) -53)
			       (scale-float (float -8981736255781014 1.0d0) -108)
			       (scale-float (float 5170276812693347 1.0d0) -164)
			       (scale-float (float 8572079675285324 1.0d0) -218)
			       (scale-float (float 6367039434194944 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8342560202721672 1.0d0) -53)
			       (scale-float (float -6052880242154884 1.0d0) -107)
			       (scale-float (float 5981767719278909 1.0d0) -161)
			       (scale-float (float 7283292585326634 1.0d0) -215)
			       (scale-float (float -6451337855336448 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8332102832176454 1.0d0) -53)
			       (scale-float (float 7857171491229206 1.0d0) -110)
			       (scale-float (float -8255170893553344 1.0d0) -166)
			       (scale-float (float 6162188545047406 1.0d0) -221)
			       (scale-float (float 4967530541088768 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8321567036706118 1.0d0) -53)
			       (scale-float (float 5726145159043778 1.0d0) -108)
			       (scale-float (float -5897748070929945 1.0d0) -163)
			       (scale-float (float -8525804628143368 1.0d0) -217)
			       (scale-float (float 4998397503438848 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8310952915477583 1.0d0) -53)
			       (scale-float (float 8593867710650143 1.0d0) -107)
			       (scale-float (float -6680313484611995 1.0d0) -163)
			       (scale-float (float 6353210804206738 1.0d0) -217)
			       (scale-float (float 8154954785619968 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8300260568395001 1.0d0) -53)
			       (scale-float (float 6756450875854190 1.0d0) -107)
			       (scale-float (float 6951770272627742 1.0d0) -162)
			       (scale-float (float 8788284451425813 1.0d0) -218)
			       (scale-float (float -5248954319699968 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8289490096098815 1.0d0) -53)
			       (scale-float (float -4511925664156885 1.0d0) -107)
			       (scale-float (float 7895328143001416 1.0d0) -161)
			       (scale-float (float 6317989146996191 1.0d0) -215)
			       (scale-float (float 7279285363269632 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8278641599964811 1.0d0) -53)
			       (scale-float (float -8598600866676053 1.0d0) -108)
			       (scale-float (float 7646998035931427 1.0d0) -163)
			       (scale-float (float -6107518997826040 1.0d0) -217)
			       (scale-float (float -8602505073524736 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8267715182103167 1.0d0) -53)
			       (scale-float (float -6340213041420117 1.0d0) -107)
			       (scale-float (float 6724262794318068 1.0d0) -161)
			       (scale-float (float 8393760923297867 1.0d0) -217)
			       (scale-float (float -5384688173449216 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8256710945357489 1.0d0) -53)
			       (scale-float (float -6771725202789936 1.0d0) -107)
			       (scale-float (float 7070420353684526 1.0d0) -162)
			       (scale-float (float 5197890020650731 1.0d0) -216)
			       (scale-float (float 8583179312791552 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8245628993303844 1.0d0) -53)
			       (scale-float (float -8821100121339757 1.0d0) -109)
			       (scale-float (float 7006208221552511 1.0d0) -163)
			       (scale-float (float 4508060286446889 1.0d0) -217)
			       (scale-float (float -7701262796455936 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8234469430249786 1.0d0) -53)
			       (scale-float (float -5892637514160882 1.0d0) -107)
			       (scale-float (float -5681973386408990 1.0d0) -161)
			       (scale-float (float 5969243766468564 1.0d0) -217)
			       (scale-float (float 5183657401876480 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8223232361233372 1.0d0) -53)
			       (scale-float (float -7777493634914173 1.0d0) -107)
			       (scale-float (float -5189369030967820 1.0d0) -161)
			       (scale-float (float 6842397883496982 1.0d0) -220)
			       (scale-float (float -7237539892559872 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8211917892022175 1.0d0) -53)
			       (scale-float (float -8733856484976210 1.0d0) -108)
			       (scale-float (float -4857152382333282 1.0d0) -166)
			       (scale-float (float 7641915463494354 1.0d0) -222)
			       (scale-float (float 7988390590939136 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8200526129112289 1.0d0) -53)
			       (scale-float (float -8183228870209481 1.0d0) -107)
			       (scale-float (float 6394798226217471 1.0d0) -162)
			       (scale-float (float 8035603526856955 1.0d0) -219)
			       (scale-float (float -7278743951638528 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8189057179727324 1.0d0) -53)
			       (scale-float (float -4787111311971082 1.0d0) -110)
			       (scale-float (float 7003826926247311 1.0d0) -164)
			       (scale-float (float -5150051672214856 1.0d0) -218)
			       (scale-float (float -6304169639870464 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8177511151817401 1.0d0) -53)
			       (scale-float (float -8025338039515614 1.0d0) -107)
			       (scale-float (float -4852092691112809 1.0d0) -161)
			       (scale-float (float -5468362093021944 1.0d0) -216)
			       (scale-float (float 4638550820208640 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8165888154058130 1.0d0) -53)
			       (scale-float (float 4949998156142078 1.0d0) -107)
			       (scale-float (float -8464337333963361 1.0d0) -162)
			       (scale-float (float 7964294201530510 1.0d0) -218)
			       (scale-float (float -5586896482205696 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8154188295849595 1.0d0) -53)
			       (scale-float (float -6677472217191581 1.0d0) -107)
			       (scale-float (float 8727903250458773 1.0d0) -161)
			       (scale-float (float 5386228110507442 1.0d0) -216)
			       (scale-float (float 8388555450335232 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8142411687315315 1.0d0) -53)
			       (scale-float (float -8579951840942254 1.0d0) -110)
			       (scale-float (float 5952643804849413 1.0d0) -165)
			       (scale-float (float -7249883042029233 1.0d0) -220)
			       (scale-float (float -6096412072738816 1.0d0) -280))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8130558439301216 1.0d0) -53)
			       (scale-float (float -6247237565047575 1.0d0) -108)
			       (scale-float (float 7741357282149559 1.0d0) -162)
			       (scale-float (float -5578500633872854 1.0d0) -216)
			       (scale-float (float 5873141117911040 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8118628663374582 1.0d0) -53)
			       (scale-float (float -8778090168280888 1.0d0) -109)
			       (scale-float (float 7436746217749520 1.0d0) -163)
			       (scale-float (float 7630381168256317 1.0d0) -217)
			       (scale-float (float -5069066174988288 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8106622471823008 1.0d0) -53)
			       (scale-float (float -8216747803830756 1.0d0) -107)
			       (scale-float (float 6304056001984601 1.0d0) -162)
			       (scale-float (float 5924872968038470 1.0d0) -217)
			       (scale-float (float -6048610326708224 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8094539977653340 1.0d0) -53)
			       (scale-float (float 8540324421498539 1.0d0) -108)
			       (scale-float (float 6922258608862064 1.0d0) -167)
			       (scale-float (float -7901865974785605 1.0d0) -221)
			       (scale-float (float 4515492721065984 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8082381294590617 1.0d0) -53)
			       (scale-float (float -5905634609941531 1.0d0) -107)
			       (scale-float (float -6901692996464097 1.0d0) -161)
			       (scale-float (float 6233038068306105 1.0d0) -215)
			       (scale-float (float 8981761373306880 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8070146537076992 1.0d0) -53)
			       (scale-float (float 7954777128849873 1.0d0) -107)
			       (scale-float (float -5682461538967622 1.0d0) -161)
			       (scale-float (float -8988660354400493 1.0d0) -215)
			       (scale-float (float -6100107372142592 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8057835820270665 1.0d0) -53)
			       (scale-float (float -5684340455847933 1.0d0) -108)
			       (scale-float (float -7717120355166554 1.0d0) -162)
			       (scale-float (float -6720192119717512 1.0d0) -218)
			       (scale-float (float 7255682615738368 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8045449260044789 1.0d0) -53)
			       (scale-float (float -5343034318546435 1.0d0) -110)
			       (scale-float (float 5934925198868450 1.0d0) -164)
			       (scale-float (float 7220118970499754 1.0d0) -220)
			       (scale-float (float 7604382017257472 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8032986972986387 1.0d0) -53)
			       (scale-float (float 6060738122016655 1.0d0) -110)
			       (scale-float (float 7553159386729597 1.0d0) -165)
			       (scale-float (float -6675526920595727 1.0d0) -220)
			       (scale-float (float 8878798832664576 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8020449076395251 1.0d0) -53)
			       (scale-float (float 7646910712788417 1.0d0) -109)
			       (scale-float (float -6241730781228944 1.0d0) -165)
			       (scale-float (float -8002249139712356 1.0d0) -219)
			       (scale-float (float 5877609275981824 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 8007835688282839 1.0d0) -53)
			       (scale-float (float -7246184498625959 1.0d0) -109)
			       (scale-float (float -8137088343486848 1.0d0) -164)
			       (scale-float (float -6573626944638042 1.0d0) -218)
			       (scale-float (float -6507015480803328 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7995146927371163 1.0d0) -53)
			       (scale-float (float 8310979817766747 1.0d0) -109)
			       (scale-float (float 7473299446962253 1.0d0) -167)
			       (scale-float (float -4891403068085003 1.0d0) -221)
			       (scale-float (float -4928869580668928 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7982382913091674 1.0d0) -53)
			       (scale-float (float -8736996093293672 1.0d0) -110)
			       (scale-float (float 5792500826087577 1.0d0) -165)
			       (scale-float (float 6862659397941285 1.0d0) -221)
			       (scale-float (float -6256259112108032 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7969543765584135 1.0d0) -53)
			       (scale-float (float -6122462417693605 1.0d0) -109)
			       (scale-float (float -6676904309874182 1.0d0) -163)
			       (scale-float (float 7692066278000649 1.0d0) -218)
			       (scale-float (float 5238455946575872 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7956629605695492 1.0d0) -53)
			       (scale-float (float 5134741344813474 1.0d0) -108)
			       (scale-float (float -4613745536456255 1.0d0) -162)
			       (scale-float (float -6227040409576694 1.0d0) -218)
			       (scale-float (float 8053490270339072 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7943640554978737 1.0d0) -53)
			       (scale-float (float -6439502272564487 1.0d0) -108)
			       (scale-float (float -8232593592811641 1.0d0) -163)
			       (scale-float (float -8961461139920910 1.0d0) -219)
			       (scale-float (float -5645007690792960 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7930576735691761 1.0d0) -53)
			       (scale-float (float 5293253478187253 1.0d0) -108)
			       (scale-float (float -6727743417874982 1.0d0) -163)
			       (scale-float (float -8452072153366346 1.0d0) -217)
			       (scale-float (float 7869116537896960 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7917438270796208 1.0d0) -53)
			       (scale-float (float -7684086171775532 1.0d0) -107)
			       (scale-float (float 8411685124468258 1.0d0) -162)
			       (scale-float (float -6126132756509931 1.0d0) -217)
			       (scale-float (float -7889183570460672 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7904225283956311 1.0d0) -53)
			       (scale-float (float 8131349739729868 1.0d0) -107)
			       (scale-float (float 6637034140521224 1.0d0) -164)
			       (scale-float (float 6550694306870995 1.0d0) -218)
			       (scale-float (float -7233564266463232 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7890937899537737 1.0d0) -53)
			       (scale-float (float 7623463201024326 1.0d0) -110)
			       (scale-float (float 6533764524387989 1.0d0) -164)
			       (scale-float (float -7808305661254231 1.0d0) -218)
			       (scale-float (float -6471689510846464 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7877576242606407 1.0d0) -53)
			       (scale-float (float -5941713289950576 1.0d0) -113)
			       (scale-float (float -5557131795313346 1.0d0) -167)
			       (scale-float (float 5890046981724174 1.0d0) -222)
			       (scale-float (float 5016407876042752 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7864140438927325 1.0d0) -53)
			       (scale-float (float 5090052289978408 1.0d0) -109)
			       (scale-float (float -5692258429067560 1.0d0) -163)
			       (scale-float (float -4805520048585976 1.0d0) -217)
			       (scale-float (float -4952641317404672 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7850630614963393 1.0d0) -53)
			       (scale-float (float -8968556689917822 1.0d0) -107)
			       (scale-float (float -6461032805259083 1.0d0) -161)
			       (scale-float (float -5147125785674737 1.0d0) -215)
			       (scale-float (float 7213398509264896 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7837046897874218 1.0d0) -53)
			       (scale-float (float -6796799480983562 1.0d0) -107)
			       (scale-float (float 8289659017936051 1.0d0) -163)
			       (scale-float (float 7919537224500868 1.0d0) -217)
			       (scale-float (float 6064981411954688 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7823389415514919 1.0d0) -53)
			       (scale-float (float 5647719797707326 1.0d0) -114)
			       (scale-float (float -6252005772837378 1.0d0) -168)
			       (scale-float (float -8509580097279105 1.0d0) -222)
			       (scale-float (float -7268668395225088 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7809658296434922 1.0d0) -53)
			       (scale-float (float 7857985603043508 1.0d0) -111)
			       (scale-float (float -5406124386166429 1.0d0) -165)
			       (scale-float (float -7222644714405805 1.0d0) -223)
			       (scale-float (float -8324453905727488 1.0d0) -280))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7795853669876749 1.0d0) -53)
			       (scale-float (float -8271733057494906 1.0d0) -110)
			       (scale-float (float 5547981887481697 1.0d0) -164)
			       (scale-float (float 6702866336981504 1.0d0) -218)
			       (scale-float (float 6887009961181184 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7781975665774802 1.0d0) -53)
			       (scale-float (float 6731546115920822 1.0d0) -107)
			       (scale-float (float 6638133694034468 1.0d0) -161)
			       (scale-float (float -8554347442337204 1.0d0) -216)
			       (scale-float (float -7133797107941376 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7768024414754142 1.0d0) -53)
			       (scale-float (float 6005052363670948 1.0d0) -107)
			       (scale-float (float 6094860705689399 1.0d0) -163)
			       (scale-float (float 5675405789834798 1.0d0) -217)
			       (scale-float (float -8415441607196672 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7754000048129257 1.0d0) -53)
			       (scale-float (float -4875899202965061 1.0d0) -107)
			       (scale-float (float -5185769273148547 1.0d0) -162)
			       (scale-float (float 6320978780778161 1.0d0) -218)
			       (scale-float (float -7041822975590400 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7739902697902825 1.0d0) -53)
			       (scale-float (float 6885578824615594 1.0d0) -107)
			       (scale-float (float 8907187678671986 1.0d0) -163)
			       (scale-float (float -8339075431974752 1.0d0) -217)
			       (scale-float (float 7380791702585344 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7725732496764478 1.0d0) -53)
			       (scale-float (float -7818211417288033 1.0d0) -107)
			       (scale-float (float -6456405933798609 1.0d0) -162)
			       (scale-float (float 8810079633059484 1.0d0) -216)
			       (scale-float (float 7997595180138496 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7711489578089543 1.0d0) -53)
			       (scale-float (float 5958610143385566 1.0d0) -109)
			       (scale-float (float 6585953111264567 1.0d0) -163)
			       (scale-float (float 7861064189197966 1.0d0) -221)
			       (scale-float (float 7301984551960576 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7697174075937797 1.0d0) -53)
			       (scale-float (float -8431721695184386 1.0d0) -109)
			       (scale-float (float 6029995679316329 1.0d0) -165)
			       (scale-float (float -4921123855682338 1.0d0) -223)
			       (scale-float (float 6272694102261760 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7682786125052197 1.0d0) -53)
			       (scale-float (float 8811647176963032 1.0d0) -108)
			       (scale-float (float 8691431362536178 1.0d0) -163)
			       (scale-float (float 8880441644193018 1.0d0) -217)
			       (scale-float (float -6070401771896832 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7668325860857618 1.0d0) -53)
			       (scale-float (float -8645153897161875 1.0d0) -107)
			       (scale-float (float 6512789306468078 1.0d0) -161)
			       (scale-float (float -8484355539904639 1.0d0) -217)
			       (scale-float (float -8839694186053632 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7653793419459571 1.0d0) -53)
			       (scale-float (float 8407034062131169 1.0d0) -107)
			       (scale-float (float 9005956094764978 1.0d0) -161)
			       (scale-float (float -5461770985431486 1.0d0) -217)
			       (scale-float (float -5644724666499072 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7639188937642932 1.0d0) -53)
			       (scale-float (float 6088799942438190 1.0d0) -108)
			       (scale-float (float 8212922076806082 1.0d0) -162)
			       (scale-float (float -5247758149286959 1.0d0) -217)
			       (scale-float (float -4718251021697024 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7624512552870645 1.0d0) -53)
			       (scale-float (float -7783483392394296 1.0d0) -107)
			       (scale-float (float -8043598484014106 1.0d0) -161)
			       (scale-float (float -7742450129971733 1.0d0) -216)
			       (scale-float (float -6829412475371520 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7609764403282432 1.0d0) -53)
			       (scale-float (float -7079592968846542 1.0d0) -107)
			       (scale-float (float -5935955209333083 1.0d0) -161)
			       (scale-float (float 4538668036895069 1.0d0) -216)
			       (scale-float (float -5583593571680256 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7594944627693494 1.0d0) -53)
			       (scale-float (float 5012472405203384 1.0d0) -112)
			       (scale-float (float 8678696578736612 1.0d0) -171)
			       (scale-float (float 5214866625493772 1.0d0) -225)
			       (scale-float (float 5448222990401536 1.0d0) -281))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7580053365593204 1.0d0) -53)
			       (scale-float (float -5532305557551308 1.0d0) -107)
			       (scale-float (float -4918257505158720 1.0d0) -162)
			       (scale-float (float -5207406790673379 1.0d0) -216)
			       (scale-float (float 7951711879168000 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7565090757143791 1.0d0) -53)
			       (scale-float (float -5410923347089996 1.0d0) -108)
			       (scale-float (float -8628228715534538 1.0d0) -162)
			       (scale-float (float -7982155484674416 1.0d0) -216)
			       (scale-float (float 8537036572852224 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7550056943179025 1.0d0) -53)
			       (scale-float (float -5769953684661576 1.0d0) -107)
			       (scale-float (float 6833859811950236 1.0d0) -162)
			       (scale-float (float -6174180304901008 1.0d0) -216)
			       (scale-float (float 7716326889488384 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7534952065202888 1.0d0) -53)
			       (scale-float (float -6782132408285718 1.0d0) -108)
			       (scale-float (float -4588137587016523 1.0d0) -165)
			       (scale-float (float -5326135934499720 1.0d0) -220)
			       (scale-float (float -5851538559860736 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7519776265388244 1.0d0) -53)
			       (scale-float (float 7471785049762459 1.0d0) -107)
			       (scale-float (float -6059669116863189 1.0d0) -163)
			       (scale-float (float -5940063433657282 1.0d0) -219)
			       (scale-float (float 7125890889678848 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7504529686575502 1.0d0) -53)
			       (scale-float (float 6892841323703210 1.0d0) -112)
			       (scale-float (float 4544841146313886 1.0d0) -166)
			       (scale-float (float 7653639258512367 1.0d0) -220)
			       (scale-float (float 7569408692584448 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7489212472271267 1.0d0) -53)
			       (scale-float (float 7307564340927176 1.0d0) -112)
			       (scale-float (float 8783286311491533 1.0d0) -167)
			       (scale-float (float -5455043666319990 1.0d0) -224)
			       (scale-float (float 8783883789139968 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7473824766646994 1.0d0) -53)
			       (scale-float (float -7619464420816061 1.0d0) -111)
			       (scale-float (float 5376884603206074 1.0d0) -165)
			       (scale-float (float 5928941415547088 1.0d0) -220)
			       (scale-float (float 8455374121992192 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7458366714537629 1.0d0) -53)
			       (scale-float (float -7171307255144825 1.0d0) -107)
			       (scale-float (float 8175016055708132 1.0d0) -161)
			       (scale-float (float 5281820716761617 1.0d0) -215)
			       (scale-float (float 8311159501185024 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7442838461440245 1.0d0) -53)
			       (scale-float (float -8755102569226029 1.0d0) -107)
			       (scale-float (float 8064787730576089 1.0d0) -163)
			       (scale-float (float 8026094972828839 1.0d0) -217)
			       (scale-float (float 5751663179956224 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7427240153512674 1.0d0) -53)
			       (scale-float (float -8603752879918352 1.0d0) -108)
			       (scale-float (float 7911734751209565 1.0d0) -165)
			       (scale-float (float 5703206095815899 1.0d0) -219)
			       (scale-float (float 8416681442410496 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7411571937572131 1.0d0) -53)
			       (scale-float (float 4930416562782670 1.0d0) -108)
			       (scale-float (float 5664227737707146 1.0d0) -162)
			       (scale-float (float 6002228034137708 1.0d0) -216)
			       (scale-float (float -4846907501363200 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7395833961093832 1.0d0) -53)
			       (scale-float (float 4983815042703658 1.0d0) -107)
			       (scale-float (float -4979969880744113 1.0d0) -161)
			       (scale-float (float -5871087828457004 1.0d0) -215)
			       (scale-float (float -8687351198859264 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7380026372209606 1.0d0) -53)
			       (scale-float (float -7821016727474824 1.0d0) -107)
			       (scale-float (float -5827108382516599 1.0d0) -168)
			       (scale-float (float -5157322064549901 1.0d0) -225)
			       (scale-float (float -8235128836849664 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7364149319706498 1.0d0) -53)
			       (scale-float (float -4829858251010421 1.0d0) -108)
			       (scale-float (float -4575860067979415 1.0d0) -162)
			       (scale-float (float 8705566695469741 1.0d0) -217)
			       (scale-float (float 8584218775715840 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7348202953025374 1.0d0) -53)
			       (scale-float (float 5364466528429990 1.0d0) -109)
			       (scale-float (float -5385055512047183 1.0d0) -164)
			       (scale-float (float 6361734986933710 1.0d0) -218)
			       (scale-float (float 8428933703860224 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7332187422259511 1.0d0) -53)
			       (scale-float (float -8458146418590874 1.0d0) -107)
			       (scale-float (float -5567640357155716 1.0d0) -161)
			       (scale-float (float -8918513373518275 1.0d0) -215)
			       (scale-float (float 6959159013900288 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7316102878153182 1.0d0) -53)
			       (scale-float (float 5038888112811017 1.0d0) -107)
			       (scale-float (float 5296374816773052 1.0d0) -164)
			       (scale-float (float -6253164519860774 1.0d0) -219)
			       (scale-float (float -5766783657050112 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7299949472100244 1.0d0) -53)
			       (scale-float (float 7632795593885122 1.0d0) -108)
			       (scale-float (float -4532413022792557 1.0d0) -162)
			       (scale-float (float -7665957245126532 1.0d0) -216)
			       (scale-float (float 4551095610851328 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7283727356142706 1.0d0) -53)
			       (scale-float (float 6052374734052898 1.0d0) -109)
			       (scale-float (float -8397589869895301 1.0d0) -163)
			       (scale-float (float 5039286009373352 1.0d0) -217)
			       (scale-float (float 7399597584678912 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7267436682969301 1.0d0) -53)
			       (scale-float (float 7986499572183919 1.0d0) -107)
			       (scale-float (float 8709385497029640 1.0d0) -161)
			       (scale-float (float 8014662541064248 1.0d0) -215)
			       (scale-float (float -7783360213237760 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7251077605914050 1.0d0) -53)
			       (scale-float (float 8334981517291728 1.0d0) -107)
			       (scale-float (float 7375650104466233 1.0d0) -163)
			       (scale-float (float 6173629469842000 1.0d0) -219)
			       (scale-float (float -4778658658516992 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7234650278954817 1.0d0) -53)
			       (scale-float (float -5364390638462068 1.0d0) -107)
			       (scale-float (float -7157105785322597 1.0d0) -162)
			       (scale-float (float 5984618093282123 1.0d0) -217)
			       (scale-float (float -6733805595688960 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7218154856711858 1.0d0) -53)
			       (scale-float (float -6801264200501575 1.0d0) -108)
			       (scale-float (float -5120886861157727 1.0d0) -163)
			       (scale-float (float 8524267759255856 1.0d0) -218)
			       (scale-float (float 6064819028230144 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7201591494446370 1.0d0) -53)
			       (scale-float (float 6606134571941243 1.0d0) -108)
			       (scale-float (float -5696846492939078 1.0d0) -162)
			       (scale-float (float 7226358878672853 1.0d0) -223)
			       (scale-float (float 7562246177685504 1.0d0) -277))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7184960348059028 1.0d0) -53)
			       (scale-float (float -7582499304585468 1.0d0) -107)
			       (scale-float (float 6745092272239030 1.0d0) -161)
			       (scale-float (float 5325527634933226 1.0d0) -220)
			       (scale-float (float 8972890568392704 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7168261574088514 1.0d0) -53)
			       (scale-float (float -4877955993986654 1.0d0) -107)
			       (scale-float (float -6575649792954184 1.0d0) -161)
			       (scale-float (float -6938160611470782 1.0d0) -216)
			       (scale-float (float -8603536429907968 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7151495329710049 1.0d0) -53)
			       (scale-float (float -4815506917589854 1.0d0) -109)
			       (scale-float (float 5641242290599654 1.0d0) -164)
			       (scale-float (float -8417705599718850 1.0d0) -220)
			       (scale-float (float 4840832930938880 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7134661772733911 1.0d0) -53)
			       (scale-float (float -6017847752979687 1.0d0) -107)
			       (scale-float (float -8695617460185062 1.0d0) -162)
			       (scale-float (float 6176165148681625 1.0d0) -217)
			       (scale-float (float 8270872401805312 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7117761061603948 1.0d0) -53)
			       (scale-float (float 7482393772340198 1.0d0) -108)
			       (scale-float (float 8465649163872175 1.0d0) -162)
			       (scale-float (float -8080110543307406 1.0d0) -216)
			       (scale-float (float 7003574694313984 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7100793355396091 1.0d0) -53)
			       (scale-float (float 5581231234277131 1.0d0) -107)
			       (scale-float (float 5176821120801589 1.0d0) -161)
			       (scale-float (float 8995859729422842 1.0d0) -215)
			       (scale-float (float 4932144053190656 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7083758813816853 1.0d0) -53)
			       (scale-float (float -6350271866355127 1.0d0) -109)
			       (scale-float (float 7928602718099880 1.0d0) -164)
			       (scale-float (float 4824946278411294 1.0d0) -219)
			       (scale-float (float -8497833842835456 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7066657597201826 1.0d0) -53)
			       (scale-float (float -5557572698368406 1.0d0) -109)
			       (scale-float (float -4935627699312564 1.0d0) -164)
			       (scale-float (float -7115034144224561 1.0d0) -218)
			       (scale-float (float 5203824039952384 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7049489866514174 1.0d0) -53)
			       (scale-float (float 5889743500293894 1.0d0) -109)
			       (scale-float (float 7906589096317472 1.0d0) -163)
			       (scale-float (float -7234212083698060 1.0d0) -218)
			       (scale-float (float -7540628548812800 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7032255783343117 1.0d0) -53)
			       (scale-float (float -6438369056191217 1.0d0) -109)
			       (scale-float (float -6365182518869508 1.0d0) -171)
			       (scale-float (float 5309542037636005 1.0d0) -230)
			       (scale-float (float 5599812451827712 1.0d0) -284))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 7014955509902409 1.0d0) -53)
			       (scale-float (float -8077716446967319 1.0d0) -108)
			       (scale-float (float 6329167020324237 1.0d0) -166)
			       (scale-float (float -8791449117706018 1.0d0) -223)
			       (scale-float (float 6176518547963904 1.0d0) -281))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6997589209028812 1.0d0) -53)
			       (scale-float (float 5024754586498263 1.0d0) -109)
			       (scale-float (float -7013631527035059 1.0d0) -163)
			       (scale-float (float 6438066485620793 1.0d0) -217)
			       (scale-float (float -8049616906584064 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6980157044180565 1.0d0) -53)
			       (scale-float (float -8471408082297477 1.0d0) -107)
			       (scale-float (float -5650375399951533 1.0d0) -162)
			       (scale-float (float 7798954431786796 1.0d0) -217)
			       (scale-float (float -8802857478946816 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6962659179435841 1.0d0) -53)
			       (scale-float (float -5284120524567405 1.0d0) -107)
			       (scale-float (float 8103036997132110 1.0d0) -162)
			       (scale-float (float -8418944709321890 1.0d0) -217)
			       (scale-float (float -8911754376773632 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6945095779491208 1.0d0) -53)
			       (scale-float (float -7230020631985237 1.0d0) -107)
			       (scale-float (float -8729130008304460 1.0d0) -161)
			       (scale-float (float -7244986705962520 1.0d0) -216)
			       (scale-float (float -5294115693002752 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6927467009660074 1.0d0) -53)
			       (scale-float (float 8363890541356943 1.0d0) -107)
			       (scale-float (float 7641557639387694 1.0d0) -161)
			       (scale-float (float -8529781507802362 1.0d0) -215)
			       (scale-float (float 7813868317630464 1.0d0) -269))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6909773035871137 1.0d0) -53)
			       (scale-float (float -6128826147983157 1.0d0) -108)
			       (scale-float (float -7985270411148689 1.0d0) -162)
			       (scale-float (float -4747232722969418 1.0d0) -217)
			       (scale-float (float -5981344472137728 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6892014024666815 1.0d0) -53)
			       (scale-float (float -5307050774979789 1.0d0) -107)
			       (scale-float (float 6534150355198809 1.0d0) -162)
			       (scale-float (float -7794201099075978 1.0d0) -217)
			       (scale-float (float 5799811176726528 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6874190143201685 1.0d0) -53)
			       (scale-float (float 6831699276871462 1.0d0) -111)
			       (scale-float (float 6569994269441010 1.0d0) -165)
			       (scale-float (float 6039155211825079 1.0d0) -222)
			       (scale-float (float 7188073050800128 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6856301559240908 1.0d0) -53)
			       (scale-float (float 5730269256517324 1.0d0) -107)
			       (scale-float (float 7502511311955837 1.0d0) -162)
			       (scale-float (float -8934221579630434 1.0d0) -216)
			       (scale-float (float 4924476284665856 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6838348441158650 1.0d0) -53)
			       (scale-float (float -6256529846772154 1.0d0) -107)
			       (scale-float (float 6949788990055632 1.0d0) -164)
			       (scale-float (float -5274624651616658 1.0d0) -218)
			       (scale-float (float -4617708658229248 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6820330957936494 1.0d0) -53)
			       (scale-float (float -6460871939863669 1.0d0) -108)
			       (scale-float (float 4607738561562238 1.0d0) -163)
			       (scale-float (float 8738499798315367 1.0d0) -218)
			       (scale-float (float 5614529372487680 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6802249279161855 1.0d0) -53)
			       (scale-float (float -6296386214088169 1.0d0) -108)
			       (scale-float (float -8828921206139670 1.0d0) -164)
			       (scale-float (float -8935639395611922 1.0d0) -218)
			       (scale-float (float -5283050418077696 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6784103575026380 1.0d0) -53)
			       (scale-float (float -6155758343732070 1.0d0) -107)
			       (scale-float (float -7834764184816714 1.0d0) -163)
			       (scale-float (float -5655570170200821 1.0d0) -219)
			       (scale-float (float -5664081777393664 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6765894016324346 1.0d0) -53)
			       (scale-float (float 7058239787845383 1.0d0) -107)
			       (scale-float (float 7374070516477953 1.0d0) -161)
			       (scale-float (float -6947421257903780 1.0d0) -216)
			       (scale-float (float 6454924456689664 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6747620774451057 1.0d0) -53)
			       (scale-float (float -7257707922049303 1.0d0) -107)
			       (scale-float (float -7075429107224891 1.0d0) -161)
			       (scale-float (float 5969459465011329 1.0d0) -215)
			       (scale-float (float -7312723756220416 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6729284021401222 1.0d0) -53)
			       (scale-float (float 7707201987390816 1.0d0) -109)
			       (scale-float (float 5142737538491299 1.0d0) -164)
			       (scale-float (float 4644279882924390 1.0d0) -218)
			       (scale-float (float -8754229690236928 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6710883929767346 1.0d0) -53)
			       (scale-float (float 4893313667710853 1.0d0) -108)
			       (scale-float (float 4729360090805088 1.0d0) -162)
			       (scale-float (float 8707005308054696 1.0d0) -216)
			       (scale-float (float 8672694993551360 1.0d0) -270))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6692420672738099 1.0d0) -53)
			       (scale-float (float -8159898852694060 1.0d0) -108)
			       (scale-float (float 8316410770739968 1.0d0) -163)
			       (scale-float (float 6356993048951430 1.0d0) -217)
			       (scale-float (float -5528950524149760 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6673894424096687 1.0d0) -53)
			       (scale-float (float -4773219099675351 1.0d0) -108)
			       (scale-float (float -5793443213505971 1.0d0) -163)
			       (scale-float (float 6620801067481707 1.0d0) -217)
			       (scale-float (float -6636733689954304 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6655305358219218 1.0d0) -53)
			       (scale-float (float 5569529363635887 1.0d0) -107)
			       (scale-float (float -8012910396303650 1.0d0) -162)
			       (scale-float (float -5648248265418359 1.0d0) -220)
			       (scale-float (float 8153552398581760 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6636653650073061 1.0d0) -53)
			       (scale-float (float -4694561351059034 1.0d0) -107)
			       (scale-float (float -8102538682924120 1.0d0) -164)
			       (scale-float (float -7786569469548835 1.0d0) -218)
			       (scale-float (float 8371892820180992 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6617939475215195 1.0d0) -53)
			       (scale-float (float -5599177568223260 1.0d0) -107)
			       (scale-float (float -6932779364632684 1.0d0) -161)
			       (scale-float (float -8360972497909144 1.0d0) -217)
			       (scale-float (float 8440581667160064 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6599163009790561 1.0d0) -53)
			       (scale-float (float 6139460555376271 1.0d0) -108)
			       (scale-float (float -8841336350505836 1.0d0) -162)
			       (scale-float (float -8249924986768898 1.0d0) -219)
			       (scale-float (float 6554656515817472 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6580324430530404 1.0d0) -53)
			       (scale-float (float -4817471423188767 1.0d0) -107)
			       (scale-float (float -6592466314970465 1.0d0) -162)
			       (scale-float (float -6430688881172527 1.0d0) -217)
			       (scale-float (float 7548766299455488 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6561423914750605 1.0d0) -53)
			       (scale-float (float 4953302629983138 1.0d0) -115)
			       (scale-float (float 8830091491978098 1.0d0) -170)
			       (scale-float (float 6566412636432061 1.0d0) -225)
			       (scale-float (float -6039243222679552 1.0d0) -279))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6542461640350018 1.0d0) -53)
			       (scale-float (float -5178910864670558 1.0d0) -107)
			       (scale-float (float 4504226005724943 1.0d0) -162)
			       (scale-float (float 8731627485611706 1.0d0) -217)
			       (scale-float (float -8496323296755712 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6523437785808790 1.0d0) -53)
			       (scale-float (float 4737722843238748 1.0d0) -107)
			       (scale-float (float 6730894629032702 1.0d0) -161)
			       (scale-float (float -8714007801572383 1.0d0) -222)
			       (scale-float (float 5055624448573440 1.0d0) -276))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6504352530186687 1.0d0) -53)
			       (scale-float (float -7746667435587544 1.0d0) -108)
			       (scale-float (float 6217885893994028 1.0d0) -162)
			       (scale-float (float -4696784861307301 1.0d0) -216)
			       (scale-float (float 6554674082054144 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6485206053121402 1.0d0) -53)
			       (scale-float (float -8336770935428512 1.0d0) -108)
			       (scale-float (float -5348661455957571 1.0d0) -162)
			       (scale-float (float 4676263914929793 1.0d0) -216)
			       (scale-float (float -8051389762469888 1.0d0) -271))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6465998534826869 1.0d0) -53)
			       (scale-float (float 8764102551217140 1.0d0) -108)
			       (scale-float (float -5344409034097828 1.0d0) -164)
			       (scale-float (float 7727976365078167 1.0d0) -219)
			       (scale-float (float 6996616368095232 1.0d0) -278))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6446730156091567 1.0d0) -53)
			       (scale-float (float -8369498756096622 1.0d0) -107)
			       (scale-float (float -6424186581703649 1.0d0) -165)
			       (scale-float (float 7285509676227856 1.0d0) -219)
			       (scale-float (float 7917470908678144 1.0d0) -275))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6427401098276813 1.0d0) -53)
			       (scale-float (float -6870464143590238 1.0d0) -107)
			       (scale-float (float -4991363196461545 1.0d0) -163)
			       (scale-float (float -5550457137190991 1.0d0) -217)
			       (scale-float (float -7394857139699712 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6408011543315061 1.0d0) -53)
			       (scale-float (float 5169145614950999 1.0d0) -109)
			       (scale-float (float 6895537652308040 1.0d0) -164)
			       (scale-float (float 7155016695131698 1.0d0) -218)
			       (scale-float (float -6303157784870912 1.0d0) -272))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6388561673708188 1.0d0) -53)
			       (scale-float (float -6100520299916709 1.0d0) -107)
			       (scale-float (float 4963552307172142 1.0d0) -165)
			       (scale-float (float 7537451794849143 1.0d0) -219)
			       (scale-float (float -5969301114978304 1.0d0) -273))
		   (%make-qd-d q0 q1 q2 q3))
	       #.(multiple-value-bind (q0 q1 q2 q3)
		     (renorm-5 (scale-float (float 6369051672525773 1.0d0) -53)
			       (scale-float (float -7843040109683798 1.0d0) -107)
			       (scale-float (float 6048680740045173 1.0d0) -161)
			       (scale-float (float 5197737643093849 1.0d0) -217)
			       (scale-float (float 6206530073919488 1.0d0) -274))
		   (%make-qd-d q0 q1 q2 q3))))
   "A table of cos(k/1024) for k = 1 to 256")


#||

Some sample test code to convert long-float data from clisp to
something that we can use to initialize our tables.

(defun convert-to-qd-parts (lf)
  (flet ((convert-rat (rat)
	   (let* ((p0 (coerce rat 'double-float))
		  (remainder rat))
	     (declare (double-float p0)
		      (rational remainder))
	     (flet ((iter (x)
		      (decf remainder (rational x))
		      (coerce remainder 'double-float)))
	       (let* ((p1 (iter p0))
		      (p2 (iter p1))
		      (p3 (iter p2))
		      (p4 (iter p3)))
		 (values p0 p1 p2 p3 p4)))))
	 (expand (f)
	   (multiple-value-bind (frac exp sign)
	       (integer-decode-float f)
	     `(scale-float (float ,(* frac sign) 1d0) ,exp))))
    (multiple-value-bind (p0 p1 p2 p3 p4)
	(convert-rat (rational lf))
      `(multiple-value-bind (q0 q1 q2 q3)
	   (renorm-5 ,(expand p0)
		     ,(expand p1)
		     ,(expand p2)
		     ,(expand p3)
		     ,(expand p4))
	 (%make-qd-d q0 q1 q2 q3)))))

(setf (long-float-digits) 256)
(convert-to-qd-parts pi)
(convert-to-qd-parts (* 2 pi))

;; etc.

;; For log2, we need twice as much precision.  Here's how we do it:

(defun convert-log2-to-qd-parts ()
  (flet ((convert-rat (rat)
	   (let* ((p0 (coerce rat 'double-float))
		  (remainder rat))
	     (declare (double-float p0)
		      (rational remainder))
	     (flet ((iter (x)
		      (decf remainder (rational x))
		      (coerce remainder 'double-float)))
	       (let* ((p1 (iter p0))
		      (p2 (iter p1))
		      (p3 (iter p2))
		      (p4 (iter p3))
		      (p5 (iter p4))
		      (p6 (iter p5))
		      (p7 (iter p6)))
		 (values p0 p1 p2 p3 p4 p5 p6 p7)))))
	 (expand (f)
	   (multiple-value-bind (frac exp sign)
	       (integer-decode-float f)
	     `(scale-float (float ,(* frac sign) 1d0) ,exp))))
    (multiple-value-bind (p0 p1 p2 p3 p4 p5 p6 p7)
	(convert-rat (rational (log (coerce 2 'long-float))))
      `((%make-qd-d ,(expand p0)
		    ,(expand p1)
		    ,(expand p2)
		    ,(expand p3))
	(%make-qd-d ,(expand p4)
		    ,(expand p5)
		    ,(expand p6)
		    ,(expand p7))))))

(setf (long-float-digits) 512)
(convert-log2-to-qd-parts)
  
;; Create sin table
(let (val)
  (dotimes (k 256)
    (push (convert-to-qd-parts (sin (* pi (/ (1+ k) 1024)))) val))
  `(make-array 256 :initial-contents (list ,@(nreverse val))))

(let (val)
  (dotimes (k 256)
    (push (convert-to-qd-parts (cos (* pi (/ (1+ k) 1024)))) val))
  `(make-array 256 :initial-contents (list ,@(nreverse val))))
||#
